set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8814999';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-6-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '4',
      NULL,
      NULL,
      '4344234',
      1,
      0,
      1,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      ' 8- 7-1988',
      0,
      NULL,
      0,
      0.754332,
      0,
      ' 4-29-1974',
      26.647050,
      0.133346,
      NULL,
      30,
      NULL,
      ' 5-22-1977',
      '10-10-1982',
      '11-17-1977',
      NULL,
      1,
      3.709523,
      1.162730,
      1,
      NULL,
      0,
      0.965314,
      NULL,
      NULL,
      NULL,
      8.648091,
      2.290479,
      16.813880,
      12,
      2,
      9.907009,
      1,
      NULL,
      4.435809,
      0,
      1,
      1,
      NULL,
      0.660945,
      1,
      0,
      1,
      0,
      2,
      1,
      NULL,
      NULL,
      3,
      2.984028,
      5,
      1,
      0,
      1,
      0,
      1,
      2,
      3,
      NULL,
      0,
      0,
      NULL,
      5,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      2.711417,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      4,
      1,
      0,
      0,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      1,
      1,
      NULL,
      1.382980,
      NULL,
      0,
      1,
      4,
      0,
      1,
      1,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      1,
      1,
      0,
      0,
      1,
      1,
      3,
      1,
      0.769960,
      0,
      ' 7- 7-1999',
      94.641770,
      ' 1-15-1998',
      NULL,
      NULL,
      1,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      0,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      0.495155,
      2.388625,
      3.179636,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      2,
      3,
      5.755800,
      NULL,
      NULL,
      NULL,
      1.060844,
      4.363321,
      0.541020,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.641584,
      NULL,
      1,
      NULL,
      0,
      0.866441,
      0.102472,
      NULL,
      37.109419,
      0.860695,
      0.556431,
      NULL,
      NULL,
      NULL,
      3,
      0.461541,
      1,
      2,
      NULL,
      0,
      3,
      NULL,
      NULL,
      0,
      3,
      2,
      1,
      2.742101,
      1.852282,
      2.258221,
      5,
      2.677217,
      1,
      1,
      4,
      NULL,
      0,
      1.510275,
      0,
      NULL,
      1.414670,
      1,
      1,
      3,
      3.447143,
      0,
      2,
      2.108301,
      0,
      1,
      1,
      3.639251,
      1.512886,
      1,
      NULL,
      2.575381,
      2.600135,
      1,
      65,
      3,
      NULL,
      NULL,
      66,
      76,
      62.906451,
      NULL,
      0,
      0.545897,
      '11201',
      '',
      '',
      1.531483,
      NULL,
      NULL,
      NULL,
      1,
      '',
      '',
      '',
      0,
      11.131192,
      49,
      6.648336,
      1.289398,
      40.838681,
      2.161337,
      2,
      3,
      2.583562,
      1.331460,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.179494,
      2.027237,
      3.409847,
      0,
      NULL,
      NULL,
      2.827372,
      0,
      0.123379,
      1.008466,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.863465,
      NULL,
      NULL,
      6,
      5,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.456917,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.018229,
      NULL,
      0.704500,
      3.103737,
      5,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.195045,
      NULL,
      NULL,
      0.660403,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.828286,
      1,
      1,
      1,
      0,
      2.270811,
      7.203090,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.762954,
      NULL,
      NULL,
      1.919615,
      NULL,
      NULL,
      1.131198,
      NULL,
      NULL,
      0.626530,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.802145,
      NULL,
      NULL,
      1.102986,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.731346,
      2.224002,
      NULL,
      0.559974,
      NULL,
      NULL,
      1,
      4,
      NULL,
      0.662096,
      NULL,
      NULL,
      0.971389,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      1.952469,
      1.693500,
      1,
      NULL,
      1,
      0.871705,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.730759,
      NULL,
      NULL,
      1.898019,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      0.170299,
      0.669318,
      3.290210,
      NULL,
      NULL,
      0.839497,
      0.076477,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.043414,
      0.313588,
      NULL,
      NULL,
      0.348185,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.155391,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      1.645268,
      0,
      NULL,
      NULL,
      0.655631,
      1.239956,
      NULL,
      NULL,
      0.958180,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.417054,
      0,
      NULL,
      NULL,
      8.572460,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      3,
      2.952448,
      15,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.693726,
      2,
      2.830741,
      NULL,
      NULL,
      NULL,
      1.205925,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      10447,
      1.755769,
      0,
      1.933228,
      1.645958,
      1.110466,
      0,
      NULL,
      0,
      NULL,
      0,
      0.854670,
      0,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.165325,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.747725,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.511735,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.294129,
      0.973776,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.731176,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.978328,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      1,
      NULL,
      1.807460,
      0.106945,
      1,
      0,
      2.890029,
      3,
      0.159216,
      NULL,
      0,
      1.911955,
      0.050790,
      NULL,
      0.333503,
      1,
      NULL,
      1.862571,
      1.613798,
      0.188768,
      NULL,
      0,
      1,
      2.084048,
      0.246096,
      3.583551,
      2,
      1.836876,
      0.237863,
      1.116909,
      NULL,
      1.381514,
      0,
      1,
      NULL,
      0,
      0,
      0,
      NULL,
      0.694417,
      1,
      1.135521,
      0.877890,
      0,
      0.658531,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2.845182,
      NULL,
      1.995212,
      NULL,
      2.703455,
      NULL,
      0.022374,
      NULL,
      NULL,
      NULL,
      0.941959,
      NULL,
      0.041236,
      NULL,
      1,
      NULL,
      1.511875,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.615337,
      3,
      NULL,
      1.014398,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.365513,
      NULL,
      1.676100,
      NULL,
      0,
      NULL,
      0.252398,
      NULL,
      1.832695,
      NULL,
      NULL,
      NULL,
      2.821270,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.966277,
      232,
      NULL,
      1,
      NULL,
      0.036752,
      NULL,
      0.338550,
      3,
      4,
      5,
      1,
      NULL,
      NULL,
      73,
      NULL,
      4,
      1.682770,
      0.648509,
      '23200',
      '',
      '',
      0.588719,
      '',
      '',
      '',
      1.777062,
      NULL,
      '',
      NULL);
commit;
end;
/


