set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8814999';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-4-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '4',
      NULL,
      NULL,
      NULL,
      2.376662,
      1,
      4,
      2,
      '0321',
      NULL,
      0,
      NULL,
      NULL,
      '11-27-1992',
      NULL,
      NULL,
      1,
      0,
      6,
      ' 2-11-1996',
      11.557133,
      NULL,
      NULL,
      38.112701,
      1,
      ' 7-15-1997',
      '10-29-1997',
      ' 6-24-2003',
      0,
      1,
      3.331752,
      0,
      0,
      1.096668,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      7.064617,
      9,
      7,
      2,
      19.532547,
      NULL,
      2,
      6.126992,
      0.593121,
      1,
      0,
      1,
      0,
      0.414580,
      0,
      NULL,
      0.934670,
      NULL,
      0,
      4,
      1,
      3,
      0.361125,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      3,
      1,
      0,
      1,
      0,
      0.358375,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      0,
      1,
      1,
      1,
      0,
      0,
      1,
      2,
      0,
      2,
      1,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      2,
      1,
      1,
      NULL,
      0,
      5,
      0,
      NULL,
      1,
      1,
      2,
      NULL,
      4,
      1,
      0,
      1,
      0,
      0,
      2,
      1,
      0,
      0,
      1,
      0,
      1,
      1,
      0.469430,
      ' 1- 1-1986',
      1.842517,
      ' 8- 0-1998',
      4.924706,
      1.238985,
      NULL,
      0,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0,
      1,
      0,
      4,
      0,
      3.855738,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      1.581182,
      2,
      5,
      NULL,
      0,
      1.194273,
      1,
      1.408428,
      1,
      1.297797,
      0,
      6,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.878474,
      5.347077,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.648318,
      0,
      1.050724,
      0.510602,
      1,
      1,
      2,
      45.562678,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.177523,
      2,
      3,
      NULL,
      NULL,
      0,
      NULL,
      2,
      1,
      1,
      0,
      NULL,
      3.063752,
      3.269362,
      NULL,
      2.610675,
      0.651988,
      8,
      2.636735,
      0.074883,
      0,
      1,
      0.661962,
      NULL,
      0,
      0,
      1,
      0,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      40,
      38,
      19.027075,
      4,
      1.510228,
      2,
      NULL,
      '',
      '',
      1.026892,
      '',
      '',
      '',
      1.459612,
      '',
      '',
      NULL,
      NULL,
      17,
      NULL,
      29,
      NULL,
      27.430890,
      2,
      3,
      2,
      1.803507,
      0,
      0.988775,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.140002,
      NULL,
      NULL,
      1.534576,
      NULL,
      NULL,
      2,
      3.101015,
      1,
      0.990384,
      NULL,
      NULL,
      0.491220,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.918672,
      NULL,
      NULL,
      1.933867,
      NULL,
      NULL,
      8.765555,
      3,
      NULL,
      0,
      0.563028,
      NULL,
      NULL,
      NULL,
      1.386676,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.782101,
      NULL,
      NULL,
      0.270868,
      NULL,
      NULL,
      1.934803,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.036835,
      NULL,
      NULL,
      0.268995,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.343957,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.943353,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.788243,
      NULL,
      NULL,
      0.978318,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.706118,
      1,
      1.326114,
      1,
      NULL,
      NULL,
      NULL,
      1.843829,
      0.141688,
      1,
      NULL,
      NULL,
      1.006137,
      NULL,
      NULL,
      0.163731,
      NULL,
      NULL,
      3,
      NULL,
      2.427710,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5,
      2,
      1.359517,
      1.406642,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.699883,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      3,
      0,
      1.243090,
      1,
      NULL,
      0.320187,
      1,
      NULL,
      NULL,
      1.846394,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      18,
      NULL,
      NULL,
      11.223796,
      NULL,
      NULL,
      10.920595,
      NULL,
      NULL,
      1.753693,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.197564,
      1.352016,
      1.676794,
      1,
      1,
      0.517367,
      3.705452,
      NULL,
      NULL,
      4.760531,
      1.739734,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      12.246055,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      13.508491,
      NULL,
      NULL,
      NULL,
      NULL,
      1.961186,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.660867,
      NULL,
      NULL,
      15,
      NULL,
      NULL,
      NULL,
      19,
      0.360848,
      NULL,
      NULL,
      NULL,
      2.774804,
      NULL,
      NULL,
      18.693830,
      1,
      NULL,
      NULL,
      15.051495,
      1.634804,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      1.728051,
      0,
      NULL,
      NULL,
      NULL,
      5.532066,
      NULL,
      NULL,
      NULL,
      3.868400,
      NULL,
      1,
      3.450514,
      3,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.944672,
      NULL,
      NULL,
      1.181914,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0,
      19157.170887,
      1179,
      0.625579,
      1.112033,
      0.916224,
      NULL,
      NULL,
      0.958713,
      NULL,
      NULL,
      1,
      1,
      1.850176,
      1.301979,
      1,
      NULL,
      1.033761,
      1,
      0.048533,
      0,
      NULL,
      1.691312,
      NULL,
      0.384169,
      NULL,
      1.221801,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1571,
      NULL,
      110.101510,
      115,
      2,
      0,
      0.087958,
      NULL,
      NULL,
      0,
      NULL,
      1.013155,
      NULL,
      1.402138,
      NULL,
      0,
      NULL,
      0.969285,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.845418,
      NULL,
      0.749387,
      NULL,
      NULL,
      NULL,
      0.318819,
      NULL,
      0.946301,
      NULL,
      1.522020,
      NULL,
      1,
      3.270475,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.420836,
      1.889895,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.742741,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.346820,
      NULL,
      0,
      NULL,
      0.386345,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      3.646646,
      0,
      1,
      1,
      1,
      0.064282,
      3.449619,
      0.269106,
      1.951689,
      1,
      1,
      1,
      1.541813,
      1.060376,
      2,
      NULL,
      3.799396,
      0,
      1.576008,
      0.466966,
      2.599888,
      1.363111,
      2,
      NULL,
      NULL,
      2,
      3,
      NULL,
      1,
      0.631262,
      0,
      NULL,
      0.772503,
      0,
      1,
      0.411372,
      1.142291,
      1,
      3.856268,
      0.341363,
      1.057041,
      1.848347,
      1.316267,
      2.021711,
      1.576396,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.065682,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.022931,
      0,
      0,
      1.267408,
      2,
      5,
      5,
      0,
      NULL,
      NULL,
      78.074740,
      72,
      1,
      1.331769,
      0,
      '03303',
      '',
      '',
      1,
      '',
      '',
      NULL,
      0,
      '',
      '',
      NULL);
commit;
end;
/


