set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8814999';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-4-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '2',
      NULL,
      NULL,
      '2313022',
      3,
      0.624386,
      NULL,
      1,
      '1422',
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      6.989787,
      ' 6-26-1987',
      NULL,
      1.916144,
      118.752010,
      NULL,
      0,
      '10-14-1974',
      ' 1-14-1984',
      '10-22-2003',
      1.996238,
      0,
      2.480005,
      0,
      0.589722,
      0.782566,
      2,
      1,
      NULL,
      NULL,
      NULL,
      9.673891,
      2.182995,
      22.578077,
      NULL,
      2,
      19,
      3,
      1,
      0,
      1,
      0,
      1,
      0.559233,
      1,
      1.826907,
      0,
      1.513078,
      1,
      0.409138,
      0,
      3,
      2,
      2,
      3,
      1,
      0,
      1,
      1,
      0,
      3,
      2,
      NULL,
      1,
      1,
      1,
      0,
      1,
      NULL,
      0,
      NULL,
      1,
      0.255776,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      1,
      NULL,
      3,
      1,
      0,
      NULL,
      5,
      4,
      1,
      7,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.270234,
      4,
      NULL,
      0,
      2,
      0,
      4,
      5,
      1,
      1,
      NULL,
      3,
      NULL,
      0,
      NULL,
      0,
      1,
      1,
      NULL,
      0,
      0,
      1,
      NULL,
      5,
      0,
      0,
      2,
      1,
      ' 5-12-1982',
      62,
      ' 9- 2-2000',
      11.557018,
      0,
      1,
      0,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      4,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      1.714580,
      3.604844,
      NULL,
      0,
      1,
      0.436329,
      2,
      0.445324,
      0.664016,
      1,
      7,
      NULL,
      2.874908,
      NULL,
      1.143308,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.721082,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.584460,
      1,
      0.750614,
      0,
      0.662388,
      0.786300,
      2,
      7.125735,
      0,
      0,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1,
      NULL,
      0,
      2,
      NULL,
      NULL,
      2,
      3,
      NULL,
      NULL,
      1,
      6,
      0,
      NULL,
      1,
      3,
      1,
      NULL,
      2.671309,
      1.023872,
      0.310236,
      1.055686,
      0,
      0,
      1,
      0,
      0,
      0.589313,
      5.302837,
      0.649501,
      NULL,
      5.104322,
      4.842008,
      7.520354,
      3,
      6,
      NULL,
      NULL,
      1.888235,
      2.262545,
      0.429145,
      NULL,
      7.520259,
      2,
      0,
      NULL,
      20,
      9,
      13.004458,
      2,
      0,
      NULL,
      '24213',
      '',
      '',
      NULL,
      NULL,
      NULL,
      '',
      0.227118,
      NULL,
      NULL,
      '',
      3,
      7,
      34,
      NULL,
      1.317945,
      46,
      3.664054,
      0,
      1,
      3.464572,
      3.524351,
      1,
      0.273203,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.385891,
      NULL,
      NULL,
      1.666610,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.267185,
      3.615261,
      NULL,
      NULL,
      NULL,
      2,
      0.751615,
      NULL,
      0.896972,
      NULL,
      NULL,
      1.017224,
      NULL,
      NULL,
      0.843721,
      NULL,
      NULL,
      0.545216,
      8,
      0,
      NULL,
      1.376158,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.629547,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.436868,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      1,
      0,
      2,
      0,
      0,
      1,
      1.907956,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.984790,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.551713,
      NULL,
      NULL,
      1.695619,
      2,
      0,
      NULL,
      3.866824,
      3,
      2,
      1,
      1.482684,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.733634,
      NULL,
      NULL,
      1.196872,
      NULL,
      NULL,
      NULL,
      1,
      1.461635,
      1,
      NULL,
      NULL,
      2,
      4,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.290111,
      2.412011,
      1.347969,
      NULL,
      NULL,
      NULL,
      NULL,
      3.570051,
      2.581087,
      NULL,
      0.113179,
      1,
      NULL,
      NULL,
      1.055090,
      NULL,
      NULL,
      1.803949,
      NULL,
      NULL,
      2,
      4.059014,
      0,
      2,
      NULL,
      NULL,
      NULL,
      2,
      3,
      0,
      1,
      NULL,
      NULL,
      0,
      0.079446,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.924164,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.957930,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.200166,
      NULL,
      NULL,
      3.867529,
      NULL,
      NULL,
      0.498784,
      0,
      NULL,
      0.644963,
      0,
      3,
      3.112296,
      NULL,
      NULL,
      1,
      1.401005,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      0.238918,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.982237,
      NULL,
      NULL,
      NULL,
      NULL,
      0.270908,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.531782,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.000904,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.563773,
      2.819717,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      2,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      3.645873,
      2,
      NULL,
      NULL,
      3.220819,
      1.029453,
      8,
      1,
      2.105109,
      23,
      7,
      0.136860,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      2.344870,
      0,
      1.162180,
      NULL,
      NULL,
      0.938665,
      NULL,
      NULL,
      1.979796,
      NULL,
      0,
      1678,
      8.584391,
      0.339789,
      1.083364,
      NULL,
      1,
      0,
      0.123436,
      0.419994,
      0.008045,
      0,
      0.655466,
      0.532928,
      0,
      0.900442,
      0,
      NULL,
      1.197806,
      NULL,
      2.771845,
      NULL,
      NULL,
      NULL,
      1.227255,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.093162,
      NULL,
      0.136290,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.501766,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.593679,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      3,
      3.391181,
      1,
      1,
      1,
      0,
      1,
      2,
      NULL,
      0.614103,
      1.467870,
      1,
      1,
      2,
      0,
      0,
      0,
      NULL,
      NULL,
      0.346776,
      0.702369,
      1.325215,
      NULL,
      NULL,
      1.575766,
      1,
      1,
      3.345287,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.020393,
      NULL,
      NULL,
      1,
      1.806865,
      NULL,
      2,
      1.488171,
      0.075039,
      1,
      NULL,
      NULL,
      1.069970,
      0.498857,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.351918,
      NULL,
      1.091420,
      NULL,
      2.728222,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.508819,
      6.491989,
      0,
      NULL,
      2,
      0.688939,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      2,
      NULL,
      0,
      NULL,
      0.810687,
      NULL,
      1.203936,
      NULL,
      1,
      NULL,
      1.561763,
      NULL,
      1.291945,
      NULL,
      2,
      NULL,
      0.169971,
      NULL,
      1.823251,
      15.941334,
      0.004389,
      1491.682460,
      NULL,
      0,
      0.754046,
      0.782046,
      1.056137,
      NULL,
      3,
      0,
      5,
      0,
      NULL,
      NULL,
      111.184965,
      99,
      3,
      0.195308,
      0.771764,
      '24143',
      '',
      '',
      1,
      NULL,
      '',
      NULL,
      NULL,
      '',
      '',
      '');
commit;
end;
/


