set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8814999';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-5-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '3', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      0,
      0.122878,
      3,
      4.018848,
      2.230561,
      2,
      NULL,
      '431',
      '00040242',
      36.921207,
      48.406086,
      '4030200',
      NULL,
      0,
      2,
      2,
      '3043',
      1.006399,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      109.659402,
      NULL,
      1.985873,
      NULL,
      ' 6-20-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      '11-26-1988',
      ' 1- 2-1993',
      '10- 0-2003',
      0,
      NULL,
      NULL,
      3.531342,
      1.271337,
      1,
      3,
      0.097127,
      0.876475,
      7.969671,
      6,
      7,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2.447940,
      2,
      4,
      0,
      0,
      0,
      0,
      0,
      0,
      NULL,
      0,
      0,
      1,
      9,
      0,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.108647,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      4,
      4,
      NULL,
      0,
      0,
      0,
      1,
      2,
      1,
      6.283620,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      0,
      2,
      0,
      0,
      3,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      1,
      4,
      0,
      NULL,
      3,
      2,
      NULL,
      0,
      NULL,
      NULL,
      3,
      4,
      NULL,
      1,
      0,
      1,
      ' 4- 0-1986',
      8.995239,
      ' 4-24-2003',
      NULL,
      1,
      2,
      0,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0,
      NULL,
      2,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      11,
      0,
      0.169184,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1.958576,
      3.752162,
      3,
      1,
      1.317823,
      NULL,
      NULL,
      0.146710,
      0,
      2.006910,
      0.919585,
      2.031786,
      NULL,
      NULL,
      NULL,
      2.198204,
      2,
      0.158750,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.326166,
      0,
      1.449585,
      NULL,
      0.841947,
      NULL,
      NULL,
      33,
      3,
      1.309111,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      3,
      3,
      3,
      1,
      1,
      1,
      NULL,
      2,
      2,
      5,
      2,
      3,
      7,
      1,
      0,
      5.350671,
      2,
      0.527771,
      0.206335,
      NULL,
      NULL,
      0.712993,
      0.502762,
      NULL,
      0,
      3.247109,
      4,
      0,
      NULL,
      8,
      4.018803,
      0,
      1.886374,
      1,
      NULL,
      3,
      2,
      2.169085,
      2.416627,
      3,
      13,
      2,
      1.698691,
      20,
      NULL,
      NULL,
      NULL,
      4,
      5,
      3.229160,
      '31413',
      '',
      '',
      0,
      '',
      NULL,
      '',
      1.661754,
      '',
      '',
      '',
      1,
      36.856052,
      105.045254,
      31.532920,
      3,
      35,
      9,
      1.943709,
      2,
      NULL,
      3.906770,
      NULL,
      0.224413,
      NULL,
      NULL,
      1.480865,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.029233,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.918105,
      3.984646,
      0,
      0,
      NULL,
      NULL,
      1.970934,
      0.233643,
      NULL,
      NULL,
      NULL,
      NULL,
      0.616691,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.535538,
      NULL,
      1,
      0,
      1.690058,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.344309,
      NULL,
      NULL,
      0.017139,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.714505,
      NULL,
      NULL,
      0.512571,
      NULL,
      NULL,
      0.937317,
      0,
      1.523982,
      0.799330,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.315127,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.725751,
      1,
      1.556820,
      NULL,
      NULL,
      7,
      1,
      1.816700,
      NULL,
      3.354378,
      1.355675,
      1.850373,
      2,
      1.643016,
      NULL,
      0.920371,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.940912,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1,
      NULL,
      0.664521,
      NULL,
      NULL,
      NULL,
      1.740069,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      1.934281,
      NULL,
      NULL,
      NULL,
      0.509756,
      2,
      0,
      0,
      0,
      5.012677,
      1.323173,
      7.449181,
      2,
      1.252305,
      NULL,
      1,
      0.408771,
      1,
      NULL,
      0,
      1,
      NULL,
      0.279490,
      1.475760,
      9.423571,
      5.161469,
      2,
      5,
      1,
      3.607718,
      NULL,
      2,
      NULL,
      1,
      1,
      0.232684,
      1,
      0,
      2.958377,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.989888,
      NULL,
      NULL,
      1.429938,
      NULL,
      NULL,
      3.692191,
      NULL,
      NULL,
      2.738574,
      2,
      NULL,
      0,
      1,
      0.097046,
      3.178984,
      5,
      NULL,
      4.240161,
      1,
      8,
      NULL,
      NULL,
      8.731014,
      2.304122,
      NULL,
      0,
      NULL,
      1,
      NULL,
      3.354885,
      3,
      3.396632,
      NULL,
      1,
      0.911663,
      1.466189,
      NULL,
      1,
      NULL,
      0.720376,
      NULL,
      0,
      NULL,
      1,
      NULL,
      3.603241,
      0,
      0,
      NULL,
      NULL,
      1.388855,
      2,
      NULL,
      2.458524,
      0.379571,
      3.100988,
      NULL,
      3,
      1.364245,
      0.809208,
      NULL,
      0.527709,
      NULL,
      1.525785,
      NULL,
      1,
      0,
      3,
      NULL,
      1.668875,
      1.742660,
      3,
      NULL,
      3.404358,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0.881101,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.186479,
      NULL,
      1.078648,
      NULL,
      NULL,
      1.463958,
      8.009539,
      NULL,
      9.300362,
      0,
      4,
      NULL,
      3,
      0.133335,
      3,
      NULL,
      2.028360,
      157.067741,
      49.332661,
      3,
      1.638237,
      0,
      0.092418,
      NULL,
      NULL,
      2,
      6.999114,
      5.842449,
      0.682190,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      223.677131,
      NULL,
      NULL,
      0.529965,
      1.621585,
      2,
      1.535080,
      0.819136,
      1,
      NULL,
      1.286857,
      0.408652,
      0,
      1,
      1,
      0,
      0,
      0,
      NULL,
      0.720286,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.313604,
      NULL,
      1,
      NULL,
      1,
      NULL,
      14,
      NULL,
      2.900024,
      7.212239,
      7,
      1,
      2,
      3.745899,
      NULL,
      0.239254,
      NULL,
      0.759314,
      NULL,
      1.884278,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.393429,
      NULL,
      0,
      NULL,
      1.194030,
      NULL,
      0.473113,
      NULL,
      NULL,
      3.058030,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.055961,
      0.468627,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.981201,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.439113,
      NULL,
      0.375847,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.112393,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      1.691793,
      1,
      NULL,
      1,
      0,
      NULL,
      1,
      0.177333,
      1.700349,
      0.521490,
      0,
      1.831843,
      0.891556,
      1.127537,
      1,
      0.021987,
      0.076378,
      0.336531,
      0,
      3.722983,
      3.753230,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.663454,
      NULL,
      1.014724,
      0,
      3,
      1.756020,
      0.446387,
      NULL,
      NULL,
      1.944429,
      0,
      NULL,
      1.248267,
      0,
      1.243397,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      2,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.233115,
      '21342',
      NULL,
      '',
      NULL,
      '',
      NULL,
      '',
      1.468373,
      '',
      '',
      '');
commit;
end;
/


