set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8814999';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-7-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '4', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      1,
      2,
      NULL,
      2,
      3.191044,
      0,
      2,
      '022',
      '01300113',
      25.137491,
      54,
      '4034302',
      8,
      1.308733,
      3,
      2,
      '3433',
      2,
      1.361627,
      NULL,
      NULL,
      ' 0- 4-1979',
      15.570120,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      ' 1- 3-1989',
      1.368781,
      1,
      3.398507,
      0.832316,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.300926,
      0.114654,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3.547908,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      1.211320,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0.863933,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1.675153,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      1,
      1,
      1,
      1,
      0,
      NULL,
      0,
      0,
      0,
      1.288072,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1.497014,
      0,
      1,
      1,
      1,
      0,
      1,
      1,
      0,
      0,
      0,
      0,
      1,
      0,
      1,
      1,
      5,
      3,
      NULL,
      0,
      0,
      1,
      0,
      2,
      NULL,
      1,
      4.878882,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      0,
      0,
      1,
      1.107952,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2,
      NULL,
      1,
      NULL,
      0.087332,
      NULL,
      NULL,
      NULL,
      1,
      0.912708,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0,
      3.390871,
      NULL,
      NULL,
      0,
      1,
      NULL,
      2.038893,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      3,
      3,
      3,
      0,
      3,
      3,
      3,
      3,
      2,
      NULL,
      6.201723,
      1.675099,
      0.059418,
      2,
      3.528375,
      NULL,
      7,
      2.285493,
      1,
      NULL,
      0.440173,
      NULL,
      NULL,
      0,
      1,
      NULL,
      2,
      2.325641,
      1.401333,
      3.897213,
      9.620537,
      6,
      7.803086,
      2.175322,
      0.497548,
      4,
      NULL,
      1,
      2,
      NULL,
      2.959508,
      43.541538,
      3,
      1.440731,
      63,
      NULL,
      NULL,
      NULL,
      4,
      5.317299,
      0,
      '01303',
      '04022',
      '',
      0,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      1.756735,
      15.131320,
      242,
      29.698118,
      0,
      16,
      3.748459,
      7.170374,
      5,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.012387,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.332839,
      0.207934,
      1,
      NULL,
      NULL,
      3.553558,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.343913,
      NULL,
      NULL,
      1.070750,
      NULL,
      NULL,
      7.022416,
      0.577483,
      NULL,
      0,
      1.638355,
      NULL,
      NULL,
      NULL,
      1.777429,
      NULL,
      NULL,
      NULL,
      1.165167,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.014006,
      NULL,
      NULL,
      1.143248,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.812207,
      NULL,
      NULL,
      0.121862,
      NULL,
      NULL,
      1.152388,
      1,
      1.897462,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.521364,
      NULL,
      NULL,
      0.122139,
      NULL,
      NULL,
      NULL,
      NULL,
      1.293473,
      NULL,
      NULL,
      NULL,
      3.891538,
      0,
      1,
      0,
      3.047305,
      1.376552,
      0,
      1,
      0.548982,
      NULL,
      6.495935,
      0.787280,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.603468,
      NULL,
      NULL,
      0.712006,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.392670,
      NULL,
      1.906279,
      0.038372,
      NULL,
      NULL,
      4,
      NULL,
      0.099831,
      3.737154,
      NULL,
      1.448781,
      0,
      NULL,
      NULL,
      1.408720,
      NULL,
      NULL,
      2,
      NULL,
      3,
      0.153090,
      0,
      0,
      3,
      1.134137,
      NULL,
      0,
      2.175377,
      0,
      3,
      1,
      1.207500,
      0,
      1.631100,
      1,
      3.243202,
      0,
      1.946767,
      3.233612,
      0,
      5.050363,
      NULL,
      1.047274,
      NULL,
      NULL,
      3,
      2,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.412129,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.123721,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.827391,
      0.906933,
      1.673877,
      NULL,
      1,
      NULL,
      NULL,
      2.376461,
      NULL,
      1,
      4,
      2.159582,
      NULL,
      12.006734,
      104.643272,
      3,
      NULL,
      1.109555,
      NULL,
      1,
      NULL,
      0.982815,
      NULL,
      0.310355,
      NULL,
      NULL,
      0.457750,
      1,
      NULL,
      0.006003,
      NULL,
      3.542438,
      NULL,
      1.653012,
      NULL,
      3,
      NULL,
      3,
      3.364197,
      0,
      NULL,
      NULL,
      0,
      3,
      NULL,
      3.444339,
      0,
      NULL,
      NULL,
      2.506155,
      1,
      1,
      NULL,
      0,
      3.655011,
      1,
      NULL,
      3,
      1.635738,
      1,
      NULL,
      0.541650,
      1,
      1,
      NULL,
      3,
      0.994899,
      1.606532,
      NULL,
      1,
      3,
      NULL,
      NULL,
      1,
      0.105048,
      2.343131,
      NULL,
      0.423113,
      0.624097,
      0,
      NULL,
      0.402412,
      1,
      NULL,
      NULL,
      3,
      6.567486,
      1.963504,
      NULL,
      0,
      1,
      8,
      NULL,
      0.034804,
      356,
      49,
      NULL,
      5,
      0,
      NULL,
      NULL,
      NULL,
      2,
      24,
      0,
      1.805835,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.777126,
      NULL,
      0,
      159.328732,
      NULL,
      0.842786,
      3,
      NULL,
      1,
      1.080234,
      1.160062,
      0,
      2.619369,
      1,
      1.000596,
      1,
      0,
      NULL,
      0,
      1.469871,
      1,
      1,
      NULL,
      NULL,
      1.044817,
      NULL,
      1.933055,
      NULL,
      0,
      NULL,
      3,
      NULL,
      1,
      NULL,
      10,
      NULL,
      2.400321,
      NULL,
      6.364092,
      0,
      2.432861,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.413808,
      NULL,
      0,
      NULL,
      0.068241,
      NULL,
      2.821269,
      NULL,
      0.107956,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.118827,
      NULL,
      1.997306,
      NULL,
      NULL,
      1.496870,
      1.767204,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.543001,
      1.846085,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.816519,
      0,
      1,
      0.088384,
      NULL,
      NULL,
      1,
      1.168048,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2.315332,
      1.810916,
      NULL,
      0,
      0,
      1,
      0,
      1.700865,
      0.454047,
      1.715883,
      1.485637,
      0.375700,
      0.922732,
      2.323362,
      NULL,
      1.689983,
      1,
      1.376111,
      0.871208,
      1,
      3.435369,
      1,
      1,
      3,
      1,
      NULL,
      1,
      NULL,
      3.196079,
      3,
      3.964079,
      1.039143,
      NULL,
      0.379499,
      0,
      3.032412,
      0.036782,
      1,
      1,
      0.350460,
      0,
      1.425418,
      0,
      0,
      0.217641,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.493408,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.194798,
      1.205582,
      1.517197,
      NULL,
      NULL,
      NULL,
      2,
      4,
      3,
      NULL,
      NULL,
      NULL,
      86,
      100,
      1,
      5,
      NULL,
      '11320',
      '40122',
      NULL,
      1,
      '',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


