set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8612598';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-3-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '1',
      NULL,
      NULL,
      '4232101',
      1.067679,
      0,
      0,
      NULL,
      '2400',
      3.517410,
      0,
      NULL,
      NULL,
      NULL,
      45.797821,
      NULL,
      4,
      3,
      0.257791,
      ' 1- 2-1976',
      30,
      3,
      142.255207,
      50,
      1,
      ' 8- 5-1990',
      ' 0-20-1981',
      ' 1-20-1976',
      NULL,
      3.701548,
      3,
      3,
      1.260961,
      2.126512,
      8,
      1,
      0,
      104,
      6,
      13.488467,
      7,
      NULL,
      6.720721,
      NULL,
      15,
      4,
      3,
      5,
      3.783430,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      3,
      1,
      3,
      NULL,
      0,
      1,
      1,
      1,
      3.471181,
      1,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      0,
      0.267725,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      2,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      1.895497,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      0,
      4,
      5,
      NULL,
      0,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      1,
      0,
      1,
      0.087829,
      NULL,
      0.443166,
      0,
      3,
      0,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1,
      0,
      1,
      2,
      4,
      5,
      NULL,
      NULL,
      2,
      3,
      3,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      13.153289,
      0,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      15.928826,
      1.767577,
      2,
      0,
      0,
      0,
      NULL,
      2,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1.364856,
      1.207722,
      NULL,
      6,
      4,
      NULL,
      9,
      9.992343,
      2.276313,
      NULL,
      NULL,
      NULL,
      1.505380,
      15.767747,
      3,
      2,
      0,
      0,
      9.492246,
      ' 8-11-1980',
      4.275056,
      ' 9- 6-1987',
      3.041198,
      1.337530,
      0,
      NULL,
      1,
      0,
      0,
      3.254729,
      1.424304,
      0,
      1,
      0,
      41.325478,
      1.179161,
      1.857946,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      2,
      3,
      1,
      2,
      NULL,
      2,
      NULL,
      1,
      3,
      NULL,
      1,
      0,
      NULL,
      1.497673,
      1,
      1,
      0,
      1,
      0,
      0,
      1,
      0,
      1.938009,
      1.257807,
      0,
      0,
      NULL,
      5,
      0.928375,
      11,
      3.094397,
      NULL,
      4.289476,
      11,
      4,
      4,
      3.300109,
      4.015335,
      NULL,
      1,
      3.571000,
      63,
      NULL,
      1,
      NULL,
      NULL,
      76,
      13.418531,
      3,
      NULL,
      0,
      '',
      '',
      '',
      3.860045,
      '03401',
      '',
      '',
      0.001295,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.870644,
      0.715340,
      1.498515,
      1,
      3.238675,
      1,
      NULL,
      NULL,
      NULL,
      0,
      23,
      8,
      1.146946,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.738525,
      NULL,
      NULL,
      0.892931,
      0.402813,
      NULL,
      0.046084,
      0,
      NULL,
      NULL,
      0.674524,
      1.217369,
      1.963243,
      0.233099,
      1.942351,
      1.410504,
      0.373947,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      3.923469,
      0,
      0,
      NULL,
      NULL,
      0.199160,
      0.623940,
      1,
      1.761679,
      1.164038,
      1,
      1.728647,
      0,
      NULL,
      0.026109,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.337253,
      2,
      NULL,
      1,
      NULL,
      0.903945,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.225266,
      NULL,
      0,
      NULL,
      1.702613,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.981989,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0,
      2,
      1,
      1.744004,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      0,
      0,
      1,
      0.922904,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      6,
      0,
      0,
      4,
      NULL,
      5.034816,
      2.541294,
      2,
      1,
      1.761390,
      1.374358,
      1.791888,
      0.811923,
      NULL,
      NULL,
      1.694136,
      1,
      1,
      1,
      NULL,
      0,
      NULL,
      1,
      3,
      1,
      NULL,
      3.314517,
      3.941844,
      3.831502,
      0.117973,
      1.284791,
      NULL,
      0.298285,
      0,
      0.673243,
      1,
      2.881021,
      0,
      1.812649,
      0.785405,
      2,
      NULL,
      1.740746,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.786745,
      2,
      0,
      0.993519,
      NULL,
      0.530243,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      2,
      NULL,
      1.579839,
      NULL,
      0.502270,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      59,
      2,
      NULL,
      0,
      0.635007,
      2.991386,
      0,
      1,
      1.098555,
      1,
      2,
      NULL,
      2.044553,
      2,
      0.979205,
      21.203436,
      15.884374,
      3,
      1,
      1,
      '',
      '',
      '',
      NULL,
      '12100',
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


