set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9329516';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-11-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '0',
      NULL,
      NULL,
      '0211202',
      3,
      NULL,
      3,
      3,
      '2244',
      2,
      1.107609,
      NULL,
      NULL,
      ' 2-10-1995',
      NULL,
      NULL,
      4,
      1.744688,
      1,
      ' 8-23-1998',
      33.850922,
      3.053805,
      322,
      NULL,
      NULL,
      ' 4-20-1998',
      NULL,
      ' 1-17-1985',
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      1,
      0,
      0.227571,
      5,
      1,
      12.347149,
      3.066622,
      13.195862,
      36.630514,
      2,
      0.883546,
      3,
      1,
      3.350314,
      1,
      1,
      0,
      0.602864,
      1.003203,
      0.305352,
      0,
      0,
      1,
      1.944139,
      0,
      2,
      1,
      1,
      3,
      0,
      0,
      NULL,
      3,
      NULL,
      0,
      0,
      1,
      0,
      0,
      3,
      NULL,
      NULL,
      0,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4,
      0,
      0.848601,
      2.146369,
      0.458100,
      0,
      1,
      3.327498,
      0,
      2.712026,
      1,
      1,
      1,
      2.304900,
      0.327632,
      0.629215,
      0.062500,
      0.318161,
      1.836186,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      2.254552,
      1,
      NULL,
      NULL,
      0.158108,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      0,
      5,
      0,
      0,
      1,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      3,
      0,
      0,
      0,
      NULL,
      0,
      1,
      1,
      0,
      1,
      NULL,
      0,
      0,
      3,
      1,
      3,
      0,
      NULL,
      1,
      1,
      1.787398,
      1.654638,
      ' 0-22-1983',
      43.211886,
      ' 2- 7-2001',
      33,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1.769080,
      7.769997,
      NULL,
      NULL,
      NULL,
      NULL,
      0.113225,
      4,
      0.777377,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.853782,
      0,
      0.439326,
      1.799696,
      0,
      0.284717,
      1.035670,
      0,
      8,
      0.564977,
      0.011204,
      NULL,
      NULL,
      NULL,
      0,
      0.867638,
      NULL,
      1,
      2,
      0,
      0,
      1,
      1,
      3,
      0,
      3,
      2,
      2.663906,
      NULL,
      1,
      0,
      1.633578,
      1,
      NULL,
      0,
      1.813043,
      NULL,
      NULL,
      NULL,
      0.212540,
      1.229044,
      1,
      0,
      0,
      0,
      1.949168,
      7,
      2.324976,
      1.782950,
      11,
      0,
      NULL,
      3.377769,
      3,
      NULL,
      3,
      2,
      3.116984,
      27,
      0,
      NULL,
      NULL,
      13,
      65,
      NULL,
      NULL,
      1.393965,
      1,
      '30232',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1,
      '',
      NULL,
      NULL,
      NULL,
      23,
      0.214041,
      8,
      3,
      29,
      NULL,
      3.492172,
      NULL,
      NULL,
      NULL,
      2.624658,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.303799,
      3,
      NULL,
      1.380238,
      2,
      2,
      1.545392,
      0,
      1,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.189004,
      3,
      2.687968,
      3.474537,
      2.318156,
      1.067945,
      0.609029,
      NULL,
      NULL,
      NULL,
      7.587832,
      1.019231,
      NULL,
      0.753093,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.409845,
      0,
      0.365129,
      NULL,
      3,
      0.691325,
      NULL,
      NULL,
      3,
      0.027779,
      0.765170,
      3.255909,
      0,
      1,
      2,
      NULL,
      0,
      3.197073,
      NULL,
      NULL,
      1.548363,
      1.967951,
      0,
      2.462517,
      1.999872,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.331999,
      NULL,
      4,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.020564,
      2,
      NULL,
      0,
      NULL,
      NULL,
      4,
      NULL,
      0.875134,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.495864,
      NULL,
      NULL,
      0.992621,
      NULL,
      NULL,
      1,
      3.040702,
      3,
      NULL,
      4.759766,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.170531,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      4.276165,
      1,
      3.681502,
      2.634429,
      3,
      2,
      0.253370,
      NULL,
      2.417762,
      2.856618,
      0,
      NULL,
      3,
      2.343217,
      0.524412,
      0,
      3.405666,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.316732,
      NULL,
      1,
      1.586310,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.867144,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.530331,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.878409,
      NULL,
      NULL,
      3.864022,
      NULL,
      NULL,
      0.680830,
      1.492432,
      NULL,
      1.560085,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.418224,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.787406,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.293975,
      NULL,
      NULL,
      NULL,
      0.256228,
      NULL,
      NULL,
      NULL,
      5.050773,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.406373,
      0.850095,
      0.931245,
      1.929826,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.454463,
      NULL,
      NULL,
      NULL,
      1.230679,
      0.845038,
      1,
      NULL,
      NULL,
      0.921834,
      NULL,
      1.076985,
      1,
      0.264442,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      0.098359,
      1.217710,
      1,
      3.853714,
      0.721453,
      1.177870,
      0.722438,
      1.083138,
      0.711081,
      0.671032,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1.985200,
      NULL,
      0.748722,
      NULL,
      1,
      NULL,
      3,
      NULL,
      0,
      NULL,
      0.566073,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.278068,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.671528,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.564565,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.829457,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.541879,
      0.134401,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.451961,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.100856,
      1.532429,
      1.433825,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      NULL,
      0,
      NULL,
      1,
      20.019716,
      6,
      0.233647,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1.461640,
      0,
      0,
      1.794362,
      2,
      NULL,
      2,
      1.151895,
      0.154433,
      2.813657,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2.699466,
      1,
      NULL,
      2,
      3,
      NULL,
      2,
      3.308830,
      NULL,
      0,
      NULL,
      NULL,
      0,
      2.525856,
      NULL,
      0.763093,
      1.459264,
      NULL,
      1.305514,
      0,
      NULL,
      1.732888,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.377323,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.531191,
      NULL,
      2,
      NULL,
      1.718630,
      NULL,
      1.366169,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.904717,
      0.803841,
      0.398459,
      3.697556,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.390782,
      NULL,
      3,
      NULL,
      1,
      NULL,
      0.417075,
      NULL,
      1.748506,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.297911,
      NULL,
      1.461033,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      4,
      NULL,
      0,
      NULL,
      NULL,
      44,
      69.685574,
      1,
      NULL,
      NULL,
      '14412',
      '',
      '',
      1,
      '',
      '',
      '',
      1.779114,
      '',
      '',
      NULL);
commit;
end;
/


