set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9414576';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-10-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '3',
      NULL,
      NULL,
      '3043111',
      2.626973,
      0.499616,
      4,
      NULL,
      NULL,
      1.949704,
      1.457169,
      NULL,
      NULL,
      NULL,
      35,
      NULL,
      NULL,
      NULL,
      1.624549,
      ' 3- 2-1975',
      9,
      0.354719,
      340,
      NULL,
      5,
      NULL,
      NULL,
      ' 0-26-1996',
      1,
      2.344993,
      1,
      NULL,
      1,
      3,
      0,
      0.976356,
      0.372450,
      NULL,
      7,
      5.764183,
      0.132247,
      105.363538,
      2,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1,
      NULL,
      0,
      1.564657,
      0.711276,
      1,
      1,
      1,
      NULL,
      1,
      1,
      0,
      NULL,
      1,
      0.875922,
      3,
      0,
      NULL,
      0,
      0,
      1,
      2,
      1,
      3,
      NULL,
      NULL,
      0,
      1.767133,
      0,
      NULL,
      1,
      2,
      NULL,
      NULL,
      NULL,
      1.247117,
      NULL,
      NULL,
      NULL,
      1,
      1.397596,
      0.168445,
      1,
      NULL,
      NULL,
      1,
      1,
      1.488527,
      0.677159,
      0.095825,
      1,
      1.590062,
      0.826118,
      1.242364,
      2.780765,
      0,
      1,
      NULL,
      0,
      0,
      2,
      1,
      0,
      4.083869,
      1.327630,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1,
      2,
      NULL,
      0,
      1,
      0,
      1,
      NULL,
      1,
      1,
      1,
      0,
      1,
      1,
      1,
      1.320571,
      NULL,
      1.902384,
      1,
      1,
      1,
      4,
      1,
      1,
      5,
      0,
      4,
      0,
      1,
      1,
      5,
      0,
      1,
      NULL,
      1,
      2,
      1,
      0,
      0,
      5,
      0,
      1,
      1,
      0.380480,
      3.887066,
      ' 4- 4-1984',
      NULL,
      ' 6-20-1989',
      10.070351,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      0,
      NULL,
      1,
      1.603634,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      95,
      3.270802,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      2.426848,
      0,
      0.938951,
      1.688106,
      0,
      NULL,
      5.042894,
      5.597335,
      2,
      2.785808,
      3.116736,
      0.934381,
      NULL,
      NULL,
      0,
      NULL,
      1.052344,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.143753,
      1,
      0.132602,
      0.529976,
      NULL,
      NULL,
      1,
      2,
      15,
      1.134035,
      0.295064,
      NULL,
      NULL,
      NULL,
      3,
      0.905770,
      1.253530,
      1,
      3,
      2,
      3,
      3,
      0,
      2,
      1,
      0,
      3,
      NULL,
      15.748720,
      4.583551,
      50.320858,
      105.911530,
      154,
      137.759037,
      198,
      40,
      169,
      136.398045,
      129.904024,
      62,
      NULL,
      85,
      0,
      5.728025,
      8,
      NULL,
      0.908365,
      0,
      NULL,
      NULL,
      10,
      6,
      4.238624,
      0.198337,
      0.488527,
      3.062634,
      NULL,
      3.860977,
      NULL,
      1,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      5,
      4.737904,
      3.123811,
      NULL,
      '',
      NULL,
      1.657359,
      NULL,
      '',
      '',
      1,
      '',
      NULL,
      '',
      0.506230,
      6.447506,
      5,
      28,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.357305,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.564963,
      NULL,
      NULL,
      1,
      2,
      0.731073,
      3.298314,
      NULL,
      NULL,
      1.137043,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0.353597,
      2,
      3.312650,
      3,
      2.697501,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.764527,
      1,
      0.481475,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1,
      1.005861,
      1,
      0,
      0,
      0,
      1,
      1,
      0.650596,
      1.441114,
      1,
      1.684903,
      2.488504,
      2.421062,
      1.004352,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      6,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.155557,
      1,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.301949,
      0,
      2.824729,
      1,
      NULL,
      NULL,
      0.183447,
      NULL,
      NULL,
      1.716694,
      NULL,
      NULL,
      1.099697,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.353018,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.556635,
      1.825640,
      1,
      NULL,
      NULL,
      2.223991,
      NULL,
      3,
      1,
      5,
      NULL,
      0.351539,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.056362,
      1,
      NULL,
      1,
      NULL,
      NULL,
      2,
      2,
      0.776453,
      NULL,
      1.243706,
      1,
      NULL,
      NULL,
      0.884894,
      0.572194,
      1.271218,
      2,
      2,
      0,
      NULL,
      4.493477,
      0,
      NULL,
      0.687077,
      NULL,
      NULL,
      0.920918,
      2,
      1,
      1,
      1,
      0.298861,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.521130,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.637230,
      NULL,
      NULL,
      0.254526,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.182381,
      0,
      0,
      1.308524,
      0.895090,
      0,
      1.564486,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.763743,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.867302,
      NULL,
      NULL,
      NULL,
      8.151342,
      NULL,
      NULL,
      1.233385,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      3.685423,
      24.941720,
      3.405653,
      0.398399,
      NULL,
      NULL,
      0.183624,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.090608,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      321,
      8,
      1.473745,
      1.374616,
      0.664592,
      1.652806,
      0.628628,
      0.289421,
      1,
      0.687331,
      0,
      0,
      0,
      0.614034,
      1,
      1.980504,
      1.523991,
      0,
      0,
      1.572258,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.795129,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.591658,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.492146,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.473855,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.193061,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.973160,
      1.200412,
      1,
      0.539411,
      0,
      NULL,
      NULL,
      NULL,
      0.104062,
      1,
      1.537053,
      0,
      NULL,
      1.217120,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      1,
      NULL,
      1,
      3,
      0,
      NULL,
      1,
      3.587091,
      0,
      0,
      0.532884,
      1.074155,
      0.772947,
      1,
      NULL,
      NULL,
      0,
      1.963636,
      0,
      1.889440,
      1.305161,
      NULL,
      1,
      0.936788,
      0,
      0.732247,
      1,
      1,
      0,
      NULL,
      0,
      NULL,
      0,
      1.496300,
      1.631786,
      0.454669,
      3,
      2,
      1.528080,
      1.241322,
      0.969183,
      1,
      NULL,
      0.140557,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.730220,
      NULL,
      1,
      NULL,
      0,
      NULL,
      4,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      80.859781,
      NULL,
      2,
      NULL,
      1,
      '14322',
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


