set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7515184';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-10-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '4',
      NULL,
      NULL,
      '1411133',
      0,
      0,
      3,
      NULL,
      '4004',
      3.845915,
      1,
      NULL,
      NULL,
      ' 5-24-1979',
      8.230025,
      NULL,
      3,
      2.951808,
      NULL,
      '11-28-1977',
      1.670995,
      0,
      140,
      19.458876,
      1,
      '10-27-1999',
      ' 4-24-2003',
      ' 9-16-1994',
      0,
      NULL,
      0.661313,
      1.208627,
      1.030586,
      0,
      NULL,
      NULL,
      0,
      137,
      2,
      8.284801,
      0.166732,
      6.469780,
      21,
      NULL,
      21.807911,
      4,
      NULL,
      10.396649,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.833768,
      1,
      0,
      1.237295,
      0,
      0,
      0,
      2,
      NULL,
      3.947978,
      3,
      1,
      5,
      0,
      NULL,
      4,
      4,
      1,
      3,
      NULL,
      1,
      0,
      NULL,
      2,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4,
      0,
      1.378672,
      0,
      NULL,
      0,
      2.862179,
      1.431242,
      2.185739,
      1.215114,
      0.924555,
      NULL,
      2.083075,
      1.202646,
      NULL,
      1.014402,
      NULL,
      0,
      1,
      2,
      NULL,
      NULL,
      6.903639,
      2,
      NULL,
      4.954827,
      0.408044,
      NULL,
      NULL,
      1.530608,
      NULL,
      NULL,
      NULL,
      2,
      1,
      3,
      4,
      5,
      NULL,
      NULL,
      2,
      NULL,
      0,
      2,
      0,
      8.642738,
      0,
      0,
      1,
      NULL,
      1,
      NULL,
      0.009653,
      1,
      3,
      1,
      1,
      3,
      5,
      NULL,
      1,
      NULL,
      NULL,
      3,
      0,
      NULL,
      0,
      3,
      3,
      NULL,
      2,
      1,
      0,
      NULL,
      0,
      NULL,
      5,
      1,
      2.708273,
      1,
      '11-23-1985',
      83.184705,
      '10-12-1997',
      187,
      2,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.111600,
      1.904740,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.653541,
      0,
      1,
      1,
      2.992321,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.889783,
      0.564011,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.815233,
      1.951555,
      0,
      1,
      1.633595,
      1,
      1,
      3.851330,
      NULL,
      2,
      1.888409,
      6,
      19,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      11,
      3,
      44.589846,
      NULL,
      127.248142,
      0.568597,
      0.476347,
      NULL,
      1,
      NULL,
      1,
      1,
      0,
      1,
      0,
      NULL,
      1.861854,
      0,
      2.070909,
      0,
      2,
      4.950396,
      NULL,
      1.984776,
      NULL,
      0.995944,
      1,
      2.146544,
      3,
      2.208179,
      NULL,
      1,
      2,
      NULL,
      29,
      22,
      NULL,
      4,
      1,
      0.708040,
      NULL,
      NULL,
      '',
      NULL,
      '320',
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      8.863026,
      109,
      30.866262,
      NULL,
      2,
      0,
      5.893304,
      0,
      0.340704,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.600416,
      3,
      3.887406,
      1.383190,
      NULL,
      NULL,
      1.842053,
      NULL,
      NULL,
      2,
      3.318661,
      NULL,
      2,
      1,
      1.241579,
      0,
      3,
      1,
      0.725498,
      NULL,
      NULL,
      1.610017,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.181104,
      NULL,
      NULL,
      NULL,
      5,
      2,
      3,
      0.102296,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.522515,
      1,
      NULL,
      0.933888,
      NULL,
      NULL,
      1.265099,
      NULL,
      NULL,
      NULL,
      NULL,
      1.777287,
      NULL,
      1,
      0,
      NULL,
      1.655897,
      1,
      2,
      1,
      0.062147,
      NULL,
      2.239545,
      0,
      0.619712,
      0.264484,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.385557,
      NULL,
      NULL,
      4.262209,
      3,
      7,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.892982,
      NULL,
      NULL,
      NULL,
      1.001423,
      NULL,
      NULL,
      0.798428,
      0,
      3.476536,
      1.589760,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.224637,
      1,
      1.060061,
      2,
      1.529373,
      NULL,
      3,
      NULL,
      1.723642,
      1.986370,
      NULL,
      NULL,
      0.203330,
      NULL,
      NULL,
      0.697512,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.857655,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.248774,
      0.575188,
      7,
      1,
      0,
      7.883978,
      4,
      2.194535,
      NULL,
      NULL,
      NULL,
      3.762542,
      NULL,
      0,
      1.741631,
      1,
      2,
      NULL,
      NULL,
      NULL,
      3,
      6,
      1.191725,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      3,
      1.769017,
      2,
      2.412343,
      9,
      0.623401,
      9.204469,
      6,
      4.414434,
      0.149047,
      NULL,
      2,
      NULL,
      1,
      1.422016,
      NULL,
      NULL,
      1,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.812875,
      NULL,
      NULL,
      1.902043,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.859534,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      0.854875,
      NULL,
      0.907389,
      0,
      NULL,
      3.711709,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      83,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.338019,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.765975,
      NULL,
      NULL,
      NULL,
      1.419843,
      NULL,
      NULL,
      NULL,
      3.540007,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.377396,
      3.260090,
      NULL,
      4,
      0,
      NULL,
      3,
      3.858067,
      3,
      5.161945,
      NULL,
      NULL,
      NULL,
      3.659472,
      21,
      0.813056,
      3,
      NULL,
      1,
      0.996218,
      NULL,
      NULL,
      NULL,
      16.683320,
      1,
      NULL,
      1.073709,
      NULL,
      1.490116,
      NULL,
      1,
      NULL,
      NULL,
      0.039101,
      0,
      1.572021,
      0,
      NULL,
      0,
      0,
      0,
      1.870757,
      1,
      0,
      0.767662,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.150784,
      NULL,
      2,
      3,
      2.907975,
      0.659915,
      3.529623,
      NULL,
      1.273347,
      NULL,
      NULL,
      1,
      0.080858,
      NULL,
      0,
      0,
      NULL,
      0,
      1,
      NULL,
      0,
      0.447702,
      NULL,
      0,
      1,
      NULL,
      2.871159,
      3.723807,
      NULL,
      NULL,
      3,
      NULL,
      2.951457,
      3,
      NULL,
      0.664993,
      2,
      NULL,
      1,
      0.021644,
      NULL,
      3.931899,
      0,
      1.562990,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.922966,
      NULL,
      0,
      NULL,
      NULL,
      4,
      0,
      3.500019,
      0.130813,
      2.645258,
      61.468678,
      22,
      NULL,
      2,
      3.201256,
      '20210',
      '',
      '',
      1.849921,
      NULL,
      '',
      '',
      0.531468,
      '',
      NULL,
      NULL);
commit;
end;
/


