set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8109594';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-3-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '1',
      NULL,
      NULL,
      '2320213',
      1,
      0,
      3,
      2,
      '4344',
      1.545025,
      1.034308,
      NULL,
      NULL,
      ' 0-11-1993',
      0.791616,
      NULL,
      1,
      2,
      NULL,
      ' 6-26-1975',
      67,
      1.363859,
      163,
      11.202533,
      NULL,
      ' 8-17-1991',
      NULL,
      ' 0-13-1995',
      2,
      3.855452,
      0,
      0.697195,
      0,
      1,
      NULL,
      0,
      NULL,
      6.812670,
      NULL,
      12,
      1,
      121,
      148.084608,
      2,
      24.789796,
      NULL,
      3,
      2.932220,
      1,
      1,
      NULL,
      1.025702,
      0,
      0,
      1.377147,
      NULL,
      1,
      NULL,
      0,
      4,
      2,
      4,
      NULL,
      4,
      3,
      4,
      4,
      3,
      3,
      3,
      1,
      NULL,
      0,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.482871,
      NULL,
      NULL,
      NULL,
      2,
      2,
      0,
      0,
      0,
      NULL,
      1.305732,
      0,
      0.321602,
      1,
      1.656605,
      0,
      NULL,
      1.467188,
      1,
      NULL,
      1.954344,
      1.232012,
      4,
      0,
      2,
      7,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      4,
      2,
      0,
      5,
      2,
      5,
      0,
      0,
      NULL,
      3,
      1,
      NULL,
      4,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.883608,
      1,
      5,
      1,
      1,
      NULL,
      0,
      0,
      1,
      0,
      1,
      4,
      1,
      2,
      NULL,
      3,
      4,
      1,
      3,
      1,
      5,
      4,
      5,
      1,
      NULL,
      NULL,
      1,
      3,
      ' 2-26-1974',
      87.155571,
      '10-29-1975',
      NULL,
      0.593170,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      2,
      2,
      1,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.040361,
      1,
      4,
      1,
      NULL,
      0.214079,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1,
      NULL,
      0,
      1.179002,
      0.971983,
      2,
      106.497710,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      0,
      NULL,
      2,
      0,
      1,
      0,
      3.997940,
      NULL,
      NULL,
      1,
      1.930044,
      1,
      3,
      0,
      0,
      1.147490,
      0,
      1.066007,
      1.338493,
      2,
      0,
      3,
      0,
      2.025315,
      0.559126,
      8,
      NULL,
      5.271435,
      4.114510,
      8.596863,
      5,
      2,
      2.725223,
      NULL,
      3.892819,
      1.849366,
      1,
      12,
      NULL,
      3,
      NULL,
      23,
      8,
      59,
      NULL,
      1,
      NULL,
      '01211',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0,
      NULL,
      '',
      '',
      2.753649,
      8,
      80.275632,
      27,
      3.022354,
      29,
      1,
      11.079999,
      3,
      0.612177,
      NULL,
      NULL,
      0,
      1,
      1.670374,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      0,
      1.161379,
      0,
      1.594243,
      NULL,
      NULL,
      0,
      3,
      1,
      1.331227,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.724851,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.554288,
      NULL,
      NULL,
      5.589863,
      2,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.492607,
      NULL,
      NULL,
      1.670435,
      NULL,
      NULL,
      1.322544,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.001140,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.120782,
      0,
      0,
      1,
      1.615512,
      0.991264,
      NULL,
      1.646067,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.889134,
      NULL,
      NULL,
      1,
      1.891231,
      1.992155,
      NULL,
      1.385215,
      1,
      0,
      NULL,
      NULL,
      4,
      2.393471,
      1.663404,
      0.769497,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.543618,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.484201,
      NULL,
      NULL,
      0.804401,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.276223,
      NULL,
      NULL,
      1.606115,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.347187,
      1,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      3.675777,
      1,
      NULL,
      NULL,
      NULL,
      3.546304,
      0,
      1,
      1,
      17,
      0,
      0,
      13.574453,
      11.203713,
      2.858036,
      NULL,
      1.067663,
      0.528349,
      NULL,
      5,
      NULL,
      2,
      2,
      2,
      NULL,
      NULL,
      3.099117,
      3,
      3,
      1,
      0,
      1,
      0.444028,
      0.563731,
      3.317114,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.446705,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.272810,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.264300,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.070826,
      0,
      1,
      0.997434,
      0,
      3.759754,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.940105,
      1,
      NULL,
      NULL,
      1.649826,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.928400,
      NULL,
      NULL,
      1,
      0.499938,
      NULL,
      NULL,
      0,
      1.214027,
      NULL,
      NULL,
      0,
      0.393652,
      NULL,
      NULL,
      1.742394,
      1.915173,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      21,
      1,
      0,
      NULL,
      NULL,
      0.266033,
      NULL,
      NULL,
      1.570030,
      NULL,
      NULL,
      2.913615,
      0.800764,
      0,
      1,
      NULL,
      NULL,
      1.661229,
      NULL,
      1.606319,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      0,
      1,
      1.561405,
      1,
      NULL,
      NULL,
      0.950665,
      0.975716,
      NULL,
      1,
      1.068890,
      0.740982,
      NULL,
      1.252580,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.048551,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      5.460264,
      NULL,
      3.253365,
      1,
      1,
      0,
      NULL,
      1.039216,
      2,
      17.701602,
      5,
      NULL,
      9.049143,
      NULL,
      1,
      NULL,
      4.584097,
      NULL,
      5.376593,
      1.073851,
      0.753174,
      NULL,
      1,
      1.968198,
      3.408948,
      14,
      1.682617,
      5.754211,
      6.340746,
      1,
      19,
      4,
      1.674180,
      NULL,
      16.121017,
      0,
      7,
      15,
      NULL,
      0.099181,
      6,
      1,
      1,
      3.044772,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      9.107756,
      NULL,
      NULL,
      1,
      0,
      NULL,
      3,
      1.488148,
      NULL,
      NULL,
      76,
      NULL,
      1,
      0,
      3,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      0,
      NULL,
      '',
      '');
commit;
end;
/


