set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9228957';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-10-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '2',
      NULL,
      NULL,
      '1232142',
      2.908298,
      1.946607,
      NULL,
      0,
      '3242',
      3.577255,
      0.260255,
      NULL,
      NULL,
      ' 6- 4-1981',
      38.971585,
      NULL,
      NULL,
      3,
      NULL,
      '11-29-1986',
      13.278487,
      NULL,
      278.389992,
      NULL,
      4,
      NULL,
      NULL,
      ' 9-10-1985',
      0.251511,
      1.869695,
      0,
      NULL,
      0,
      1.082341,
      1,
      0.595574,
      0,
      1,
      8,
      2,
      8,
      25,
      6,
      4,
      7.959440,
      4,
      2,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.743502,
      0,
      0,
      0.892958,
      NULL,
      0.318790,
      0,
      2,
      0,
      NULL,
      2.925074,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      3,
      3,
      4,
      1,
      1,
      1,
      1,
      0,
      NULL,
      1,
      1,
      0.823406,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      2,
      2.502760,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1.659251,
      NULL,
      0.541042,
      2,
      1.327682,
      1.402032,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1.188451,
      0,
      1,
      0.714057,
      0.767297,
      NULL,
      NULL,
      1.021103,
      NULL,
      NULL,
      1,
      5,
      0,
      1,
      4,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      1,
      1,
      3,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4,
      NULL,
      1,
      1,
      0,
      3,
      NULL,
      0,
      0,
      NULL,
      1,
      0,
      1,
      1,
      0,
      5,
      5,
      0,
      4,
      NULL,
      3,
      0,
      5,
      5,
      1,
      2.853466,
      1.961035,
      ' 8- 6-1979',
      16,
      NULL,
      15,
      3,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      5,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      7,
      0.731150,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1.583540,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.597077,
      0.421189,
      0.245734,
      0.664677,
      0.368751,
      0.248467,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      3,
      1.365269,
      0,
      1,
      3,
      2,
      0,
      3,
      NULL,
      2,
      2,
      2,
      2,
      2.765033,
      NULL,
      2.159402,
      NULL,
      1,
      1.871724,
      0,
      0,
      1.293607,
      0,
      NULL,
      1,
      1.327942,
      0.620640,
      0,
      NULL,
      1,
      0,
      0,
      9.652232,
      5,
      7,
      2.233451,
      NULL,
      3,
      4,
      NULL,
      0.997845,
      NULL,
      2,
      3.244581,
      16.506296,
      0,
      NULL,
      10,
      NULL,
      NULL,
      NULL,
      4,
      0,
      0.604086,
      '23343',
      NULL,
      '',
      1,
      '',
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      2,
      21,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.531200,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.938681,
      NULL,
      NULL,
      1.828892,
      NULL,
      NULL,
      0.861268,
      NULL,
      NULL,
      1.706184,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.601997,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.881908,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.211986,
      NULL,
      NULL,
      0.758193,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.982965,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.925926,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.086611,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.334083,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.698377,
      NULL,
      NULL,
      0.516382,
      NULL,
      NULL,
      1.197151,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      2,
      4.319607,
      5.655096,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      0.180464,
      2,
      2,
      NULL,
      1.757913,
      4,
      0,
      4,
      0.409727,
      2,
      0,
      0,
      NULL,
      1.405676,
      1.152161,
      2.707624,
      2,
      0.922920,
      3.439084,
      0,
      NULL,
      NULL,
      3.237036,
      NULL,
      4.238591,
      5.251393,
      1.630252,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.476949,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.696907,
      1,
      0.723873,
      0.825205,
      1.765385,
      1.822778,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.456784,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.522703,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      1.963289,
      1.696950,
      0.049333,
      0,
      1,
      NULL,
      1.923993,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      0,
      1,
      0.487564,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      1,
      5.283413,
      NULL,
      NULL,
      1,
      3,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2.351617,
      NULL,
      1,
      1,
      NULL,
      NULL,
      3.030288,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0.623500,
      NULL,
      NULL,
      NULL,
      2.309872,
      NULL,
      1.936569,
      1,
      NULL,
      1,
      1.743966,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.695561,
      NULL,
      0.250838,
      NULL,
      2,
      NULL,
      1,
      NULL,
      1.293364,
      NULL,
      0,
      NULL,
      0.146262,
      NULL,
      0,
      NULL,
      0,
      NULL,
      24.549974,
      1.746425,
      19.552787,
      0.938151,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      122,
      2,
      NULL,
      NULL,
      NULL,
      '',
      '',
      1.148417,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


