set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9529157';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-10-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '1',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      '2320',
      0,
      1.517821,
      NULL,
      NULL,
      ' 1-18-1989',
      129.248997,
      NULL,
      1,
      3.440529,
      0.334866,
      ' 1- 9-1993',
      37.222559,
      NULL,
      178,
      22,
      2,
      ' 7-25-1981',
      NULL,
      ' 4-25-1996',
      0.072782,
      2.867893,
      2.664088,
      0,
      NULL,
      0.247350,
      4,
      0,
      0.381232,
      174,
      0,
      NULL,
      5,
      7,
      21,
      5,
      NULL,
      NULL,
      3,
      7.670215,
      0,
      NULL,
      NULL,
      0.816622,
      1,
      1,
      0,
      NULL,
      0.081649,
      NULL,
      1,
      1,
      5,
      0,
      NULL,
      2,
      1,
      1,
      1,
      0,
      NULL,
      5,
      NULL,
      1,
      0,
      0,
      4,
      7.243291,
      1,
      1,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1.942486,
      NULL,
      NULL,
      1,
      1,
      1.304617,
      0.373407,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      2.763218,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      4,
      0,
      3,
      3,
      4,
      1,
      0,
      2,
      5,
      0,
      0,
      4.223849,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      0,
      5,
      NULL,
      1,
      1,
      2,
      3,
      0,
      2,
      0,
      1,
      NULL,
      NULL,
      5,
      NULL,
      4,
      0,
      5,
      1,
      3,
      2,
      7.008979,
      0.823804,
      ' 4-16-1996',
      6,
      ' 0- 1-1987',
      0,
      3.067688,
      NULL,
      1,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      5.761186,
      1.876628,
      6.271747,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      0.470561,
      2,
      2,
      4.560056,
      0,
      1,
      NULL,
      NULL,
      11,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.501745,
      NULL,
      0.305833,
      0,
      0.418245,
      3.641328,
      16.010086,
      0,
      0,
      NULL,
      NULL,
      NULL,
      3,
      1,
      3.639025,
      1,
      NULL,
      3,
      1,
      0,
      1,
      3,
      2,
      1,
      NULL,
      NULL,
      NULL,
      3,
      1.558299,
      0,
      0.214961,
      NULL,
      3.827651,
      NULL,
      1.341437,
      0.380535,
      1,
      NULL,
      NULL,
      119,
      0,
      0.412204,
      4,
      1,
      7,
      1.698131,
      2,
      1.319690,
      4,
      5.831462,
      0,
      3.444134,
      5,
      0,
      0.492902,
      3,
      31,
      1,
      3,
      NULL,
      39,
      8,
      46.654745,
      2,
      0,
      2.786974,
      '41321',
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      5.730923,
      '14200',
      '11221',
      '',
      1.725654,
      NULL,
      205.980014,
      39.592922,
      NULL,
      22,
      7,
      NULL,
      2,
      1,
      2.557931,
      1,
      0.080436,
      NULL,
      NULL,
      1,
      1,
      0,
      0.272059,
      1,
      2,
      1.480330,
      1.273104,
      NULL,
      1.734183,
      NULL,
      NULL,
      1.459014,
      3.122858,
      3,
      3,
      1.854908,
      0.215964,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.476654,
      NULL,
      NULL,
      2,
      9,
      3.151923,
      3,
      1,
      NULL,
      NULL,
      NULL,
      1.853543,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.819596,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.443586,
      3,
      0.949211,
      0,
      2,
      2.702183,
      NULL,
      NULL,
      NULL,
      9.076587,
      6,
      2,
      NULL,
      NULL,
      1,
      2,
      3.651434,
      3.820653,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.232438,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.138138,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      3.213589,
      3,
      7.447306,
      0.898748,
      1,
      1.952881,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      1.097611,
      1,
      1.372161,
      0.309624,
      NULL,
      3.000211,
      2,
      3.602959,
      0,
      4,
      2.422065,
      1.144584,
      3,
      0,
      1.933533,
      2.875556,
      0,
      0.173027,
      NULL,
      0.943977,
      0.508257,
      3.262677,
      1,
      4.330428,
      1.515349,
      1,
      3,
      0,
      0,
      3,
      0,
      NULL,
      1.638970,
      2,
      0,
      0,
      3.771824,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      14.140758,
      NULL,
      NULL,
      0.298415,
      NULL,
      NULL,
      3.973815,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.684287,
      NULL,
      NULL,
      2.690734,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.567114,
      NULL,
      NULL,
      3.099703,
      NULL,
      NULL,
      5.178788,
      NULL,
      NULL,
      1,
      1,
      1.752272,
      NULL,
      0,
      2.283585,
      2.957308,
      NULL,
      NULL,
      2.837953,
      1,
      NULL,
      NULL,
      25.719752,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.951725,
      NULL,
      NULL,
      1.559208,
      1,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.634913,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      0.703310,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.739497,
      1.241691,
      NULL,
      NULL,
      1,
      1.480083,
      NULL,
      NULL,
      3.383612,
      3,
      NULL,
      NULL,
      0.959681,
      NULL,
      NULL,
      NULL,
      3,
      112,
      15.166971,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.033217,
      NULL,
      98,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0.964106,
      1,
      6.293199,
      0.022250,
      0,
      0,
      NULL,
      1.719052,
      0,
      0.919295,
      NULL,
      1.924911,
      NULL,
      0.389533,
      NULL,
      0,
      NULL,
      1.387329,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.650067,
      NULL,
      1.874753,
      NULL,
      0,
      NULL,
      1.777853,
      NULL,
      0.570771,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.297227,
      0.663365,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.577406,
      2.530112,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.737228,
      0.200202,
      1.106119,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.294290,
      NULL,
      0.606630,
      NULL,
      0.931619,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.662425,
      0,
      0.731741,
      40,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.135782,
      NULL,
      0,
      1,
      3,
      4.107973,
      NULL,
      2.567543,
      1.375297,
      0,
      0,
      0,
      0.709066,
      NULL,
      2,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      1.533826,
      1.123336,
      NULL,
      0.842899,
      0,
      2,
      2,
      3,
      1,
      NULL,
      NULL,
      0.824850,
      1.682761,
      0,
      NULL,
      NULL,
      1,
      2,
      1,
      0,
      NULL,
      3.084021,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.552592,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.074575,
      0,
      0.383948,
      1.765061,
      1,
      NULL,
      2,
      1,
      NULL,
      NULL,
      43,
      NULL,
      1,
      2,
      2,
      '01314',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      2.793192,
      '22223',
      '01120',
      '');
commit;
end;
/


