set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9529157';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-9-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '34',
      '21',
      28.867874,
      8.445039,
      '2210300',
      NULL,
      1,
      1,
      2,
      NULL,
      NULL,
      0.322135,
      NULL,
      NULL,
      ' 8- 7-1974',
      84,
      3.650864,
      NULL,
      0.554865,
      NULL,
      ' 4- 3-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      ' 4-27-1981',
      2,
      NULL,
      0.421527,
      2,
      2,
      NULL,
      4,
      1.142198,
      0,
      NULL,
      7,
      11,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      1.684276,
      NULL,
      0,
      1,
      1,
      1,
      NULL,
      0.778896,
      1,
      1.538985,
      NULL,
      3,
      0,
      4,
      NULL,
      1,
      NULL,
      1,
      1,
      NULL,
      0,
      0,
      NULL,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0.062779,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      1,
      2,
      1,
      1,
      1,
      1,
      0,
      0,
      0,
      1,
      1.551977,
      0,
      0,
      0,
      1,
      0.881369,
      NULL,
      NULL,
      0,
      4,
      1,
      1,
      NULL,
      0,
      0,
      0,
      0,
      1,
      0,
      1,
      1,
      1,
      3,
      1,
      NULL,
      2,
      0,
      1,
      1,
      NULL,
      3,
      0,
      1,
      0.572369,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      0.160160,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.091896,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.108120,
      0.628876,
      NULL,
      1,
      1.474314,
      1,
      0,
      2,
      12,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.398748,
      0.899066,
      NULL,
      NULL,
      0,
      2,
      3,
      1,
      NULL,
      3,
      NULL,
      2,
      0,
      3,
      1.165010,
      NULL,
      0.945305,
      0.584458,
      NULL,
      3,
      1,
      1.115799,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.234135,
      11.458936,
      3,
      5,
      NULL,
      NULL,
      0,
      3.725105,
      0.741353,
      0,
      1.829083,
      1.072985,
      NULL,
      3,
      0.791079,
      68,
      NULL,
      10,
      56.828264,
      2,
      1,
      1,
      NULL,
      '',
      '',
      1,
      '',
      '',
      NULL,
      5,
      '43323',
      '32332',
      '',
      NULL,
      10.701643,
      61.815174,
      3,
      0,
      11.151457,
      0,
      19,
      0,
      1.181261,
      NULL,
      1.993495,
      1,
      NULL,
      NULL,
      NULL,
      0.001925,
      0.103043,
      NULL,
      2.638328,
      NULL,
      NULL,
      1.738657,
      0,
      0.498099,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.211187,
      0.209362,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      7.840738,
      3.949056,
      1,
      1.001068,
      NULL,
      NULL,
      NULL,
      0.078834,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.408464,
      NULL,
      NULL,
      1.498715,
      NULL,
      NULL,
      1.450497,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.115232,
      2.250349,
      3,
      3,
      3.791503,
      1.941433,
      NULL,
      NULL,
      NULL,
      7.051749,
      3,
      3,
      2.580596,
      0,
      3,
      3,
      2,
      1,
      9,
      2,
      3.432720,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.760539,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.102439,
      NULL,
      NULL,
      0.777673,
      NULL,
      NULL,
      NULL,
      2,
      3.990933,
      7,
      NULL,
      4.878056,
      1.989018,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.712135,
      1.827873,
      0.033762,
      1,
      0.239524,
      2.232665,
      NULL,
      2.300944,
      NULL,
      3,
      7.169922,
      3.822624,
      NULL,
      1.523707,
      1,
      0,
      0,
      3.452526,
      2.385451,
      1,
      0.011952,
      2.571579,
      0,
      3.584703,
      5.876682,
      4,
      NULL,
      6,
      4.415409,
      3,
      3,
      4,
      1,
      1,
      3,
      2.075417,
      NULL,
      0.045732,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.099028,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.155392,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.641906,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.492478,
      NULL,
      NULL,
      1.960304,
      0,
      1.186862,
      0,
      1.286153,
      3.017429,
      1.924702,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.402627,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.599199,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3.028599,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1.089939,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.176975,
      1.275632,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1.720638,
      0.836398,
      NULL,
      NULL,
      2.819007,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      2.744789,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      403.428135,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.837616,
      NULL,
      0.714979,
      0,
      29,
      1,
      1,
      0,
      1.701011,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.682248,
      1,
      0.421251,
      3.570566,
      0.079207,
      0.176598,
      1.873149,
      NULL,
      NULL,
      1.937633,
      NULL,
      0.643698,
      NULL,
      NULL,
      NULL,
      0.345230,
      NULL,
      1.469850,
      NULL,
      0.121092,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.507756,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.263282,
      NULL,
      0,
      NULL,
      1.716175,
      NULL,
      1.130878,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.706972,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.524060,
      0.435782,
      NULL,
      0.121389,
      NULL,
      1.677231,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.460490,
      NULL,
      0.104581,
      1.819606,
      NULL,
      41,
      8,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.591988,
      5.270815,
      0.241970,
      2,
      8,
      0.940771,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      1,
      1.189443,
      NULL,
      1.041164,
      0.312415,
      1.891714,
      1,
      1,
      0,
      1.326773,
      0,
      2.820216,
      3,
      2.237980,
      1,
      0.632864,
      1,
      1,
      0,
      0,
      1.149558,
      1.090033,
      0.062595,
      2,
      1.472792,
      NULL,
      0,
      0,
      0.538451,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.197978,
      0.518433,
      NULL,
      1.443529,
      1,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      52.896892,
      0,
      4,
      3,
      '04234',
      '',
      '',
      1.721788,
      '',
      '',
      NULL,
      4,
      '34011',
      '44244',
      NULL);
commit;
end;
/


