set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7915727';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-8-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      NULL,
      NULL,
      NULL,
      '1212233',
      1.289689,
      1,
      2,
      3,
      '2414',
      3.792021,
      1,
      NULL,
      NULL,
      ' 1-23-1999',
      3.086543,
      NULL,
      NULL,
      1,
      NULL,
      ' 7-26-1979',
      45.950898,
      2,
      215.464053,
      26.627879,
      3,
      NULL,
      ' 6-12-1975',
      ' 1-22-1976',
      2.648419,
      1,
      2.790957,
      1.837488,
      NULL,
      1,
      3,
      1,
      0.734861,
      15.710526,
      0,
      7.265035,
      15.330179,
      7,
      NULL,
      2,
      5.435055,
      5,
      2,
      10,
      NULL,
      1,
      1,
      1.453165,
      NULL,
      1,
      NULL,
      NULL,
      0.527218,
      1,
      101.804440,
      6,
      4,
      5,
      1.507391,
      0,
      1,
      0,
      1,
      1,
      0,
      0,
      0,
      1,
      0,
      1,
      0,
      2.290585,
      2,
      NULL,
      0,
      2,
      1,
      NULL,
      NULL,
      0.237449,
      NULL,
      NULL,
      1,
      1,
      1.934374,
      0.152586,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      2,
      4,
      3,
      1,
      0,
      1,
      NULL,
      1,
      0,
      0.205727,
      NULL,
      1,
      0,
      0,
      0.655614,
      NULL,
      1,
      2,
      2,
      0,
      NULL,
      0,
      3,
      NULL,
      0,
      1,
      2,
      0,
      2,
      NULL,
      4,
      0,
      4,
      NULL,
      1,
      1,
      5,
      NULL,
      3,
      4,
      5,
      NULL,
      4.911742,
      2,
      ' 8- 5-1987',
      585,
      NULL,
      4.768038,
      3.857591,
      1,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      1,
      0,
      0,
      1.795660,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.832820,
      NULL,
      2,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.118585,
      4.465693,
      1.421843,
      1,
      8,
      3.544173,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.767323,
      2,
      1.715553,
      0.310633,
      0,
      0.735328,
      1.125179,
      1.967008,
      NULL,
      3.785412,
      1.177727,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      5.672952,
      2,
      NULL,
      8,
      3.792572,
      4,
      2.105254,
      1.071831,
      NULL,
      1,
      0.038625,
      54.689360,
      0,
      0.237325,
      NULL,
      64,
      17,
      45,
      5,
      0.629083,
      1,
      '22444',
      '',
      '',
      1.788930,
      '',
      '',
      '',
      1,
      NULL,
      '',
      '',
      NULL,
      23.070851,
      448,
      13.728905,
      NULL,
      26.461666,
      NULL,
      9,
      3,
      1,
      0.377395,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.704047,
      NULL,
      NULL,
      0.542849,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.472075,
      NULL,
      NULL,
      8,
      0.541886,
      0,
      NULL,
      1.036980,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.536474,
      NULL,
      NULL,
      0.758404,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.716303,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      2,
      3.566700,
      3.280780,
      2,
      0.984750,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      NULL,
      0.286155,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      1.322632,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.501263,
      NULL,
      NULL,
      0.646478,
      NULL,
      NULL,
      0.193889,
      NULL,
      NULL,
      0.435171,
      NULL,
      NULL,
      2.198144,
      NULL,
      0.901289,
      9.185464,
      2.142970,
      4.988691,
      2,
      2.138818,
      2,
      2,
      NULL,
      NULL,
      NULL,
      0.779120,
      NULL,
      1,
      0,
      NULL,
      0.529534,
      NULL,
      NULL,
      0.016054,
      6.865900,
      2,
      2.032918,
      5,
      3.694878,
      2.907884,
      1.454128,
      18,
      2.634322,
      1,
      2.355943,
      NULL,
      1,
      1.731187,
      0.093856,
      6,
      NULL,
      0,
      1,
      0,
      1.970219,
      NULL,
      2,
      1,
      0,
      0,
      1,
      0,
      0.878740,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.236425,
      NULL,
      NULL,
      0.807547,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.207212,
      NULL,
      NULL,
      0.977721,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.641544,
      1,
      NULL,
      NULL,
      NULL,
      2.820010,
      0.671117,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.618016,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.440862,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.247735,
      NULL,
      NULL,
      NULL,
      0.888011,
      NULL,
      NULL,
      NULL,
      1.602643,
      NULL,
      NULL,
      NULL,
      1.051643,
      NULL,
      NULL,
      NULL,
      0.775456,
      NULL,
      NULL,
      NULL,
      0.250753,
      NULL,
      NULL,
      NULL,
      3.181941,
      1,
      1,
      0,
      1.387677,
      NULL,
      45,
      1,
      NULL,
      98.021864,
      0,
      NULL,
      NULL,
      0.743362,
      865,
      NULL,
      NULL,
      33,
      135,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.257012,
      NULL,
      1254.708598,
      NULL,
      0,
      NULL,
      NULL,
      0.910028,
      1,
      1,
      1,
      0,
      0.892306,
      0.217372,
      0.795266,
      1.852296,
      0,
      0.060549,
      1.976801,
      1,
      0.824919,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      0,
      0,
      0.531683,
      0,
      15,
      NULL,
      NULL,
      13,
      NULL,
      NULL,
      12,
      14,
      NULL,
      16,
      11.107288,
      NULL,
      13.930483,
      8.691296,
      NULL,
      9.732947,
      1,
      NULL,
      7.970747,
      18,
      NULL,
      4,
      11.032143,
      NULL,
      0.372390,
      3,
      NULL,
      NULL,
      16.752761,
      NULL,
      NULL,
      10.872003,
      NULL,
      1.881465,
      NULL,
      0.927323,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.280684,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.576728,
      NULL,
      1,
      NULL,
      0.311489,
      NULL,
      4,
      NULL,
      7,
      NULL,
      1.348936,
      NULL,
      NULL,
      64,
      0,
      1,
      0,
      '14004',
      '',
      '',
      NULL,
      '',
      NULL,
      NULL,
      1.710876,
      '',
      '',
      '');
commit;
end;
/


