set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9877862';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-5-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      2.914598,
      2,
      NULL,
      0,
      0.711440,
      2,
      0,
      1,
      '242',
      '21224024',
      11.230845,
      NULL,
      NULL,
      2,
      NULL,
      4,
      2,
      '1242',
      3,
      NULL,
      NULL,
      NULL,
      ' 1-27-1997',
      122,
      132,
      NULL,
      3.137050,
      13.629657,
      ' 0-10-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      '10- 0-1977',
      ' 2-12-1986',
      ' 3-22-1976',
      3.943283,
      1.611579,
      1.958421,
      3.996160,
      0,
      0,
      3,
      0,
      NULL,
      NULL,
      NULL,
      6.394250,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      NULL,
      0.218034,
      0,
      1,
      NULL,
      1.001040,
      1,
      0.532567,
      1,
      0,
      1,
      0,
      1,
      NULL,
      2,
      3.580028,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      4,
      1,
      2,
      1,
      4.110784,
      1,
      2,
      2,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5,
      2,
      0.039362,
      2,
      NULL,
      NULL,
      1,
      2,
      NULL,
      2,
      2.242997,
      NULL,
      3,
      NULL,
      NULL,
      1.288212,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      4,
      0,
      2,
      5,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      3,
      0,
      4,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      4,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      0,
      NULL,
      0.340156,
      0,
      1,
      0,
      3,
      1,
      2,
      1,
      NULL,
      2,
      3,
      0,
      NULL,
      4,
      0,
      5,
      4,
      1,
      4,
      5,
      4,
      2,
      NULL,
      NULL,
      1,
      NULL,
      3.459219,
      0,
      NULL,
      40,
      ' 4-16-1981',
      316.401697,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      3,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      7,
      1.996972,
      2.664703,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1.088228,
      0.226359,
      NULL,
      0.682222,
      0.793276,
      5,
      2.142264,
      2,
      3.571374,
      1.653896,
      NULL,
      NULL,
      NULL,
      0.277573,
      1.743565,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1,
      NULL,
      1.734956,
      1,
      NULL,
      2,
      1.797137,
      2.378010,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.488552,
      NULL,
      1,
      NULL,
      1,
      3,
      3,
      2,
      1,
      2,
      NULL,
      3.261847,
      NULL,
      NULL,
      3.306063,
      1,
      1.699992,
      0,
      NULL,
      1,
      1.301154,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      2.056363,
      3,
      3.615120,
      3.285771,
      5.554233,
      0,
      5.901531,
      NULL,
      1,
      2.920774,
      2.582256,
      0,
      6.835425,
      1,
      2,
      NULL,
      NULL,
      NULL,
      54,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      '',
      0,
      '',
      NULL,
      NULL,
      1.325610,
      '',
      '',
      '',
      NULL,
      31,
      NULL,
      3,
      0.085694,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.457137,
      2,
      0,
      NULL,
      NULL,
      2,
      1,
      0.670581,
      3,
      1.744412,
      1.292596,
      NULL,
      0,
      1.487332,
      NULL,
      NULL,
      NULL,
      2.610024,
      3.453124,
      0.772403,
      0,
      1.070726,
      1,
      3,
      0.986013,
      0,
      3,
      1.497233,
      1.380730,
      2,
      1.684161,
      0,
      NULL,
      NULL,
      1.216634,
      2.783142,
      NULL,
      6,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.166171,
      0.619801,
      3.165579,
      1,
      0.014351,
      NULL,
      NULL,
      0.137202,
      0,
      0,
      0.870867,
      2,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.597843,
      3,
      3.871203,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      5,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.722412,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.032555,
      NULL,
      NULL,
      2,
      0.527398,
      3.692228,
      0.884485,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.347443,
      NULL,
      2.468032,
      1,
      NULL,
      4.578547,
      1,
      0,
      NULL,
      0,
      5.045555,
      0.781038,
      NULL,
      NULL,
      NULL,
      1.791320,
      NULL,
      3.067505,
      0,
      1.387162,
      0.416199,
      0,
      2,
      NULL,
      NULL,
      4.930016,
      1.446176,
      NULL,
      0,
      3,
      1.980593,
      0,
      NULL,
      1,
      1.463923,
      3.736464,
      0.995832,
      1.997892,
      0,
      1,
      1.014421,
      0,
      NULL,
      NULL,
      0.495279,
      NULL,
      2,
      1,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.974883,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.581840,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.238198,
      NULL,
      NULL,
      2.866941,
      NULL,
      NULL,
      0.085791,
      NULL,
      NULL,
      4.423441,
      NULL,
      NULL,
      0,
      0.953120,
      NULL,
      0,
      0,
      2,
      0,
      NULL,
      NULL,
      0.271265,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.902059,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.392752,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.527818,
      NULL,
      NULL,
      NULL,
      1.220568,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.147892,
      0,
      1.690839,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.420961,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.816736,
      NULL,
      1.196846,
      0,
      1.849415,
      1.976614,
      NULL,
      1.157515,
      1,
      NULL,
      NULL,
      0,
      0,
      1,
      0.583039,
      1,
      1.345422,
      NULL,
      NULL,
      0.026417,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.657341,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.845331,
      0.661727,
      0.886830,
      NULL,
      3,
      4,
      1.669777,
      3.571634,
      1,
      0.366316,
      0.714537,
      NULL,
      0,
      0,
      NULL,
      0.477672,
      1,
      NULL,
      0,
      1,
      NULL,
      1,
      1.863624,
      NULL,
      1,
      0.476501,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.985320,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0.782132,
      1,
      NULL,
      3.116994,
      0.655476,
      1.224116,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.823774,
      NULL,
      0.235765,
      NULL,
      0.672790,
      NULL,
      0,
      1,
      5,
      1.313039,
      NULL,
      NULL,
      55,
      128.014468,
      2,
      5,
      0,
      '00402',
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      '',
      '',
      NULL);
commit;
end;
/


