set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8935013';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-12-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '2',
      NULL,
      NULL,
      '0130031',
      1,
      1.191271,
      3,
      3,
      '2001',
      0.303845,
      0.255985,
      NULL,
      NULL,
      ' 2-26-1996',
      24,
      NULL,
      4,
      2.166066,
      0,
      ' 7-22-1978',
      24,
      NULL,
      297,
      73.654448,
      3,
      ' 9- 1-1994',
      ' 9- 8-1981',
      ' 3- 5-1988',
      2.576375,
      1,
      NULL,
      0.191065,
      0,
      1.786045,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1.423693,
      12.320344,
      15.878665,
      5,
      15,
      2,
      2,
      7.987445,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      1.269115,
      5,
      0,
      0,
      0,
      0,
      0,
      0,
      NULL,
      0,
      0,
      1,
      1,
      2.719840,
      2,
      0,
      0,
      NULL,
      0.824915,
      NULL,
      NULL,
      0.728952,
      NULL,
      NULL,
      5,
      1,
      1.873565,
      1.526168,
      1,
      NULL,
      0.309202,
      0.447923,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.943571,
      1.670179,
      0,
      1.099640,
      NULL,
      1.551652,
      0,
      1,
      0,
      4.790373,
      2,
      1,
      0,
      1,
      NULL,
      NULL,
      1.142263,
      NULL,
      NULL,
      NULL,
      5,
      3,
      NULL,
      3,
      0,
      0,
      1,
      NULL,
      1,
      1,
      0,
      0,
      3,
      1,
      1,
      1,
      1,
      1.183411,
      NULL,
      1.454449,
      2,
      2,
      0,
      1,
      1,
      1,
      NULL,
      1,
      2,
      1,
      3,
      1,
      NULL,
      NULL,
      4,
      2,
      2,
      4,
      3,
      2,
      0,
      NULL,
      0,
      5,
      1,
      1,
      0,
      ' 9- 5-1983',
      NULL,
      ' 9-21-1995',
      137.249671,
      NULL,
      2,
      1,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.826831,
      0.982448,
      1,
      2,
      1.616596,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0.052368,
      1,
      1,
      NULL,
      1,
      62.578033,
      0.798856,
      0,
      NULL,
      NULL,
      NULL,
      2,
      0,
      2,
      0,
      3,
      0,
      3,
      2,
      3,
      0,
      2,
      3,
      3,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      3,
      NULL,
      1,
      2.702125,
      0.489820,
      0.631287,
      0.045110,
      0.944159,
      1.165201,
      1,
      0,
      2.337266,
      NULL,
      9.666240,
      8,
      2.519346,
      1,
      1.183946,
      7,
      NULL,
      0,
      3.385583,
      3,
      0,
      0.268788,
      37,
      NULL,
      0,
      NULL,
      82,
      NULL,
      NULL,
      NULL,
      1.141013,
      3,
      '01413',
      '',
      '',
      1,
      '',
      NULL,
      '',
      0.053676,
      '',
      '',
      NULL,
      NULL,
      0.854158,
      78.459065,
      1,
      0.050400,
      NULL,
      NULL,
      NULL,
      NULL,
      3.180842,
      2,
      0.458913,
      1.642236,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.008180,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.461763,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.181756,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      6.814883,
      2.316621,
      1.835751,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      2,
      6.092043,
      7.233397,
      NULL,
      NULL,
      9.846932,
      NULL,
      NULL,
      3,
      0,
      0,
      0.609654,
      0,
      1,
      1.912327,
      1,
      0.476174,
      1,
      NULL,
      NULL,
      1.990272,
      NULL,
      NULL,
      1.352548,
      NULL,
      NULL,
      NULL,
      1,
      0.656528,
      1,
      1.557272,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.315850,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      3,
      NULL,
      2.532469,
      1,
      0.197674,
      0,
      NULL,
      NULL,
      5,
      4.591119,
      NULL,
      3.262620,
      3,
      3.775785,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1.693524,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.009019,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.638919,
      3,
      1,
      3,
      NULL,
      1.328732,
      4,
      1.822552,
      3.820701,
      2,
      NULL,
      6.540304,
      0.569291,
      2.483303,
      1,
      3.286341,
      3,
      0,
      NULL,
      0.355992,
      1,
      0,
      1,
      NULL,
      1.809012,
      2.934141,
      NULL,
      0,
      2.193790,
      NULL,
      0,
      0.231539,
      0,
      1,
      3,
      0.279375,
      NULL,
      3.880897,
      2,
      3,
      5.195839,
      6.279136,
      4.692003,
      2.768964,
      3.446660,
      0.734830,
      2,
      0,
      0,
      0.677327,
      0.514360,
      1.451314,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.838484,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.718350,
      NULL,
      1.906337,
      0.306697,
      1.123220,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.279888,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.102560,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.459993,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.224254,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.633239,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.334037,
      NULL,
      NULL,
      0.663074,
      NULL,
      1.790704,
      135,
      1.174150,
      0.063250,
      1.635447,
      NULL,
      1,
      1.174127,
      0.356872,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.286686,
      0.851369,
      0.325145,
      0.444912,
      NULL,
      0.376340,
      1.889757,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.435851,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      7,
      3,
      2,
      0,
      1,
      0,
      0,
      NULL,
      0.308514,
      0,
      0,
      NULL,
      0,
      0.925615,
      NULL,
      1,
      0.412082,
      NULL,
      1.110316,
      0.039902,
      NULL,
      1,
      1.927945,
      NULL,
      1,
      0.774498,
      NULL,
      0.424447,
      1,
      NULL,
      NULL,
      0.729204,
      NULL,
      1,
      0,
      NULL,
      0.861462,
      1.199925,
      NULL,
      1.323309,
      NULL,
      NULL,
      0.485589,
      0.100258,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.555305,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.126134,
      NULL,
      1,
      NULL,
      0,
      5,
      2,
      2,
      1.078052,
      NULL,
      70,
      64,
      0,
      0,
      2,
      '00434',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      0.306477,
      NULL,
      '',
      '');
commit;
end;
/


