set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8935013';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-12-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      NULL,
      NULL,
      '4324100',
      0,
      1,
      3,
      2,
      NULL,
      3.914471,
      0,
      NULL,
      NULL,
      ' 0- 2-2001',
      35.715331,
      NULL,
      5,
      2,
      NULL,
      NULL,
      3,
      1,
      251,
      50,
      2,
      NULL,
      '10-27-1988',
      '10- 8-1975',
      1,
      1.366415,
      1.056964,
      3.139582,
      1.748887,
      1,
      8,
      0.257679,
      NULL,
      NULL,
      NULL,
      1,
      0.277277,
      8,
      3.823253,
      NULL,
      15.609643,
      2,
      4,
      NULL,
      0.721323,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      3.654367,
      1,
      0,
      0,
      NULL,
      1,
      1,
      1,
      NULL,
      1,
      NULL,
      0,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      3.220560,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2,
      0,
      4,
      NULL,
      0,
      1,
      2,
      NULL,
      0,
      4,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      0,
      NULL,
      1,
      0,
      0,
      0,
      3,
      3,
      0,
      NULL,
      5,
      NULL,
      2,
      NULL,
      3,
      NULL,
      1,
      5,
      0,
      0,
      NULL,
      1,
      2,
      1.034102,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1.689776,
      0,
      NULL,
      NULL,
      NULL,
      5,
      1,
      NULL,
      0,
      1.564491,
      4,
      0,
      NULL,
      NULL,
      NULL,
      0.049236,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1,
      0.375756,
      NULL,
      0.352704,
      1,
      2,
      NULL,
      1.593356,
      0.295643,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3,
      NULL,
      3,
      2,
      NULL,
      2,
      3,
      NULL,
      NULL,
      1,
      NULL,
      2,
      3,
      3.740021,
      2,
      NULL,
      0.115788,
      3,
      1,
      0.874434,
      1.481029,
      0,
      NULL,
      NULL,
      0,
      0.958444,
      1,
      1,
      1.643525,
      3.027214,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.795716,
      NULL,
      58,
      30,
      105.039540,
      1,
      0.763527,
      1.104505,
      NULL,
      NULL,
      '',
      1.378644,
      '',
      '',
      '',
      1.201149,
      '',
      NULL,
      '',
      0.781660,
      43.547000,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0.350796,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.313465,
      NULL,
      NULL,
      1.253518,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.350487,
      NULL,
      NULL,
      1.765215,
      NULL,
      NULL,
      0.193819,
      NULL,
      NULL,
      3.051779,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      3,
      3,
      0.118772,
      NULL,
      NULL,
      1.187669,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.906052,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.580057,
      NULL,
      NULL,
      1.715226,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      0,
      0.868622,
      0,
      0,
      NULL,
      NULL,
      1.634897,
      1,
      1,
      1.662332,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0.336883,
      1,
      1.398817,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.746654,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.134403,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.796648,
      6.116546,
      1,
      0,
      3.484331,
      3,
      2.378483,
      NULL,
      0,
      1,
      0.206001,
      2,
      2,
      0,
      1,
      2,
      7,
      7,
      3,
      NULL,
      1,
      2.050464,
      1.289037,
      NULL,
      NULL,
      0.860564,
      NULL,
      NULL,
      1,
      0,
      1,
      9.845121,
      7,
      4.935086,
      1.492279,
      4,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1.426268,
      NULL,
      1,
      0.568139,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.044163,
      1.695180,
      1,
      1.498894,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1.486604,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.396781,
      NULL,
      NULL,
      0.401462,
      NULL,
      0.538206,
      NULL,
      NULL,
      1.211794,
      0,
      0.591490,
      0.567896,
      1,
      1.663340,
      NULL,
      1,
      1,
      0.593529,
      0.785442,
      1.114312,
      NULL,
      0.932253,
      0.756152,
      0.309682,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.755915,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.424278,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1.278877,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.617758,
      NULL,
      0.671915,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.228842,
      NULL,
      1.297118,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      5,
      0.167014,
      3.880485,
      0,
      2,
      7.074982,
      3,
      1.297512,
      NULL,
      0,
      0.607886,
      NULL,
      NULL,
      1.294576,
      NULL,
      1.812630,
      0.106069,
      NULL,
      0,
      NULL,
      NULL,
      0.389517,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0.816650,
      1.091936,
      NULL,
      1.513169,
      0,
      NULL,
      NULL,
      0.149226,
      NULL,
      NULL,
      3.519678,
      NULL,
      0.773281,
      1.646437,
      NULL,
      3,
      0.970864,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.296131,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      6,
      0,
      NULL,
      NULL,
      NULL,
      72,
      1.635349,
      1,
      1.285035,
      2,
      '30143',
      NULL,
      '',
      0,
      '',
      '',
      '',
      1.238131,
      NULL,
      '',
      '');
commit;
end;
/


