set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8935013';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-1-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      NULL,
      NULL,
      '2422000',
      NULL,
      0,
      NULL,
      0,
      '0302',
      3,
      0.298309,
      NULL,
      NULL,
      NULL,
      42,
      NULL,
      5,
      0,
      7.629235,
      ' 7- 6-1987',
      34.111676,
      5.444382,
      220,
      91,
      2,
      NULL,
      ' 8-28-1990',
      NULL,
      3.931566,
      1.130969,
      3,
      3,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      5,
      5.340093,
      4.762271,
      10,
      1,
      4,
      NULL,
      0,
      8,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      2,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      3,
      0,
      1,
      1.680506,
      1,
      2,
      0,
      NULL,
      1.687387,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      0,
      1,
      3,
      0,
      NULL,
      1.030935,
      1,
      0,
      0.709264,
      1.825557,
      0.971640,
      1,
      1.947416,
      0.515219,
      0.618149,
      1,
      1,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      1,
      1,
      1.443773,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      4,
      0,
      NULL,
      2,
      1,
      NULL,
      0,
      0,
      4,
      NULL,
      0,
      0,
      3.062958,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      0,
      NULL,
      4,
      NULL,
      4,
      0,
      3,
      5,
      0,
      2,
      1,
      0,
      1,
      2,
      3,
      NULL,
      2,
      1,
      2,
      NULL,
      NULL,
      1,
      5,
      1,
      5,
      0,
      2.842712,
      2.398818,
      ' 6- 2-1987',
      NULL,
      ' 3-27-1998',
      60.624719,
      2,
      2,
      NULL,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      0,
      1,
      NULL,
      NULL,
      1,
      0.437598,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.820756,
      1.348986,
      NULL,
      NULL,
      NULL,
      2.199003,
      NULL,
      2,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.686635,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.552839,
      0.012350,
      NULL,
      1.492124,
      0,
      1.114119,
      1.568160,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3,
      3,
      2,
      0,
      0,
      0,
      3,
      NULL,
      1,
      2,
      NULL,
      1.773633,
      2.636555,
      0.010369,
      2,
      1,
      0,
      4.642709,
      1,
      0.959757,
      NULL,
      NULL,
      NULL,
      1,
      0.579944,
      1.355317,
      1,
      1.836806,
      3,
      1.514657,
      7.019901,
      NULL,
      3.394036,
      8,
      11,
      3,
      NULL,
      1,
      2.740221,
      3.802135,
      3,
      3,
      54,
      0,
      0.205154,
      NULL,
      48,
      78,
      NULL,
      2,
      1.556774,
      2,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      1.828434,
      '',
      NULL,
      '',
      3,
      34.518086,
      92,
      0,
      0.968773,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.998720,
      1,
      1.602333,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.848071,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.316319,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      7.157732,
      NULL,
      0.188887,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1.941103,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.554659,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.594385,
      0,
      0,
      0.611920,
      0,
      0.899080,
      1,
      NULL,
      0,
      0.391723,
      0,
      0,
      0,
      NULL,
      1.577516,
      1,
      NULL,
      NULL,
      1.856028,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      2.646247,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.930117,
      NULL,
      1.337766,
      1.514900,
      1,
      NULL,
      3,
      0.507292,
      0,
      6,
      5,
      0,
      3.536838,
      2.939698,
      0,
      NULL,
      NULL,
      NULL,
      3.468281,
      0.935967,
      3,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.055080,
      NULL,
      NULL,
      0.487553,
      NULL,
      NULL,
      2,
      3.934755,
      0,
      3.651020,
      3,
      NULL,
      NULL,
      4.716916,
      2.649116,
      1.134441,
      4,
      NULL,
      1,
      1,
      NULL,
      1.097826,
      NULL,
      1,
      1,
      3,
      0,
      NULL,
      1,
      NULL,
      9.492041,
      3.757149,
      6.489941,
      3,
      0,
      NULL,
      2.823979,
      0.676208,
      NULL,
      0,
      NULL,
      2,
      NULL,
      2.662010,
      2.650359,
      1.809116,
      7.611350,
      NULL,
      6.756598,
      1.688613,
      1,
      NULL,
      NULL,
      1,
      1,
      1.777193,
      0,
      1.377160,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.297501,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      1.359385,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.327485,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.211949,
      NULL,
      NULL,
      NULL,
      1.149426,
      NULL,
      NULL,
      NULL,
      3.198713,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1.628520,
      1,
      NULL,
      NULL,
      0.496881,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.188283,
      NULL,
      NULL,
      0,
      NULL,
      1.509695,
      45,
      NULL,
      0.982252,
      0,
      1.506648,
      0.901621,
      1,
      0.093173,
      0.210737,
      NULL,
      1,
      1,
      1,
      1.480962,
      NULL,
      0,
      1,
      0.278389,
      NULL,
      1.575216,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1.978252,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.265081,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.819884,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.131160,
      1.025855,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.182848,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.996373,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.231544,
      1,
      0.543308,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      3,
      3,
      1.950574,
      0,
      NULL,
      0,
      4,
      3.450849,
      NULL,
      0.428826,
      0,
      1,
      NULL,
      1.132617,
      NULL,
      NULL,
      1.682430,
      1,
      NULL,
      0.303244,
      NULL,
      NULL,
      0,
      1.662786,
      NULL,
      1.600561,
      0,
      NULL,
      NULL,
      1.119911,
      NULL,
      0.827937,
      0,
      NULL,
      0,
      0,
      NULL,
      3,
      0.835473,
      NULL,
      1.136429,
      NULL,
      NULL,
      0.404633,
      0.957593,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.664362,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      94,
      5,
      NULL,
      NULL,
      '30010',
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      1,
      '',
      '',
      NULL);
commit;
end;
/


