set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8326935';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-8-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      NULL,
      NULL,
      NULL,
      '3042301',
      0,
      1,
      0,
      0,
      '3220',
      1,
      NULL,
      NULL,
      NULL,
      ' 6- 8-1979',
      NULL,
      NULL,
      3,
      2.146331,
      6,
      ' 0- 4-1985',
      32,
      1.196983,
      304.426764,
      62,
      NULL,
      '11-18-1984',
      ' 5-20-2002',
      NULL,
      1.712701,
      1,
      NULL,
      0,
      1.678452,
      0.012972,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      11.827692,
      3,
      NULL,
      8,
      5,
      NULL,
      NULL,
      0.123866,
      0,
      0,
      0,
      1.144711,
      0.874631,
      NULL,
      3,
      0.258508,
      NULL,
      0,
      1,
      NULL,
      NULL,
      2.047031,
      0,
      NULL,
      1,
      0,
      1,
      1,
      0,
      1,
      1,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.071882,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      1,
      0,
      NULL,
      0,
      1,
      0,
      NULL,
      1,
      1.225591,
      NULL,
      0,
      2,
      NULL,
      1,
      1,
      NULL,
      3,
      1,
      NULL,
      0,
      1,
      5,
      2,
      2,
      0,
      0,
      NULL,
      1,
      1,
      2,
      3,
      2,
      4,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      70.493211,
      3,
      0.409760,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.154635,
      1,
      5.487674,
      7,
      1.573497,
      5,
      1,
      NULL,
      NULL,
      NULL,
      0.933441,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.526383,
      NULL,
      0.309640,
      1.914963,
      0,
      1.950579,
      1.448194,
      3.367436,
      42.056404,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      3,
      NULL,
      2,
      2,
      2,
      NULL,
      NULL,
      0,
      NULL,
      1,
      3.187520,
      1.787552,
      3.901811,
      NULL,
      0,
      1,
      0.727659,
      1,
      0,
      1,
      0,
      0.191033,
      1.066641,
      1.503480,
      NULL,
      1,
      1,
      1.882167,
      1.763619,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      43,
      NULL,
      19,
      2,
      4.431637,
      3,
      '12340',
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      '3434',
      '',
      NULL,
      3,
      NULL,
      33.109176,
      15,
      NULL,
      69.737315,
      0,
      1.144596,
      1,
      1.793059,
      1.259751,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.461292,
      NULL,
      NULL,
      2,
      0.054049,
      0,
      0,
      0,
      1.914724,
      2.393350,
      0,
      1.083006,
      0,
      NULL,
      NULL,
      0.380617,
      NULL,
      1,
      1,
      NULL,
      NULL,
      3.012297,
      3,
      NULL,
      1,
      0.893580,
      1.460147,
      11.748495,
      3.670700,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.893916,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1.834202,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.961851,
      1.804586,
      NULL,
      0,
      NULL,
      0.106960,
      NULL,
      NULL,
      1.361809,
      1.462287,
      1,
      NULL,
      1.058705,
      NULL,
      1,
      0,
      1.365686,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      7.507095,
      2.977669,
      3,
      1,
      0.060165,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      0,
      1.813707,
      1,
      0.103488,
      0,
      NULL,
      NULL,
      NULL,
      1.296383,
      NULL,
      NULL,
      0.175748,
      1.955890,
      0,
      NULL,
      NULL,
      NULL,
      1.383364,
      0.667815,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      2,
      0,
      2,
      3.638571,
      1.573510,
      0.849660,
      1.300506,
      NULL,
      0.528481,
      3,
      0,
      3.764561,
      1,
      2.378925,
      0,
      1.122840,
      1,
      1.781414,
      1.441123,
      NULL,
      1,
      3,
      0.639092,
      0.946513,
      2.165103,
      1,
      1,
      3,
      2.155284,
      3,
      5,
      2.372891,
      NULL,
      4,
      0.456180,
      0,
      3,
      NULL,
      NULL,
      0,
      1,
      1,
      1.092366,
      1,
      2.925161,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.602953,
      NULL,
      NULL,
      0.314961,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.242512,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.482470,
      1.905901,
      3.256397,
      0,
      1,
      0,
      3,
      NULL,
      NULL,
      4.943847,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      0.702595,
      3,
      NULL,
      NULL,
      NULL,
      0.506439,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.753351,
      NULL,
      NULL,
      1.600831,
      0.899177,
      NULL,
      NULL,
      1.777122,
      1.061664,
      NULL,
      NULL,
      1.765091,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      2,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      0.738185,
      2,
      NULL,
      NULL,
      2,
      3,
      NULL,
      NULL,
      NULL,
      0.175677,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      7.505105,
      NULL,
      NULL,
      1.996750,
      NULL,
      NULL,
      NULL,
      1.927600,
      12,
      6,
      0,
      14,
      13,
      NULL,
      NULL,
      NULL,
      3,
      3,
      4.153543,
      1.971087,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.648345,
      NULL,
      0,
      90.354202,
      0,
      NULL,
      1,
      NULL,
      1.493047,
      1.914133,
      1,
      0,
      1.768566,
      1,
      1,
      0.613356,
      NULL,
      1,
      NULL,
      0.877027,
      1.195004,
      1,
      0.683741,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.575558,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      10.798008,
      1,
      0.547006,
      1.548997,
      2,
      8.194180,
      3.942087,
      0.052235,
      3,
      0,
      NULL,
      1,
      NULL,
      0,
      1.776278,
      1.286259,
      1,
      1.974193,
      0.254764,
      1,
      0.162577,
      0.953481,
      0,
      0.421583,
      1.652141,
      1.776666,
      0.586830,
      1.743175,
      1.483443,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.318672,
      NULL,
      3,
      0,
      1.279382,
      0.977104,
      0,
      1,
      1.489891,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.163787,
      2.391481,
      10,
      NULL,
      6,
      3,
      NULL,
      0,
      NULL,
      1,
      4,
      NULL,
      NULL,
      2.095637,
      18,
      2,
      NULL,
      0,
      16.552357,
      1,
      10.058616,
      NULL,
      10.353172,
      2.609564,
      19.676328,
      0.674445,
      NULL,
      1.471061,
      NULL,
      0.283357,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      1,
      5,
      NULL,
      2,
      0,
      0.360213,
      59.626403,
      49.237390,
      5,
      NULL,
      3.734108,
      '14042',
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      '3300',
      '',
      '');
commit;
end;
/


