set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9537645';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-12-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '0',
      NULL,
      NULL,
      '0011123',
      2.678220,
      0,
      0,
      2,
      '2301',
      NULL,
      1,
      NULL,
      NULL,
      '11- 5-1991',
      49,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      8,
      2.276739,
      NULL,
      159.806824,
      1,
      ' 0- 5-1974',
      NULL,
      ' 0- 4-1975',
      NULL,
      3.526049,
      1.953862,
      1,
      0.177299,
      3,
      3,
      3.481177,
      NULL,
      NULL,
      NULL,
      NULL,
      1.590615,
      3.765300,
      NULL,
      NULL,
      5.715682,
      1,
      3,
      1.628354,
      0,
      NULL,
      0,
      0,
      NULL,
      1,
      0,
      0,
      0.463449,
      0.902940,
      1.405247,
      NULL,
      NULL,
      2,
      2,
      0,
      1,
      1,
      0,
      1,
      NULL,
      0,
      0,
      NULL,
      0,
      1,
      NULL,
      0,
      0,
      2,
      NULL,
      0,
      1,
      NULL,
      NULL,
      2.865555,
      NULL,
      0,
      2,
      0,
      NULL,
      1.896970,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      3.837553,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      NULL,
      5,
      2,
      2,
      0,
      2,
      2,
      NULL,
      1,
      0,
      NULL,
      1,
      0,
      1,
      0,
      1,
      NULL,
      1,
      NULL,
      2,
      1,
      3,
      0,
      0,
      NULL,
      1,
      0,
      1,
      0,
      1,
      3,
      0,
      1,
      4,
      5,
      3,
      2,
      3,
      2,
      1,
      3,
      NULL,
      NULL,
      4.103598,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      0,
      0,
      5,
      0.669179,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      5.490536,
      1.249654,
      2.416545,
      4,
      1.463092,
      1.550418,
      NULL,
      0.674464,
      10,
      3,
      1,
      1.398283,
      1.491815,
      1,
      NULL,
      2,
      3,
      9.348008,
      5.732873,
      4.376332,
      1.599209,
      10.819509,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      4,
      2,
      6,
      ' 4- 0-1983',
      NULL,
      NULL,
      7.473070,
      1,
      NULL,
      1,
      3,
      NULL,
      1.822602,
      0.157575,
      2,
      0.561846,
      1.771884,
      2,
      32,
      3,
      0.637615,
      NULL,
      NULL,
      NULL,
      2,
      2,
      3,
      3,
      NULL,
      0,
      3,
      1,
      2,
      1,
      NULL,
      2,
      1,
      2,
      3.675295,
      3,
      0,
      0,
      0.917216,
      1,
      1.682798,
      0.005404,
      1,
      1.444482,
      NULL,
      1.925707,
      0.602630,
      1,
      1,
      3,
      1.248562,
      0,
      0.100632,
      11.824337,
      7,
      0,
      0,
      6,
      3,
      0,
      5,
      3,
      NULL,
      0,
      36.367184,
      0,
      3.017155,
      NULL,
      NULL,
      13,
      94.488090,
      NULL,
      4,
      5.616657,
      '30014',
      '11244',
      NULL,
      0.742420,
      NULL,
      '',
      NULL,
      4,
      '2223',
      NULL,
      '',
      3.055112,
      19,
      3,
      8.269074,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.786921,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.639978,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.529598,
      NULL,
      NULL,
      0.395714,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.894884,
      NULL,
      NULL,
      0.029751,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.289922,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.780641,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.491941,
      0,
      0,
      2,
      NULL,
      2.202023,
      1.107723,
      NULL,
      NULL,
      1,
      NULL,
      1.092439,
      1.779084,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.469354,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.413302,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.600884,
      0,
      1,
      NULL,
      NULL,
      3.038355,
      3,
      2.827745,
      1.879381,
      NULL,
      NULL,
      1.741599,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.426963,
      2,
      3.022609,
      1.147950,
      NULL,
      3.170495,
      NULL,
      1,
      2.986425,
      0.615688,
      3.254703,
      1.477518,
      1,
      NULL,
      NULL,
      2.683173,
      2.777922,
      2,
      NULL,
      2.796826,
      2.189863,
      0,
      2,
      1.921883,
      5,
      4.607345,
      1,
      1,
      NULL,
      NULL,
      1.713493,
      0,
      0.960363,
      0.264169,
      1.729920,
      0.000325,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.935995,
      1,
      1,
      1,
      0.849612,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.732385,
      NULL,
      NULL,
      NULL,
      2.168304,
      2.325871,
      0,
      NULL,
      24,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      1.728048,
      NULL,
      NULL,
      253.077010,
      0.025746,
      0,
      1.751204,
      1,
      1.774762,
      1,
      1.578756,
      1.132838,
      0,
      NULL,
      0,
      NULL,
      0,
      1.085077,
      1,
      1,
      0.379637,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.975005,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      2,
      4,
      1,
      4.701206,
      0.034593,
      3,
      NULL,
      NULL,
      2,
      3.315743,
      0.207664,
      0,
      1.161597,
      0.339693,
      NULL,
      0.110969,
      0,
      2.000428,
      NULL,
      0.224801,
      3.957275,
      0,
      NULL,
      2.773616,
      3,
      2.791880,
      0.648607,
      1.875961,
      2.819563,
      NULL,
      1,
      3.248536,
      0.693561,
      2,
      1,
      NULL,
      0,
      3,
      1.103695,
      0.534057,
      NULL,
      0,
      1,
      2.361800,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.848741,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.431211,
      3.938449,
      0,
      NULL,
      3,
      3,
      1,
      3.927993,
      1.334381,
      1,
      1.561128,
      1.147134,
      3,
      NULL,
      2.581288,
      NULL,
      1,
      0,
      1,
      1,
      24.292846,
      NULL,
      NULL,
      0,
      1.879848,
      3.175197,
      3,
      0.839344,
      0.681564,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      18.765009,
      NULL,
      NULL,
      4.671315,
      2,
      '12430',
      NULL,
      '',
      NULL,
      '3012',
      NULL,
      '',
      0,
      '3124',
      '01114',
      '');
commit;
end;
/


