set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '5200554';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-5-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '0',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      NULL,
      0.038929,
      NULL,
      2,
      2,
      NULL,
      19.251522,
      NULL,
      2,
      0,
      1,
      ' 2-24-1977',
      55,
      0.513883,
      88,
      116,
      0,
      NULL,
      NULL,
      ' 4- 2-1985',
      NULL,
      NULL,
      0,
      0,
      NULL,
      2,
      3,
      0,
      NULL,
      NULL,
      NULL,
      4,
      0,
      15.620318,
      6.492964,
      4,
      NULL,
      3,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0,
      5,
      NULL,
      0,
      0.689494,
      1,
      3,
      NULL,
      3,
      0.370573,
      1,
      1,
      1,
      0,
      0,
      1,
      1,
      1,
      NULL,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.448132,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      4,
      0,
      NULL,
      0,
      0,
      1,
      3,
      1,
      1,
      NULL,
      1,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      4,
      0,
      0,
      1,
      4,
      1,
      0,
      5,
      0,
      NULL,
      5,
      1,
      0,
      3,
      5,
      5,
      0,
      3,
      5,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.659952,
      0.769708,
      NULL,
      1.267275,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.433028,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.556232,
      NULL,
      NULL,
      0.266406,
      0,
      0.430829,
      1.072214,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      2,
      0.797377,
      1,
      2,
      3,
      1,
      2,
      2,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      19.561902,
      1,
      0,
      0,
      1.813421,
      11,
      1.315383,
      1.988017,
      6,
      NULL,
      1,
      0,
      0.047014,
      0,
      2,
      0.248731,
      NULL,
      0.885785,
      3,
      2.359154,
      7.317828,
      0,
      6,
      3.106103,
      1.746326,
      0,
      NULL,
      2.480537,
      2.756121,
      2.982640,
      NULL,
      2,
      1.530110,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0.265085,
      2.134258,
      NULL,
      NULL,
      NULL,
      2,
      '33003',
      '',
      '',
      0.576183,
      '',
      NULL,
      NULL,
      1,
      51,
      NULL,
      25,
      2,
      19.129885,
      0,
      NULL,
      1,
      0.626722,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      4.394494,
      10,
      0,
      NULL,
      NULL,
      2,
      14,
      13.896597,
      3,
      9.644434,
      NULL,
      0,
      NULL,
      NULL,
      1.905539,
      NULL,
      NULL,
      1.621288,
      NULL,
      NULL,
      1.033635,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      0.600095,
      1,
      1.388868,
      NULL,
      NULL,
      NULL,
      NULL,
      2.634094,
      8.490155,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.631023,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.965732,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.129817,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      18,
      NULL,
      3.047247,
      19.397025,
      1.390139,
      NULL,
      3,
      NULL,
      2,
      2.983081,
      4,
      3,
      8.124209,
      3.125535,
      2,
      2.696480,
      1.178215,
      2,
      0,
      5.106183,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.615703,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      2.873368,
      3.012580,
      9,
      NULL,
      7.338543,
      0,
      NULL,
      NULL,
      0.971259,
      1,
      1,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      2,
      NULL,
      2,
      NULL,
      19,
      1,
      9,
      1,
      NULL,
      0,
      10,
      NULL,
      3.499849,
      2,
      19.307160,
      0,
      NULL,
      1.619619,
      NULL,
      NULL,
      2,
      0,
      1.977983,
      2,
      4,
      0.977203,
      1,
      2,
      3,
      NULL,
      1,
      0.417291,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      0.767863,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.123259,
      NULL,
      NULL,
      0.249131,
      NULL,
      NULL,
      17,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.057006,
      NULL,
      NULL,
      2.973194,
      1.287364,
      1.611946,
      NULL,
      1.877720,
      NULL,
      1,
      5,
      NULL,
      NULL,
      0.702908,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.417996,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.842107,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.992349,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      1.298066,
      NULL,
      NULL,
      4,
      0.968569,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      3.539419,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.636755,
      1.333927,
      NULL,
      NULL,
      NULL,
      8.639700,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      111,
      0.759349,
      NULL,
      NULL,
      NULL,
      0.487866,
      76.523802,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.803856,
      15.694302,
      0,
      8376,
      NULL,
      0,
      0.384842,
      NULL,
      1,
      1.451966,
      0.863751,
      1.506944,
      0.448095,
      NULL,
      1.415447,
      NULL,
      1,
      1,
      1.113458,
      1.001620,
      0.382912,
      1.172766,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      2,
      3.144471,
      3.878317,
      0,
      3.535413,
      2,
      3.327171,
      2,
      3.734242,
      0.432005,
      NULL,
      0,
      0,
      1,
      1,
      1.940660,
      3,
      0,
      0,
      1.714019,
      0,
      0,
      2,
      NULL,
      0,
      1.984570,
      0.580423,
      2,
      0,
      1.024989,
      0.903512,
      1.727263,
      1.076018,
      1.664843,
      1,
      1,
      1,
      2,
      1,
      0.986329,
      1.689308,
      1,
      NULL,
      NULL,
      0.396658,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.116488,
      NULL,
      1.034441,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.086199,
      NULL,
      1.227887,
      NULL,
      3,
      NULL,
      2.767847,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      25.468176,
      0.833146,
      NULL,
      3.751211,
      NULL,
      NULL,
      11,
      15,
      0,
      1.630924,
      3.651381,
      1.401038,
      NULL,
      NULL,
      NULL,
      0.540510,
      2,
      2,
      0.067281,
      0,
      3.100968,
      2,
      2.577268,
      1,
      1.525054,
      1,
      3.934924,
      1.354975,
      2,
      3,
      10.287232,
      1.130130,
      NULL,
      0.655230,
      1,
      0,
      1.224222,
      0.655087,
      NULL,
      4,
      5,
      6,
      1.197872,
      NULL,
      NULL,
      127.149178,
      48,
      4,
      0.599530,
      2.932622,
      '42141',
      '04414',
      '',
      2,
      '43133',
      NULL,
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


