set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9655708';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-4-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      26.419397,
      10.448863,
      '4103143',
      3.974409,
      1,
      4,
      2,
      '3221',
      0,
      1,
      NULL,
      NULL,
      ' 0-18-1974',
      60,
      52,
      NULL,
      2.440593,
      1,
      ' 5-22-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      ' 7-24-1994',
      '11-27-2002',
      ' 5- 4-2000',
      2,
      2,
      2,
      1,
      1,
      3.483073,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.018790,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.257577,
      1,
      1,
      1,
      NULL,
      1,
      NULL,
      3.571958,
      1,
      0.617234,
      0.466804,
      NULL,
      NULL,
      3,
      NULL,
      4,
      NULL,
      0,
      NULL,
      3,
      0,
      0,
      1,
      0,
      0,
      NULL,
      0,
      NULL,
      0,
      1,
      0,
      1,
      1.737977,
      NULL,
      NULL,
      1.824679,
      NULL,
      NULL,
      0,
      0,
      0.469487,
      3.085373,
      NULL,
      0.308336,
      1.110810,
      2.975726,
      NULL,
      0.884319,
      0.777905,
      0.480712,
      2.219644,
      NULL,
      1.061007,
      NULL,
      0,
      1.376314,
      2,
      1,
      0,
      5,
      NULL,
      0,
      0,
      0,
      0.954203,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      3,
      1,
      1,
      NULL,
      1,
      0,
      NULL,
      1,
      2,
      5,
      0,
      5,
      NULL,
      3,
      NULL,
      5,
      1,
      4,
      2,
      3.741470,
      2.689914,
      ' 0-28-1997',
      2,
      ' 4-15-1989',
      2.032199,
      2.707016,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      0,
      0,
      1.316066,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      2.667430,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      0.185233,
      NULL,
      3,
      2.472941,
      NULL,
      1.923867,
      1.459374,
      0.887227,
      3.724504,
      1.948968,
      NULL,
      NULL,
      NULL,
      1.906196,
      0,
      1.094021,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0.748157,
      NULL,
      1,
      3.695486,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.170481,
      0,
      1,
      3,
      2,
      0,
      2,
      0,
      NULL,
      NULL,
      2,
      3,
      0,
      2.708882,
      1.348634,
      0.510435,
      3,
      0.125902,
      1.501174,
      0,
      1.618252,
      0,
      NULL,
      1,
      1,
      0,
      0,
      0,
      1.959095,
      4,
      0,
      3.073292,
      8,
      6,
      0,
      9.221436,
      2.863224,
      5.404408,
      NULL,
      2.572068,
      3,
      1.978137,
      0.571842,
      53,
      NULL,
      NULL,
      1,
      NULL,
      29,
      63.132160,
      3,
      NULL,
      2.280903,
      '02420',
      '',
      '',
      0,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      2,
      23,
      11.853816,
      16.534215,
      2.051800,
      5.535757,
      5.584999,
      8,
      NULL,
      NULL,
      1.565513,
      3.475395,
      0,
      NULL,
      NULL,
      1.823854,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.228131,
      NULL,
      NULL,
      1.606521,
      NULL,
      NULL,
      2,
      3,
      NULL,
      0.933291,
      3.883721,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.269971,
      NULL,
      NULL,
      5,
      4.407886,
      NULL,
      NULL,
      0.979900,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      3.542991,
      2.832013,
      1.086420,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.630196,
      1,
      0,
      1.932535,
      0,
      1,
      3,
      1.451667,
      0.553455,
      0.109573,
      NULL,
      NULL,
      0.562211,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.655975,
      3,
      1,
      2,
      0.847520,
      1.487772,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.597516,
      NULL,
      NULL,
      NULL,
      1.368206,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.472134,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.043870,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.564002,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      5,
      7,
      NULL,
      2.917863,
      2,
      1,
      1.511168,
      3,
      1.417282,
      2.961527,
      0,
      1.530215,
      1.267102,
      NULL,
      0.170041,
      8,
      9,
      3.249947,
      2,
      3.936988,
      NULL,
      2.768964,
      3,
      3,
      0,
      1,
      0,
      0,
      0.858165,
      1.307645,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.522005,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.637255,
      NULL,
      NULL,
      0.241822,
      NULL,
      NULL,
      1.738460,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.218857,
      NULL,
      NULL,
      0.524696,
      0,
      1,
      0.361854,
      1,
      2.073204,
      NULL,
      NULL,
      NULL,
      NULL,
      0.307018,
      NULL,
      NULL,
      1.933297,
      2.460029,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      1.999973,
      0.150908,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.445792,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1.976370,
      NULL,
      NULL,
      NULL,
      3,
      0.069258,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      17,
      NULL,
      1,
      19,
      NULL,
      1.600166,
      NULL,
      NULL,
      0.451600,
      NULL,
      NULL,
      1.413301,
      NULL,
      NULL,
      0.853392,
      NULL,
      NULL,
      1.532633,
      NULL,
      0.395609,
      NULL,
      1,
      0.464916,
      NULL,
      NULL,
      NULL,
      1.902806,
      0,
      1.997143,
      0,
      0,
      0,
      0.041213,
      0.014184,
      0.533882,
      0,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      1.945255,
      7,
      1,
      NULL,
      4,
      2,
      NULL,
      3,
      1.376713,
      0,
      1,
      0.217512,
      0,
      0.857040,
      0,
      NULL,
      0.567117,
      1.196276,
      NULL,
      3,
      1,
      NULL,
      NULL,
      1.097659,
      NULL,
      NULL,
      NULL,
      3,
      0.513344,
      1,
      1,
      0,
      NULL,
      NULL,
      0,
      0.872106,
      NULL,
      1,
      1,
      0,
      NULL,
      2.675584,
      NULL,
      0.248973,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.542980,
      0,
      3,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      33.298648,
      4,
      5.737904,
      3,
      '40244',
      '',
      '',
      0,
      '',
      '',
      '',
      1.193834,
      '',
      '',
      '');
commit;
end;
/


