set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9518819';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-7-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      NULL,
      NULL,
      NULL,
      '3121234',
      1,
      0,
      6,
      1,
      '0443',
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.536049,
      NULL,
      NULL,
      12.043818,
      1.672683,
      103,
      119,
      3,
      NULL,
      NULL,
      ' 2-27-1996',
      3.278519,
      1,
      1.868523,
      NULL,
      1,
      2,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      12,
      NULL,
      21.461946,
      5,
      2,
      14.461908,
      2,
      2,
      1,
      1,
      3,
      1,
      1.896273,
      1.602299,
      1,
      0.088436,
      NULL,
      0.839230,
      0,
      1,
      0,
      4,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2,
      0,
      1,
      1,
      0,
      1,
      1,
      1,
      0,
      1.154590,
      0,
      NULL,
      0,
      0,
      0.962414,
      NULL,
      NULL,
      NULL,
      1,
      0,
      4,
      0,
      4,
      3.315002,
      0.286237,
      NULL,
      1.655383,
      0,
      1.882376,
      NULL,
      3.526627,
      0.737094,
      2,
      0,
      2,
      2,
      0,
      1.026788,
      1.855981,
      0,
      1,
      0,
      1.278985,
      1,
      0,
      1,
      0.059045,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      0,
      NULL,
      4,
      5,
      1,
      0,
      1,
      0,
      1,
      0,
      0,
      0,
      1,
      1,
      1,
      1,
      NULL,
      0.695911,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3,
      1,
      3,
      3,
      5,
      2,
      0,
      4,
      2,
      2,
      0,
      1,
      NULL,
      2,
      4,
      4,
      0,
      4,
      5,
      2,
      4,
      NULL,
      NULL,
      1,
      ' 5-14-1983',
      178.499558,
      ' 8-22-2003',
      0.720515,
      1.990987,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.645786,
      1.840532,
      1.804156,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      3,
      0.120004,
      NULL,
      0,
      0,
      3,
      3,
      NULL,
      3,
      2,
      6,
      0,
      4,
      1,
      NULL,
      13.232749,
      2.257344,
      NULL,
      1,
      1,
      2,
      ' 3-22-2002',
      268.618769,
      NULL,
      NULL,
      1,
      2,
      1.262925,
      2.894203,
      3,
      1,
      0,
      1,
      0,
      1.331937,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0.715174,
      2,
      NULL,
      2,
      NULL,
      2,
      3,
      NULL,
      2,
      1,
      3,
      0,
      0,
      3.356800,
      5,
      NULL,
      0.429845,
      0.618781,
      1.833118,
      0.506814,
      NULL,
      1,
      1.733864,
      1.417066,
      1.093535,
      0.911473,
      NULL,
      NULL,
      0,
      0.114546,
      7.168680,
      8.931480,
      NULL,
      4.530483,
      7,
      2.589543,
      0.092543,
      0,
      6,
      2.086371,
      0,
      2.195291,
      57.999939,
      NULL,
      NULL,
      NULL,
      57,
      63,
      49,
      2,
      5.738800,
      NULL,
      '20304',
      '',
      '',
      0,
      NULL,
      '',
      '',
      1.661841,
      '',
      '',
      '',
      3.556733,
      16,
      57,
      NULL,
      1,
      NULL,
      2,
      NULL,
      NULL,
      2,
      0.738886,
      0.034954,
      1.181513,
      NULL,
      NULL,
      1.442310,
      NULL,
      NULL,
      1,
      0,
      0.790374,
      1.011153,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.361426,
      1.830081,
      NULL,
      3.874137,
      NULL,
      0.232965,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.545198,
      NULL,
      NULL,
      0.427278,
      NULL,
      NULL,
      2.300359,
      0.732941,
      0.062274,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.892682,
      3,
      0,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.281417,
      3,
      3.092359,
      1,
      1.872570,
      0.719409,
      0,
      0.231137,
      1.641382,
      0.075747,
      0.025863,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      NULL,
      0.507599,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      2.972380,
      1,
      3.430694,
      2.800744,
      5.962151,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.617433,
      NULL,
      0,
      0,
      1.628448,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.674201,
      3.657646,
      0.031743,
      1.009951,
      3,
      0,
      5,
      5,
      4.618425,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.023480,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.265439,
      NULL,
      NULL,
      1.212696,
      NULL,
      NULL,
      1.490030,
      NULL,
      NULL,
      0.203188,
      NULL,
      NULL,
      2,
      2,
      NULL,
      1,
      NULL,
      NULL,
      6.984508,
      2.939391,
      0.177022,
      4,
      3.068151,
      1.519969,
      0,
      NULL,
      NULL,
      2.602732,
      2.982942,
      0,
      2,
      1.444484,
      3,
      NULL,
      2.235201,
      2.259110,
      NULL,
      4,
      3,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      0.272430,
      0,
      NULL,
      0,
      2.269091,
      8.382058,
      3.676635,
      5,
      0,
      3,
      NULL,
      NULL,
      3,
      3,
      1,
      0,
      1.181938,
      0,
      1.352148,
      NULL,
      NULL,
      NULL,
      0.136894,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.865037,
      NULL,
      NULL,
      0.666985,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.218253,
      NULL,
      1.107296,
      3,
      1.548887,
      2.372574,
      NULL,
      6,
      NULL,
      5.195113,
      NULL,
      3,
      NULL,
      7,
      NULL,
      3.112139,
      NULL,
      1,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      NULL,
      1.550888,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.738656,
      NULL,
      3.504687,
      NULL,
      0.964604,
      NULL,
      1.864605,
      NULL,
      NULL,
      NULL,
      0.758656,
      NULL,
      0.876751,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.977390,
      NULL,
      3,
      NULL,
      0.193566,
      NULL,
      0.454193,
      NULL,
      2,
      NULL,
      2.353258,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2.058447,
      NULL,
      3.160588,
      NULL,
      0.901553,
      NULL,
      1.291641,
      NULL,
      1.792763,
      NULL,
      2,
      NULL,
      9,
      NULL,
      2.272992,
      1.616485,
      NULL,
      NULL,
      NULL,
      0,
      1.531125,
      2.134064,
      1,
      NULL,
      2.059501,
      0,
      NULL,
      NULL,
      0.822545,
      NULL,
      NULL,
      0.257671,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.595614,
      NULL,
      0,
      51,
      0,
      NULL,
      0,
      NULL,
      1.473179,
      0,
      0.398469,
      0.354565,
      0.989444,
      NULL,
      0.102753,
      0,
      1.002402,
      0,
      1.301934,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.696528,
      0,
      0.666630,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.799198,
      0.444266,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.937991,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.276755,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.717253,
      1.405720,
      1,
      1,
      NULL,
      NULL,
      1.096638,
      0,
      1.000439,
      1.773910,
      NULL,
      NULL,
      NULL,
      0.995771,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      3,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      0,
      NULL,
      2,
      NULL,
      1.816728,
      0,
      NULL,
      3.917101,
      NULL,
      0.905516,
      1,
      NULL,
      1,
      0.038443,
      1,
      1.574268,
      2.607670,
      1,
      0.270340,
      0.748266,
      0.287923,
      NULL,
      1.258202,
      0,
      0.912712,
      3,
      1,
      1,
      NULL,
      0.229080,
      2,
      1,
      0,
      0.883992,
      0.517171,
      1,
      1,
      1.519500,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.659256,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.294818,
      NULL,
      1,
      5,
      1,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      0,
      3,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      0.762302,
      '',
      '',
      NULL);
commit;
end;
/


