set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6225292';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-2-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '3',
      NULL,
      NULL,
      '1400040',
      0.583074,
      NULL,
      NULL,
      3,
      '4134',
      NULL,
      1.767972,
      NULL,
      NULL,
      ' 6-23-1981',
      NULL,
      NULL,
      1,
      NULL,
      1,
      ' 3-18-1986',
      NULL,
      2,
      116,
      NULL,
      2,
      ' 5-26-1979',
      ' 2-17-1979',
      ' 3- 5-1992',
      3.955944,
      1.291262,
      0,
      0.680365,
      0,
      3,
      NULL,
      1,
      1,
      22.333687,
      NULL,
      4.225596,
      2,
      4,
      9.840713,
      1,
      3.807567,
      NULL,
      0,
      2,
      3.848799,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      3.560746,
      0,
      0,
      NULL,
      0,
      0,
      2,
      0,
      1,
      0,
      1,
      1,
      1,
      2,
      1,
      NULL,
      0,
      0,
      0.440626,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      1,
      NULL,
      0.407538,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      3.471029,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      1,
      0,
      0,
      1,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      1,
      0,
      0,
      1.897808,
      NULL,
      1.505348,
      NULL,
      4,
      0,
      1,
      0,
      NULL,
      1,
      1,
      2,
      NULL,
      1,
      3,
      4,
      1,
      0,
      NULL,
      5,
      0,
      5,
      5,
      NULL,
      NULL,
      2,
      0,
      2,
      3.780098,
      0,
      ' 3-16-1974',
      1206.665463,
      ' 8-21-1993',
      33.961813,
      0,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      5.396279,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.758261,
      NULL,
      0.995834,
      NULL,
      NULL,
      NULL,
      5.415955,
      4.251741,
      5,
      1.020573,
      9,
      0.988735,
      NULL,
      NULL,
      NULL,
      NULL,
      11,
      3.871846,
      1,
      5,
      2,
      4,
      ' 5-28-1977',
      NULL,
      ' 8-19-1984',
      28.215581,
      1,
      1,
      0,
      NULL,
      0,
      NULL,
      0.428937,
      NULL,
      0,
      1.996634,
      NULL,
      181,
      0.031230,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.544278,
      0,
      2,
      NULL,
      1,
      1,
      2,
      3,
      3,
      3,
      3,
      1,
      1.742762,
      3,
      0,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.714691,
      1.970943,
      NULL,
      0,
      NULL,
      3,
      0,
      2,
      0,
      11.159480,
      5,
      6.918928,
      0,
      7,
      3,
      3,
      0,
      NULL,
      0.554312,
      1.202783,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      38,
      26,
      NULL,
      1,
      0.032207,
      1,
      '31203',
      '',
      NULL,
      1,
      '30322',
      '',
      '',
      5.016000,
      NULL,
      '1041',
      '3121',
      NULL,
      17,
      209,
      47.525069,
      0.971744,
      18.116962,
      3.320007,
      NULL,
      0,
      1.208839,
      0,
      0.197955,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.353759,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.556621,
      1.937049,
      0,
      3,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      11.873630,
      3.419206,
      0,
      0.888754,
      NULL,
      NULL,
      NULL,
      0.516587,
      NULL,
      1,
      0,
      2,
      0,
      0.318162,
      1,
      NULL,
      NULL,
      3,
      3,
      0.194488,
      0.922737,
      1.415860,
      1.047913,
      1,
      0,
      0.426251,
      1.439225,
      2,
      1,
      3,
      2,
      1,
      1,
      0,
      1,
      1,
      3.730028,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      6.683855,
      3.261746,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.953480,
      NULL,
      NULL,
      1.413410,
      NULL,
      NULL,
      2.255189,
      NULL,
      0,
      1,
      NULL,
      NULL,
      2.515045,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.340872,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.545197,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      0,
      2.987910,
      0.387283,
      3,
      8.478195,
      3,
      NULL,
      5.536138,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      1.865706,
      NULL,
      NULL,
      2.693793,
      NULL,
      1,
      2.814919,
      3,
      1,
      9.919534,
      2.933177,
      2.222180,
      0.288794,
      NULL,
      1,
      0,
      0,
      1,
      2.879175,
      0.356102,
      NULL,
      NULL,
      NULL,
      2.908463,
      8,
      0,
      4.660433,
      3.309733,
      0.934625,
      NULL,
      1,
      NULL,
      1,
      1.917725,
      0,
      0,
      1.240245,
      0,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.366922,
      NULL,
      NULL,
      1.294436,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.470867,
      NULL,
      NULL,
      1.466427,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      3.891097,
      NULL,
      NULL,
      3,
      3,
      2.231742,
      1,
      3.583783,
      1.530422,
      1,
      NULL,
      7.982235,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3,
      0.039695,
      1,
      NULL,
      1.984401,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.838270,
      1,
      NULL,
      NULL,
      0.641479,
      NULL,
      NULL,
      NULL,
      1.969673,
      NULL,
      NULL,
      1.509766,
      2.471412,
      NULL,
      NULL,
      0.029111,
      0,
      NULL,
      NULL,
      NULL,
      0.441478,
      0.153477,
      NULL,
      1.597497,
      0.231727,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.644451,
      NULL,
      1,
      NULL,
      NULL,
      1.589008,
      0.926156,
      NULL,
      2,
      2.910910,
      NULL,
      NULL,
      0.288438,
      0,
      0,
      NULL,
      10,
      NULL,
      5.574849,
      NULL,
      3.997786,
      NULL,
      0,
      6,
      NULL,
      3.219851,
      23,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0.180083,
      96.963597,
      1,
      3,
      1.287054,
      1.593449,
      0.261983,
      NULL,
      NULL,
      1.544934,
      NULL,
      1,
      148.402840,
      0,
      NULL,
      1.437457,
      1.264850,
      0,
      0.029899,
      NULL,
      0.497052,
      0.299681,
      NULL,
      1,
      1.807544,
      1,
      0.882312,
      1,
      1,
      1.637551,
      0.302407,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.242061,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      4,
      NULL,
      NULL,
      4,
      3,
      0,
      NULL,
      9.910122,
      0,
      2,
      NULL,
      0.696987,
      0.921288,
      1,
      1.498576,
      0,
      NULL,
      NULL,
      2,
      NULL,
      0.894550,
      1,
      0,
      0.129842,
      1.526051,
      2,
      0,
      NULL,
      NULL,
      0.174672,
      1.984347,
      2,
      2.227421,
      NULL,
      1,
      1.701991,
      0.381581,
      1,
      NULL,
      3,
      NULL,
      NULL,
      0,
      1.000321,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.086274,
      NULL,
      3,
      NULL,
      2.859452,
      NULL,
      0.698034,
      NULL,
      1,
      NULL,
      3,
      NULL,
      3.300103,
      NULL,
      3,
      NULL,
      0,
      NULL,
      1.065174,
      NULL,
      0,
      NULL,
      1.043321,
      NULL,
      0.147029,
      6,
      0.834507,
      NULL,
      0,
      0.306742,
      1,
      NULL,
      0,
      NULL,
      1,
      3,
      0,
      1.425500,
      2.904852,
      NULL,
      59,
      64,
      NULL,
      1,
      0.569028,
      '03231',
      '',
      '',
      0,
      '02403',
      '',
      '',
      3,
      NULL,
      NULL,
      '2110');
commit;
end;
/


