set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '5806722';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-1-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '4',
      NULL,
      NULL,
      '2442044',
      0,
      0,
      2,
      2,
      '0442',
      1,
      0,
      NULL,
      NULL,
      '10- 4-1978',
      NULL,
      NULL,
      2,
      NULL,
      0,
      ' 6-23-1983',
      36.091381,
      4.749238,
      208.464691,
      23,
      2,
      ' 7-26-2000',
      ' 6-19-2001',
      NULL,
      0,
      1.495883,
      0.727769,
      1,
      0.666553,
      0.403979,
      5,
      1,
      NULL,
      NULL,
      NULL,
      9,
      NULL,
      150.832087,
      NULL,
      5,
      14,
      0,
      2,
      4.167127,
      1.780806,
      0,
      0,
      NULL,
      1,
      0,
      0.379947,
      0,
      1.506858,
      0,
      1.971208,
      NULL,
      0,
      3,
      2.841963,
      3,
      0,
      1,
      1,
      0,
      1,
      NULL,
      1,
      1,
      0,
      NULL,
      4,
      NULL,
      0,
      NULL,
      1,
      1,
      1.333571,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      NULL,
      0.689984,
      NULL,
      0,
      0,
      3,
      0,
      0,
      1.427488,
      0,
      0,
      3,
      3,
      1.838111,
      1.436661,
      2,
      0.982252,
      0,
      NULL,
      0,
      2,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      0.354747,
      NULL,
      NULL,
      0,
      4,
      2,
      0,
      3,
      0,
      2,
      1,
      0,
      0,
      NULL,
      1,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      2,
      1,
      1,
      0,
      0,
      3,
      0,
      4,
      4,
      1,
      0,
      1,
      NULL,
      0,
      1,
      0,
      NULL,
      1,
      1,
      4,
      5,
      0,
      NULL,
      0,
      1,
      1.582811,
      ' 8- 7-1991',
      306,
      NULL,
      7.194202,
      NULL,
      1,
      1,
      3,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      0,
      0,
      0,
      0.867149,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2.685551,
      3.303482,
      0,
      1.215061,
      NULL,
      NULL,
      NULL,
      1.137853,
      3,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.131596,
      1.184270,
      1.502250,
      1.524740,
      NULL,
      1.704227,
      2,
      16,
      NULL,
      0.934973,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.728095,
      3,
      3,
      0,
      NULL,
      2,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      3,
      0,
      9,
      NULL,
      146,
      37,
      199,
      81,
      NULL,
      1,
      1.540900,
      NULL,
      147,
      129,
      3,
      NULL,
      7,
      0,
      0,
      5.071983,
      5.700987,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      58,
      0,
      2.120480,
      NULL,
      51,
      19,
      88,
      5,
      2,
      2,
      NULL,
      '01413',
      NULL,
      0.490084,
      '',
      '',
      '',
      0,
      '',
      NULL,
      '',
      2.384968,
      4,
      122,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3.114387,
      2.783775,
      1.775259,
      0,
      NULL,
      NULL,
      0.746584,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.155766,
      0.621862,
      2,
      1.425912,
      NULL,
      NULL,
      0.574107,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.969617,
      0,
      NULL,
      3.070036,
      NULL,
      0.894605,
      NULL,
      3,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.684450,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      3.834869,
      2.787914,
      0.664465,
      NULL,
      2.347302,
      2.898700,
      0,
      2.002561,
      2.982473,
      NULL,
      2,
      0,
      NULL,
      0.863222,
      3,
      NULL,
      1,
      NULL,
      1,
      0,
      3.526718,
      1.694348,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.672196,
      NULL,
      NULL,
      NULL,
      5.135853,
      NULL,
      NULL,
      1.263724,
      NULL,
      NULL,
      NULL,
      1.607199,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.579364,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.142534,
      NULL,
      NULL,
      1.819793,
      NULL,
      NULL,
      0.364668,
      NULL,
      NULL,
      1.313382,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.835567,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.803216,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.744852,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.513336,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.980990,
      1,
      NULL,
      1,
      2.980519,
      3,
      2.201344,
      0.156181,
      NULL,
      1.972383,
      NULL,
      4.139152,
      1,
      NULL,
      NULL,
      0.198055,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      NULL,
      0.491989,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.944215,
      1.709338,
      1.104267,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.990023,
      1.552214,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.579431,
      362,
      5.268465,
      0.119485,
      1.764226,
      1,
      NULL,
      2,
      1,
      0,
      0.176319,
      NULL,
      NULL,
      2.188167,
      0.172595,
      2.121761,
      0.450517,
      1.201536,
      0.895419,
      1.655504,
      0.821090,
      3.847445,
      NULL,
      0.444272,
      NULL,
      1,
      NULL,
      2.484393,
      NULL,
      2.968754,
      NULL,
      315.412879,
      NULL,
      1,
      NULL,
      24.534056,
      NULL,
      0.990104,
      0.632511,
      NULL,
      0,
      NULL,
      0.170770,
      NULL,
      3.426855,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.434392,
      NULL,
      0.902824,
      NULL,
      NULL,
      NULL,
      0.907170,
      NULL,
      1.990233,
      NULL,
      1,
      NULL,
      0.851530,
      NULL,
      NULL,
      NULL,
      1.924738,
      NULL,
      2,
      NULL,
      1.963537,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.796711,
      1.391530,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.691198,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.284658,
      NULL,
      0,
      1.189750,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.775130,
      NULL,
      NULL,
      0.311467,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      3,
      0,
      0,
      1.264963,
      NULL,
      NULL,
      2.977390,
      2.504860,
      0.578461,
      1.419437,
      0.295303,
      NULL,
      NULL,
      0.987870,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.660653,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.069170,
      NULL,
      0,
      0,
      NULL,
      2,
      1,
      1.651052,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      1,
      6,
      NULL,
      NULL,
      NULL,
      97.638407,
      45.205083,
      5,
      2.721010,
      2.317886,
      '22403',
      '32401',
      '',
      0,
      '',
      '',
      '',
      0,
      '',
      '',
      NULL);
commit;
end;
/


