set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8804734';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-2-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '2',
      NULL,
      NULL,
      '4410144',
      1,
      0.187821,
      NULL,
      0,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.579400,
      0.819747,
      ' 9- 5-1998',
      47,
      NULL,
      132.952311,
      63.918738,
      1,
      ' 0- 2-2003',
      ' 9- 8-1989',
      ' 1-25-1990',
      NULL,
      0,
      3.614598,
      1,
      1.300179,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0.478625,
      NULL,
      NULL,
      7,
      1,
      NULL,
      3,
      1,
      5.715706,
      3.442456,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      3,
      1,
      0,
      0,
      0,
      0,
      NULL,
      1,
      0,
      1,
      0,
      1,
      6,
      1,
      0,
      NULL,
      0,
      1.384367,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5,
      0,
      0.824296,
      NULL,
      0,
      0,
      0.990179,
      NULL,
      1.661244,
      1,
      0,
      1,
      0,
      0.828318,
      1.399811,
      0.809074,
      NULL,
      1.940946,
      1.529965,
      NULL,
      0,
      1,
      7,
      NULL,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      0,
      5,
      1,
      1,
      1,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      1,
      0,
      1,
      1,
      NULL,
      3,
      NULL,
      NULL,
      3,
      1,
      0,
      5,
      1,
      5,
      2,
      3,
      1,
      NULL,
      5,
      0,
      NULL,
      1,
      1.446690,
      '10-12-2002',
      163,
      ' 4-10-1999',
      183.963500,
      NULL,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      1.119291,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.456190,
      1,
      NULL,
      0.163417,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.298375,
      1,
      NULL,
      1,
      1,
      1,
      11.045208,
      1.490909,
      1.774975,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      60,
      NULL,
      2,
      0,
      0.282491,
      '02200',
      '00400',
      '',
      0,
      '',
      '',
      '',
      0.926744,
      NULL,
      NULL,
      '',
      2,
      NULL,
      86.099608,
      32,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.750822,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.326205,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      6,
      4.408989,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.783202,
      1.026761,
      1,
      NULL,
      NULL,
      NULL,
      1.672297,
      NULL,
      2.720511,
      NULL,
      1.842033,
      NULL,
      1,
      1.685794,
      NULL,
      0.172270,
      NULL,
      1.053779,
      0.379454,
      0.044185,
      1.120908,
      1,
      1.612069,
      0,
      0.662855,
      NULL,
      NULL,
      NULL,
      0.121480,
      NULL,
      NULL,
      1.399519,
      NULL,
      NULL,
      NULL,
      3,
      7.053974,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.471517,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.658127,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.016098,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.675331,
      NULL,
      NULL,
      1.691041,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.345951,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      2.482775,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.783863,
      NULL,
      NULL,
      0.903586,
      3,
      1,
      1.262996,
      3,
      0.520765,
      2,
      2.656683,
      1.024596,
      3.216012,
      1,
      2,
      3.778220,
      6,
      2,
      4,
      5,
      2.720421,
      3.766882,
      1,
      3,
      1,
      1.959167,
      1,
      0.659963,
      0.227660,
      0.880245,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.051050,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.062787,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.637098,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.775947,
      0,
      NULL,
      1,
      1,
      0,
      1.460862,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.205648,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.711167,
      NULL,
      NULL,
      NULL,
      0.052302,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.067946,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.638454,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.144281,
      NULL,
      NULL,
      1.756190,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      11059,
      1930,
      1,
      0.440141,
      1.419376,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0.448303,
      0.661647,
      1,
      0.303229,
      0.661951,
      1,
      0.999405,
      0,
      NULL,
      NULL,
      NULL,
      3.660595,
      NULL,
      1.880318,
      NULL,
      0,
      NULL,
      0.772060,
      NULL,
      52,
      NULL,
      0,
      7,
      24.388726,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.776474,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.502811,
      NULL,
      0,
      NULL,
      1.467552,
      NULL,
      NULL,
      NULL,
      0.515829,
      NULL,
      0,
      NULL,
      1.885658,
      NULL,
      0.619820,
      3.832732,
      NULL,
      1.771193,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.802617,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.750532,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.345523,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      0.089722,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      0,
      6,
      3,
      NULL,
      2,
      2,
      NULL,
      3,
      2.413412,
      0.540438,
      7,
      6,
      NULL,
      19,
      2.501923,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      15.326645,
      NULL,
      1,
      3.650780,
      NULL,
      6.007362,
      NULL,
      NULL,
      13,
      18.664738,
      NULL,
      1.048777,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      15.040382,
      NULL,
      NULL,
      14.317808,
      16,
      NULL,
      1,
      1,
      1.875648,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.551240,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.742903,
      NULL,
      1.097781,
      NULL,
      NULL,
      5,
      2,
      0.803943,
      NULL,
      NULL,
      1,
      57.650645,
      3,
      1.736477,
      5,
      '22110',
      NULL,
      '',
      1,
      NULL,
      '',
      NULL,
      1.423915,
      NULL,
      '',
      '');
commit;
end;
/


