set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9009166';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-4-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '3',
      NULL,
      NULL,
      '1141241',
      NULL,
      0.013101,
      0,
      1,
      '0344',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      3.108245,
      NULL,
      '11-18-1980',
      35,
      2.406837,
      NULL,
      65,
      3,
      ' 5-15-2002',
      ' 8-16-1986',
      NULL,
      3.370913,
      NULL,
      0.628529,
      1.663534,
      0,
      1,
      2,
      1,
      0.653298,
      5.400255,
      4,
      11.062329,
      NULL,
      25.020096,
      4.024819,
      1,
      8.454464,
      1,
      1,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.203653,
      1.595000,
      1,
      1.046574,
      NULL,
      NULL,
      1,
      2,
      3,
      2,
      1,
      NULL,
      4,
      NULL,
      1,
      NULL,
      NULL,
      2,
      0,
      0,
      NULL,
      0,
      7.669926,
      1,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      3.102254,
      2,
      2,
      0,
      1,
      5,
      0,
      NULL,
      1,
      1,
      3.689413,
      3.307557,
      1,
      3,
      0,
      2.160675,
      3,
      0,
      1.172665,
      1.664612,
      2,
      NULL,
      3,
      0,
      NULL,
      3,
      0,
      0,
      3,
      1,
      NULL,
      NULL,
      3.823482,
      2,
      NULL,
      1,
      NULL,
      0,
      1,
      1,
      1,
      4,
      1,
      0,
      1,
      NULL,
      1,
      1,
      1,
      0,
      1,
      1,
      1,
      1,
      NULL,
      1.476286,
      1,
      1,
      2,
      3,
      1,
      0,
      3,
      1,
      0,
      0,
      2,
      2,
      0,
      1,
      1,
      0,
      0,
      0,
      0,
      1,
      1,
      2,
      5,
      NULL,
      NULL,
      4.298343,
      NULL,
      ' 2-13-1983',
      9,
      ' 1-23-1999',
      18.307821,
      0.581434,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      4,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      23.279957,
      1,
      1,
      5,
      1.561787,
      1.493875,
      2,
      0.944861,
      1,
      3,
      0,
      3.311478,
      1.105487,
      3,
      2,
      NULL,
      4.055519,
      5.362053,
      4.337510,
      NULL,
      0.696870,
      2,
      0.957955,
      NULL,
      NULL,
      3,
      5.984291,
      3,
      0,
      1,
      0,
      7.600358,
      NULL,
      NULL,
      ' 3- 2-1987',
      22.767333,
      0.243953,
      1,
      1,
      0.351349,
      1.564727,
      1.851901,
      1.385993,
      NULL,
      1.753378,
      1.028454,
      0.657877,
      NULL,
      0.802154,
      0.771893,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0.790048,
      NULL,
      NULL,
      1,
      1,
      3,
      2,
      3,
      NULL,
      0,
      NULL,
      2.153138,
      3.585625,
      2,
      3,
      1,
      NULL,
      NULL,
      0.780524,
      0.342812,
      1,
      0.593505,
      1,
      NULL,
      0,
      1,
      0,
      0,
      NULL,
      0.192407,
      6,
      NULL,
      7,
      4.447722,
      5,
      0.125512,
      1,
      0.990270,
      0.925504,
      1,
      NULL,
      2,
      30,
      NULL,
      0.693742,
      NULL,
      52,
      NULL,
      59,
      NULL,
      0,
      2,
      '23302',
      '',
      '',
      0,
      NULL,
      NULL,
      NULL,
      1.961462,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.092346,
      5.534810,
      2,
      1.150678,
      NULL,
      NULL,
      0.896183,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.812575,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      138.830315,
      3.370494,
      1,
      0.807553,
      0.045257,
      1,
      1,
      NULL,
      1,
      1.981053,
      0,
      0,
      0,
      1.785769,
      1,
      0,
      1.777272,
      0.778182,
      0,
      0.261412,
      NULL,
      0,
      NULL,
      1.781272,
      NULL,
      0.221356,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.447809,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.794352,
      0.307324,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.054810,
      1.150536,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.607783,
      1.999083,
      NULL,
      1,
      NULL,
      0.400514,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.839074,
      NULL,
      1.060838,
      NULL,
      0.526903,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.748725,
      NULL,
      NULL,
      NULL,
      1,
      0.654737,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      2.349388,
      1,
      1.356649,
      3.928349,
      2,
      1.875627,
      1.126937,
      1.956246,
      NULL,
      0.436449,
      1.190898,
      NULL,
      0,
      0.357692,
      NULL,
      1.153230,
      0,
      NULL,
      NULL,
      2.356945,
      NULL,
      1,
      0,
      NULL,
      0.480207,
      NULL,
      NULL,
      0,
      0.678402,
      NULL,
      0,
      0.487672,
      NULL,
      1,
      0.188529,
      NULL,
      0.883549,
      0,
      NULL,
      3.932980,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.566181,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      82,
      52.731310,
      0,
      1.064070,
      2.795240,
      '32333',
      '',
      NULL,
      0,
      '',
      '',
      '',
      0.603899,
      '',
      '',
      '');
commit;
end;
/


