set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7004058';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-7-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '3',
      NULL,
      NULL,
      '0004020',
      3.698171,
      0.049292,
      2,
      2,
      '4214',
      0.554977,
      0,
      NULL,
      NULL,
      ' 0- 2-1999',
      14,
      NULL,
      2,
      2.792890,
      1,
      ' 1-18-1994',
      NULL,
      0.688043,
      82.486767,
      163,
      1,
      ' 2-19-1993',
      NULL,
      ' 2- 0-1997',
      2.107644,
      3.463944,
      NULL,
      0.743073,
      NULL,
      1,
      1,
      0.973813,
      0,
      193,
      6,
      18,
      1,
      93,
      NULL,
      5,
      6,
      1,
      3,
      7,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1.034057,
      0.620058,
      NULL,
      1.266362,
      0,
      62.387057,
      7,
      2,
      2,
      1.196078,
      0,
      1,
      NULL,
      0,
      0,
      4,
      2,
      0,
      3,
      NULL,
      0,
      1,
      8,
      NULL,
      0,
      NULL,
      2,
      1.943575,
      NULL,
      NULL,
      0.531168,
      NULL,
      NULL,
      NULL,
      1,
      1.044504,
      2,
      0.945274,
      NULL,
      NULL,
      2.612262,
      NULL,
      0.245704,
      0.591496,
      3.148607,
      NULL,
      2.537068,
      0,
      1.315134,
      2,
      2,
      2.666932,
      0,
      0,
      0,
      3,
      1,
      0,
      0.950911,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      3,
      1,
      NULL,
      3,
      NULL,
      0,
      0,
      1,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      2,
      1,
      2,
      NULL,
      0,
      NULL,
      1,
      0,
      1,
      1,
      5,
      5,
      2,
      3,
      4,
      NULL,
      NULL,
      4,
      0,
      NULL,
      2,
      1,
      4,
      6.912335,
      1,
      '10- 4-1993',
      1223.606315,
      ' 7- 2-1999',
      1895,
      3.252108,
      1,
      0,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0,
      1,
      NULL,
      2.519268,
      0,
      5.067170,
      NULL,
      7.867632,
      3.380311,
      2.187387,
      7,
      1,
      NULL,
      NULL,
      0,
      5.149332,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.599688,
      NULL,
      0.820671,
      2,
      0.550673,
      NULL,
      0.046379,
      3.873193,
      14794,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2,
      1,
      2,
      3,
      2,
      1,
      0,
      0,
      NULL,
      2,
      1,
      1.227344,
      2,
      3,
      2,
      1,
      0,
      2,
      0.438278,
      1,
      NULL,
      0.988033,
      1.462493,
      1,
      0.625536,
      1.301832,
      0,
      NULL,
      NULL,
      0.074773,
      NULL,
      7.319524,
      NULL,
      NULL,
      2.935057,
      5,
      4.084878,
      3.985827,
      7,
      2.372604,
      2,
      0,
      28,
      0,
      3.708794,
      NULL,
      32,
      18,
      40,
      1,
      NULL,
      0,
      NULL,
      '',
      NULL,
      0,
      '',
      '',
      '',
      0.453919,
      '',
      NULL,
      '',
      2,
      3.688680,
      505.060948,
      26.398392,
      0,
      13.404152,
      0.022255,
      1.049944,
      5,
      3,
      1,
      NULL,
      1.772261,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.454073,
      0.780693,
      NULL,
      2.174502,
      3,
      1,
      1.559967,
      0,
      0,
      0,
      3,
      1.228356,
      0.202142,
      NULL,
      NULL,
      3,
      1.558312,
      2.553352,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1.554992,
      1,
      0.182410,
      1,
      9,
      5.364890,
      6.594696,
      1,
      1.408580,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.147080,
      0.787109,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.945246,
      1.559373,
      NULL,
      3.546554,
      0.077351,
      0.635161,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1.576849,
      1.451603,
      0.171251,
      0,
      NULL,
      2,
      1.984596,
      NULL,
      0,
      NULL,
      NULL,
      2,
      1,
      NULL,
      0.808904,
      2.630560,
      9.965740,
      0,
      0.158581,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0.816469,
      NULL,
      NULL,
      10.154652,
      0.189747,
      5.221893,
      0.306515,
      1.632741,
      0.412343,
      1,
      1.526601,
      1,
      4.210548,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.970330,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      3.551282,
      3.039343,
      0,
      0,
      NULL,
      5.668472,
      0.015694,
      2.821707,
      5.431946,
      6,
      3.205811,
      4.993329,
      1.967346,
      5,
      0,
      1.307838,
      2,
      2,
      2,
      3,
      NULL,
      1,
      1,
      9.491042,
      5.420356,
      NULL,
      2.129887,
      0.808665,
      1.688858,
      2.749411,
      1,
      1.070460,
      0,
      1,
      2.222573,
      3,
      3.723508,
      2.922543,
      0.307072,
      NULL,
      4.372412,
      4,
      1.129416,
      NULL,
      3.716886,
      0,
      3,
      0,
      1,
      1.800479,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.275925,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.112584,
      NULL,
      NULL,
      0.657729,
      NULL,
      NULL,
      1.307149,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.882551,
      2.211044,
      2,
      NULL,
      0,
      3.053863,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.132809,
      NULL,
      NULL,
      NULL,
      0.178515,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.371383,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.820174,
      NULL,
      NULL,
      NULL,
      1.046699,
      NULL,
      NULL,
      NULL,
      0.053887,
      NULL,
      NULL,
      3,
      1.081518,
      564,
      505,
      0.480068,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      480,
      1885.665364,
      NULL,
      NULL,
      NULL,
      NULL,
      736,
      1998,
      3.448641,
      30.213239,
      1.616020,
      81,
      21.732840,
      1.587454,
      0,
      0.895513,
      0.749883,
      0,
      1.892403,
      1.197412,
      NULL,
      NULL,
      1,
      0,
      1,
      0.840694,
      0.708184,
      1,
      NULL,
      1,
      0.369093,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1,
      4,
      2,
      4,
      5.910962,
      3,
      NULL,
      1.225471,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1.910409,
      1.159868,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0.234528,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      0.648767,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1.271362,
      0,
      NULL,
      0.544626,
      0,
      0.742674,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.398376,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      2,
      2,
      0,
      3.998967,
      NULL,
      NULL,
      2.841268,
      11,
      0,
      1,
      3,
      '12224',
      '',
      '',
      1.029686,
      '',
      '',
      '',
      NULL,
      '2124',
      '',
      '');
commit;
end;
/


