set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8421847';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-2-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '0',
      NULL,
      NULL,
      '3211344',
      2.160759,
      1.243183,
      NULL,
      1,
      '3343',
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      56.226648,
      NULL,
      5,
      1.636738,
      NULL,
      NULL,
      39,
      NULL,
      162.863923,
      NULL,
      0,
      ' 2-18-1994',
      ' 4- 1-1992',
      ' 3-18-1997',
      1,
      2,
      3,
      0.406906,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      5.832310,
      0,
      5,
      25.031109,
      3,
      13,
      4,
      NULL,
      NULL,
      2.038792,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      3,
      1,
      0,
      2,
      1,
      1,
      4,
      1,
      0,
      0,
      1,
      0,
      0,
      3,
      1,
      1,
      NULL,
      NULL,
      0.089075,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.598434,
      1,
      1.445035,
      1.593715,
      1.867780,
      1.518498,
      3.700091,
      1,
      1,
      NULL,
      3.308225,
      1.967423,
      2.537568,
      NULL,
      0.833940,
      3.641901,
      1,
      NULL,
      1,
      3.491345,
      NULL,
      1,
      1.366333,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      NULL,
      0,
      0,
      2,
      3,
      NULL,
      1,
      1,
      4,
      0,
      0,
      1,
      NULL,
      1,
      1,
      0,
      0,
      0.615830,
      NULL,
      0,
      NULL,
      2,
      0,
      0,
      5,
      0,
      NULL,
      0,
      1,
      3,
      1,
      0,
      2,
      1,
      NULL,
      3,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      4,
      4,
      NULL,
      0,
      NULL,
      7.635616,
      ' 5- 5-1977',
      9.165136,
      1.905013,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      1.415216,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.345734,
      0,
      0.007826,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      7.137051,
      1,
      NULL,
      0.499147,
      0,
      NULL,
      NULL,
      NULL,
      2.784219,
      10.640467,
      1,
      0,
      4,
      0,
      NULL,
      ' 6- 0-1996',
      4.884364,
      ' 8-10-1998',
      NULL,
      1,
      0,
      1.905673,
      NULL,
      NULL,
      1.135912,
      0,
      2,
      0,
      1.205883,
      3.840738,
      38.337587,
      1.670509,
      0.135893,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3,
      2,
      3,
      0,
      1,
      NULL,
      0,
      NULL,
      1,
      0,
      0,
      2,
      0.384447,
      2.452517,
      2,
      NULL,
      0.853115,
      0.056900,
      0.014588,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.104145,
      0.669689,
      0,
      1.662883,
      0,
      NULL,
      3,
      NULL,
      1,
      1.019392,
      1.024425,
      1.229355,
      4.747788,
      2.698047,
      NULL,
      NULL,
      3,
      3.482452,
      NULL,
      0,
      1,
      NULL,
      37,
      10,
      12.301718,
      1,
      0.409257,
      NULL,
      '41321',
      '',
      '',
      1,
      '',
      '',
      '',
      1,
      '',
      NULL,
      '',
      3.115326,
      31.172259,
      129,
      7,
      0.705394,
      37.130375,
      20,
      NULL,
      2,
      2,
      0,
      1.662451,
      0,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      1,
      0.073737,
      0.170977,
      NULL,
      0,
      2,
      0.643791,
      0,
      1.593598,
      1,
      1.945029,
      0.850362,
      NULL,
      NULL,
      3,
      1.058756,
      1,
      1.412098,
      NULL,
      NULL,
      0.766346,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.481691,
      1.265353,
      2.385698,
      1,
      0,
      2,
      1.400327,
      NULL,
      1.473015,
      NULL,
      3,
      3.289577,
      0,
      NULL,
      2.905067,
      0.946454,
      1,
      2,
      0,
      NULL,
      0,
      3.648886,
      0.166303,
      2.758239,
      NULL,
      0,
      1,
      1,
      1.781720,
      3.234970,
      0.796516,
      3.862411,
      NULL,
      1,
      3.509039,
      1.877314,
      1,
      0,
      NULL,
      NULL,
      1.917485,
      NULL,
      NULL,
      0.740588,
      NULL,
      NULL,
      6.808125,
      0.113318,
      0,
      NULL,
      3,
      3.106709,
      NULL,
      NULL,
      1.698921,
      1,
      0,
      2.943242,
      0,
      NULL,
      NULL,
      2,
      1.482154,
      1.941719,
      0.113229,
      NULL,
      NULL,
      0.814984,
      NULL,
      NULL,
      NULL,
      0.930456,
      1,
      1,
      1.838641,
      1,
      3.565372,
      0,
      0,
      6.814344,
      1,
      0.060292,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.699174,
      NULL,
      NULL,
      1.292250,
      1,
      1,
      0.000214,
      0,
      0,
      NULL,
      1.792182,
      0.190704,
      4.028107,
      0.399609,
      0.578152,
      3,
      NULL,
      0.873355,
      NULL,
      NULL,
      NULL,
      2,
      1.476700,
      0,
      NULL,
      NULL,
      0.463737,
      8,
      8.484406,
      1,
      0.011002,
      3.680463,
      1,
      1.266928,
      NULL,
      0.738320,
      3,
      3,
      1,
      3,
      1.532911,
      0,
      0.405156,
      3,
      1,
      2.595591,
      9.395739,
      3,
      2.399343,
      3,
      0,
      1,
      0.988980,
      1,
      3.365260,
      NULL,
      NULL,
      2,
      NULL,
      1.875784,
      NULL,
      6,
      NULL,
      1.236564,
      3.868885,
      NULL,
      1,
      NULL,
      NULL,
      0.151054,
      NULL,
      NULL,
      0,
      3.103966,
      NULL,
      2,
      NULL,
      1,
      0,
      0.503404,
      1,
      0,
      1,
      0,
      3,
      1,
      1,
      3,
      3,
      3,
      NULL,
      NULL,
      0.116607,
      NULL,
      1.057022,
      NULL,
      8.865359,
      1.812388,
      0.943951,
      2,
      0,
      1,
      3.939296,
      0,
      NULL,
      2.211681,
      1.948963,
      0,
      7.278897,
      1.873915,
      3,
      0,
      7.940685,
      9.192122,
      11,
      NULL,
      2,
      1.020491,
      1.894399,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1.978447,
      1,
      0,
      1,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.425283,
      1,
      0,
      1,
      3,
      NULL,
      3,
      2.767663,
      0,
      1.693369,
      0,
      1.709017,
      3,
      0,
      0,
      2,
      1.657396,
      0.659435,
      1,
      0.252927,
      1,
      1.327467,
      1,
      NULL,
      0,
      3,
      NULL,
      3.511812,
      NULL,
      NULL,
      1.095752,
      1.377186,
      3.030365,
      NULL,
      1,
      3.602548,
      NULL,
      1.945908,
      0.688737,
      0.183348,
      3,
      NULL,
      1,
      1,
      NULL,
      2.230734,
      3,
      2.918781,
      9.815130,
      9,
      1.083276,
      1.751810,
      0.567643,
      2.442708,
      1,
      NULL,
      3,
      NULL,
      1,
      103,
      14.311829,
      3.318338,
      6,
      1.443877,
      0,
      6.691692,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      7.181896,
      2.749020,
      25,
      NULL,
      0,
      4,
      NULL,
      80,
      0,
      NULL,
      1,
      NULL,
      1.924518,
      1.496755,
      NULL,
      1.495802,
      1.536868,
      0,
      1.095038,
      1.772443,
      NULL,
      0,
      NULL,
      NULL,
      1.800206,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.539941,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1,
      2.805397,
      3,
      NULL,
      0.151373,
      1,
      9.427528,
      0,
      1.904024,
      3,
      1.208807,
      1.861338,
      1,
      1,
      1.272442,
      1.165582,
      3,
      NULL,
      2,
      NULL,
      0,
      0.762376,
      0,
      NULL,
      NULL,
      0.555970,
      NULL,
      1.350971,
      0,
      2.881583,
      1,
      1.142582,
      0,
      0,
      0,
      1.167978,
      1.091146,
      0.488994,
      1.982339,
      1.108457,
      1,
      1.134840,
      0.303169,
      1,
      2.598959,
      0.069623,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.104528,
      1.553532,
      3.482205,
      2,
      2.398560,
      0,
      3,
      NULL,
      3.224406,
      2.265133,
      3,
      2,
      2,
      NULL,
      0.042159,
      3.622950,
      2,
      0.496444,
      0,
      NULL,
      1,
      2,
      3.187561,
      1,
      NULL,
      NULL,
      28,
      0.317644,
      NULL,
      1,
      0,
      1.699607,
      2,
      0.415563,
      0,
      2,
      6,
      NULL,
      1,
      NULL,
      NULL,
      11.233885,
      8.408003,
      3,
      0,
      5,
      '02321',
      NULL,
      '30002',
      2.875827,
      '30203',
      '',
      '',
      NULL,
      NULL,
      '14212',
      '');
commit;
end;
/


