set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7719348';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-11-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '1',
      NULL,
      NULL,
      '3240333',
      1,
      1,
      0,
      NULL,
      '2332',
      3,
      0.538542,
      NULL,
      NULL,
      ' 9-26-1998',
      63,
      NULL,
      2,
      2.639323,
      NULL,
      ' 0-17-1979',
      38,
      2,
      210,
      113.480199,
      2,
      '10-18-2000',
      '11-13-1991',
      ' 8- 1-1991',
      0,
      0.175287,
      NULL,
      0.876336,
      NULL,
      NULL,
      NULL,
      0.074724,
      NULL,
      125.845667,
      4,
      19,
      3.478139,
      13.810973,
      25.727361,
      NULL,
      7.124979,
      3,
      NULL,
      0.573661,
      1.701989,
      0,
      NULL,
      0.188916,
      0,
      1.223758,
      1,
      1,
      0,
      1.787550,
      143.886266,
      1,
      0,
      1,
      3,
      3,
      0,
      4,
      4,
      NULL,
      NULL,
      2,
      1,
      2,
      0,
      0,
      0,
      8.888496,
      0,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      2,
      NULL,
      0,
      NULL,
      2,
      2.904238,
      1,
      1,
      NULL,
      1,
      1.997506,
      3,
      0.370604,
      1.334641,
      1.027761,
      3,
      1,
      4,
      6.884206,
      1,
      0,
      0,
      1.418995,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      5,
      3,
      3,
      NULL,
      NULL,
      1,
      1,
      1,
      2,
      1,
      0,
      0,
      NULL,
      0,
      0,
      NULL,
      0,
      1.988451,
      NULL,
      NULL,
      2,
      2,
      4,
      2,
      4,
      5,
      0,
      NULL,
      0,
      2,
      5,
      1,
      2,
      1,
      NULL,
      5,
      0,
      NULL,
      3,
      NULL,
      NULL,
      3,
      4,
      2,
      NULL,
      3.937187,
      0.924217,
      NULL,
      157.619301,
      '10- 5-1982',
      817,
      0,
      1,
      1,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      7,
      1.420330,
      1,
      7.068273,
      4.221418,
      1,
      NULL,
      NULL,
      1.256764,
      2,
      1.150092,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      2,
      3378,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3.920231,
      NULL,
      3,
      1,
      0,
      1,
      0,
      2,
      1,
      2,
      2,
      2.888416,
      1,
      0.903545,
      0,
      NULL,
      NULL,
      6.280801,
      0.772321,
      1.509097,
      1,
      0.599902,
      1,
      1.151190,
      NULL,
      1.134836,
      1,
      2.621578,
      3.500366,
      NULL,
      3.835205,
      4.680032,
      2.796573,
      1,
      4.586140,
      3.298930,
      3,
      1,
      NULL,
      2,
      3.404671,
      NULL,
      NULL,
      2,
      3,
      NULL,
      NULL,
      NULL,
      50,
      1,
      NULL,
      NULL,
      '10314',
      '43403',
      '',
      NULL,
      NULL,
      '',
      NULL,
      NULL,
      '0420',
      '4024',
      '20134',
      1,
      24.248726,
      306.076019,
      35.838712,
      2,
      NULL,
      7,
      169,
      2,
      3.578953,
      1,
      2,
      0,
      NULL,
      NULL,
      2.201187,
      0,
      2,
      1,
      NULL,
      2.360594,
      NULL,
      0,
      2,
      2,
      NULL,
      0,
      2.255172,
      0.631318,
      0,
      0.094562,
      NULL,
      NULL,
      1.642093,
      1,
      0,
      0.075632,
      0.299338,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      7.831914,
      NULL,
      1,
      0.552937,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.834873,
      3,
      1,
      1,
      NULL,
      NULL,
      0.754989,
      NULL,
      NULL,
      0.569895,
      3,
      1,
      2,
      3.979388,
      2.602586,
      3,
      NULL,
      NULL,
      1,
      0.918280,
      1.044384,
      NULL,
      0.041968,
      1.798619,
      0,
      2.997953,
      0,
      NULL,
      0.620998,
      NULL,
      NULL,
      1.042787,
      NULL,
      NULL,
      0.598036,
      9.760804,
      7,
      0,
      0.010494,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1,
      3,
      2,
      3,
      1.648455,
      NULL,
      NULL,
      10.759637,
      1.248174,
      7,
      NULL,
      2,
      NULL,
      1.206938,
      NULL,
      NULL,
      3,
      4.041622,
      8.342354,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.248455,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      1.116716,
      2,
      2.775294,
      2.433888,
      3.871208,
      NULL,
      4.632574,
      4,
      0.945702,
      3.664189,
      NULL,
      NULL,
      2,
      6,
      0.837221,
      0,
      NULL,
      2.123228,
      2,
      3,
      0.588189,
      1.162509,
      3,
      6,
      5,
      2,
      1.659620,
      0,
      0,
      NULL,
      2,
      3.662893,
      2.474249,
      3.872244,
      2.676021,
      NULL,
      1.816279,
      0,
      NULL,
      4.223836,
      NULL,
      6,
      NULL,
      9,
      1,
      3,
      3,
      1.896603,
      1,
      1,
      NULL,
      0.303988,
      2.525928,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.349100,
      NULL,
      NULL,
      0.044304,
      NULL,
      NULL,
      1.462327,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.153786,
      NULL,
      NULL,
      1,
      0.034447,
      1,
      0.653121,
      1.077160,
      NULL,
      NULL,
      NULL,
      NULL,
      0.376352,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.170492,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.118876,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.462750,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.393172,
      NULL,
      NULL,
      NULL,
      1.435463,
      30,
      11,
      NULL,
      33.162128,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.770897,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      0,
      243.307812,
      5.185215,
      0,
      1,
      0.557472,
      0.154595,
      0,
      0,
      1,
      0,
      NULL,
      0,
      1.504999,
      0,
      1.256369,
      0.136842,
      NULL,
      0.168353,
      0.605575,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.616539,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.840215,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.894682,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.324270,
      NULL,
      NULL,
      0.642885,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.614306,
      NULL,
      0.086825,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.545950,
      0.196218,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.432944,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      197.760111,
      NULL,
      2.288252,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      2,
      32.202983,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      12,
      5,
      7.575467,
      0.634075,
      NULL,
      8,
      3.794108,
      NULL,
      1,
      1,
      3.985392,
      NULL,
      0,
      2.974240,
      NULL,
      2,
      2,
      NULL,
      0,
      0.839855,
      NULL,
      1.062676,
      1,
      NULL,
      1,
      0.097357,
      NULL,
      1,
      1,
      NULL,
      0.286195,
      0,
      NULL,
      NULL,
      1.098387,
      NULL,
      2,
      1.249831,
      NULL,
      1.203176,
      NULL,
      NULL,
      3,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.245502,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      3,
      NULL,
      3.002831,
      1.471805,
      NULL,
      20,
      25,
      NULL,
      NULL,
      5,
      '02030',
      '30411',
      '04231',
      NULL,
      '',
      '',
      '',
      6.124656,
      '2130',
      '0322',
      NULL);
commit;
end;
/


