set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6100037';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-3-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      NULL,
      NULL,
      NULL,
      '0301310',
      3,
      NULL,
      2,
      2,
      NULL,
      1,
      0,
      NULL,
      NULL,
      ' 2-25-1977',
      60,
      NULL,
      4,
      3.195382,
      NULL,
      NULL,
      81.117032,
      0,
      24,
      55.315995,
      3,
      ' 9- 0-1980',
      NULL,
      ' 4- 5-2003',
      0,
      1.018891,
      NULL,
      1,
      1.736173,
      1,
      2,
      NULL,
      1,
      115.917415,
      4,
      14.270282,
      4,
      23,
      16,
      3,
      13.824455,
      4,
      0,
      1,
      0.996751,
      0,
      3,
      1,
      1,
      1,
      1.416153,
      0.508121,
      NULL,
      1.617973,
      1.422423,
      2,
      0,
      6,
      2.780455,
      2,
      NULL,
      0,
      1,
      1,
      1,
      3,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      1,
      1,
      1.482656,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0.658252,
      1,
      0.708329,
      1,
      0,
      NULL,
      0,
      0,
      3,
      1,
      NULL,
      0,
      0.955300,
      NULL,
      0.381001,
      0.534917,
      NULL,
      0,
      0,
      0,
      4,
      1,
      2,
      1,
      1.600637,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1,
      3,
      NULL,
      4,
      0,
      1,
      5,
      0,
      1,
      0,
      1,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      4,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      3,
      0,
      0,
      0,
      0,
      NULL,
      2,
      NULL,
      0,
      0,
      1,
      4,
      0,
      NULL,
      4,
      2,
      0,
      3,
      ' 7- 0-1997',
      13,
      ' 2-12-1999',
      6,
      0.893024,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      1,
      0,
      0,
      1.519664,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.906824,
      0,
      0.488563,
      1,
      1.389000,
      NULL,
      1,
      1,
      0,
      0,
      0.765617,
      0.476689,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1.781176,
      0.344112,
      NULL,
      1,
      0.636000,
      63.882403,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0.284032,
      3,
      3,
      0,
      2,
      NULL,
      NULL,
      0,
      3,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1.154913,
      1.294246,
      0,
      1,
      0.429257,
      1.319759,
      NULL,
      1,
      1,
      0,
      2,
      2.194808,
      5.283542,
      0,
      3,
      11,
      NULL,
      3.335023,
      3,
      1.642289,
      4,
      2,
      3.921245,
      3,
      3.275304,
      NULL,
      18,
      1,
      0,
      NULL,
      77,
      16,
      27,
      5,
      4.920843,
      3.240278,
      '21243',
      '',
      '',
      1.403711,
      NULL,
      '',
      NULL,
      1,
      '',
      '',
      '',
      NULL,
      3.032405,
      348,
      15.941253,
      2.509938,
      44.722191,
      17.773898,
      11,
      3,
      3.238039,
      0,
      0,
      0.536039,
      NULL,
      NULL,
      1.240014,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.926986,
      NULL,
      NULL,
      0.078340,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.699543,
      NULL,
      NULL,
      1.982031,
      NULL,
      NULL,
      0.900854,
      NULL,
      NULL,
      7.918194,
      3.450504,
      4,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3.403155,
      NULL,
      0,
      NULL,
      NULL,
      0.103508,
      NULL,
      NULL,
      1,
      1,
      1.796152,
      1.681317,
      NULL,
      1,
      0.784690,
      NULL,
      1.322453,
      NULL,
      0,
      NULL,
      3,
      0.587554,
      1,
      NULL,
      0.133298,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.188441,
      NULL,
      NULL,
      6,
      5,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.851003,
      NULL,
      NULL,
      NULL,
      0.392081,
      NULL,
      NULL,
      3,
      2.527224,
      3.041429,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      9.578741,
      1,
      1.823921,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.691763,
      NULL,
      NULL,
      1.826731,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.104570,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      4.612123,
      0,
      1.853055,
      5.306595,
      0.699552,
      3.596717,
      2.513632,
      0.666243,
      0.185947,
      0.595532,
      NULL,
      NULL,
      1,
      3.937377,
      3.378921,
      0.967346,
      NULL,
      NULL,
      NULL,
      NULL,
      1.498334,
      2.137927,
      2.652930,
      1.992288,
      3.636565,
      1.604069,
      NULL,
      0,
      3,
      3.516450,
      NULL,
      2,
      3.165017,
      6.917831,
      1.326101,
      5.012475,
      5.006653,
      NULL,
      3,
      1.453355,
      3,
      2,
      0.974072,
      1.509932,
      NULL,
      0.185021,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.363839,
      NULL,
      NULL,
      1.494134,
      NULL,
      NULL,
      1.212071,
      NULL,
      NULL,
      1.077508,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.038379,
      NULL,
      NULL,
      1.356740,
      NULL,
      NULL,
      0,
      1.011368,
      NULL,
      1.489847,
      1,
      3.127928,
      1.984865,
      NULL,
      NULL,
      3,
      6.518801,
      NULL,
      NULL,
      2.098084,
      2.210312,
      NULL,
      NULL,
      0,
      0.522762,
      NULL,
      NULL,
      0.447953,
      NULL,
      NULL,
      NULL,
      NULL,
      1.374622,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.739502,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0.925934,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.097606,
      NULL,
      NULL,
      1.664863,
      0,
      NULL,
      NULL,
      1,
      0.671479,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.313233,
      NULL,
      28,
      1.580483,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.943137,
      NULL,
      NULL,
      1.945872,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.816116,
      NULL,
      0.221209,
      47,
      23.036294,
      0.821451,
      1.319545,
      0.975583,
      0,
      1.525342,
      1.215457,
      NULL,
      1.198646,
      0.939390,
      NULL,
      1,
      0.273597,
      0.631298,
      1,
      0.769204,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3.887349,
      NULL,
      3,
      NULL,
      2.400696,
      25,
      NULL,
      3,
      0.273239,
      NULL,
      NULL,
      1.432299,
      NULL,
      0.632338,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.910659,
      NULL,
      NULL,
      NULL,
      0.614084,
      NULL,
      1.078900,
      NULL,
      2.393498,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.703405,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.713895,
      1.510562,
      NULL,
      1,
      NULL,
      1.449453,
      NULL,
      NULL,
      NULL,
      1.879769,
      NULL,
      1,
      NULL,
      0.593602,
      NULL,
      0.306664,
      1,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      1.410522,
      0.685403,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.613709,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.029940,
      0,
      NULL,
      1,
      NULL,
      1.504360,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      NULL,
      NULL,
      1.744856,
      0.906795,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      3,
      9,
      2.436376,
      0,
      NULL,
      2,
      12,
      1,
      0,
      1,
      0,
      0,
      0.496132,
      0.272435,
      1.666670,
      1.027035,
      0.778058,
      0,
      0,
      0.406371,
      0.797342,
      NULL,
      1,
      0.485317,
      0.358932,
      1,
      1.610608,
      0,
      1.429036,
      NULL,
      2.347804,
      0,
      0.618300,
      1,
      0.443420,
      0,
      1.453993,
      1,
      1.529873,
      NULL,
      NULL,
      1.452952,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      0,
      0,
      3,
      NULL,
      2,
      NULL,
      1.127964,
      1,
      NULL,
      69.000845,
      0,
      4.242629,
      5.148310,
      '33040',
      '40100',
      '',
      0,
      '',
      '',
      '',
      0.626802,
      NULL,
      '',
      '');
commit;
end;
/


