set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8825603';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-10-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2013044',
      1,
      1,
      1,
      NULL,
      '2003',
      NULL,
      1.250651,
      NULL,
      NULL,
      ' 4-25-1997',
      15,
      NULL,
      3,
      NULL,
      NULL,
      ' 5-12-1996',
      26.426101,
      0,
      NULL,
      21,
      0,
      ' 8-12-1993',
      NULL,
      ' 4-21-1980',
      0,
      3.056716,
      0,
      NULL,
      NULL,
      0,
      2,
      0,
      0,
      164,
      5,
      NULL,
      5.845718,
      7,
      22.159635,
      NULL,
      9,
      NULL,
      1,
      9,
      0.273321,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      7,
      0.115164,
      0,
      0,
      0,
      2,
      NULL,
      0,
      5,
      2,
      0,
      1,
      1,
      NULL,
      3.726791,
      3,
      NULL,
      1,
      1,
      1.492257,
      NULL,
      NULL,
      3,
      0,
      0,
      2,
      0,
      1,
      1,
      0.194498,
      1.495122,
      1,
      NULL,
      1,
      0.768243,
      2,
      1.488271,
      0,
      NULL,
      0.306391,
      0.702995,
      1,
      1,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      1,
      0,
      NULL,
      1,
      4,
      1,
      1,
      NULL,
      1,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.666499,
      NULL,
      1,
      0,
      0,
      NULL,
      5,
      NULL,
      5,
      5,
      1,
      5,
      4,
      5,
      NULL,
      NULL,
      0,
      4,
      NULL,
      0,
      2,
      5,
      5,
      2,
      NULL,
      4,
      3,
      3,
      6.432777,
      1,
      NULL,
      NULL,
      ' 4-24-1993',
      3,
      NULL,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      5,
      0,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.233792,
      0.153490,
      1,
      1.317490,
      1,
      0,
      NULL,
      NULL,
      2.411274,
      3.805485,
      3,
      1,
      0,
      NULL,
      NULL,
      3,
      12.746458,
      3.557136,
      NULL,
      4,
      0,
      NULL,
      NULL,
      1385,
      NULL,
      NULL,
      2.717424,
      1,
      NULL,
      3,
      1,
      1.763172,
      1.194745,
      1,
      1.610697,
      1.153231,
      3,
      90.468887,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.462206,
      7.532392,
      5.259029,
      6.753465,
      9,
      0.662776,
      2.741919,
      NULL,
      3,
      NULL,
      3,
      1.199117,
      3,
      26.476974,
      0,
      0.648844,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      '23024',
      NULL,
      '',
      0.181750,
      '',
      NULL,
      '',
      1,
      '',
      NULL,
      '',
      0,
      37.971159,
      267,
      NULL,
      NULL,
      7.884692,
      5.254310,
      NULL,
      1,
      NULL,
      0,
      2.458148,
      3.846416,
      NULL,
      0,
      2.112844,
      NULL,
      0.615884,
      2,
      1.346973,
      3.656040,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      1,
      1.149195,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.640983,
      NULL,
      NULL,
      11.714767,
      NULL,
      0.147175,
      1,
      0.523382,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.338970,
      3,
      1.212264,
      0,
      NULL,
      NULL,
      1.336792,
      NULL,
      NULL,
      3.189077,
      0,
      1.657166,
      1,
      1,
      0,
      1.489767,
      1.312801,
      1.260349,
      0.899596,
      NULL,
      1,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.885869,
      0.776392,
      0,
      1,
      0.420208,
      NULL,
      NULL,
      NULL,
      1.412054,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      6,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.062406,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.461038,
      NULL,
      NULL,
      0.294496,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.836054,
      1.627042,
      0.550823,
      NULL,
      NULL,
      NULL,
      1.441171,
      8,
      2.210442,
      0,
      5.762082,
      1,
      NULL,
      0.947579,
      0.808305,
      NULL,
      NULL,
      0,
      2,
      NULL,
      0.656663,
      3.685286,
      3,
      4.730827,
      NULL,
      9.573440,
      NULL,
      2.436646,
      3.494624,
      1.738293,
      0.847919,
      0,
      3.544682,
      0.130835,
      1.803079,
      1.796368,
      3,
      NULL,
      8.452590,
      9.233043,
      1,
      0.576066,
      7.046000,
      NULL,
      NULL,
      3,
      0,
      NULL,
      0,
      0,
      1,
      NULL,
      0.522894,
      NULL,
      NULL,
      1.630154,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.668071,
      NULL,
      NULL,
      1.756095,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      0,
      0.236431,
      0,
      2,
      2.941714,
      NULL,
      NULL,
      0,
      5.139341,
      NULL,
      NULL,
      9,
      7.388036,
      NULL,
      NULL,
      0.463750,
      1.362997,
      NULL,
      NULL,
      1,
      1.263113,
      NULL,
      NULL,
      1,
      1.001311,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2.149591,
      1.124446,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      1.486412,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      3.022851,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      2.090418,
      1,
      NULL,
      NULL,
      0.204317,
      0,
      NULL,
      NULL,
      0.035602,
      0,
      NULL,
      NULL,
      0.913976,
      2.971224,
      NULL,
      NULL,
      0.530622,
      3,
      NULL,
      NULL,
      2,
      2,
      NULL,
      NULL,
      1.340096,
      2,
      9,
      1,
      0.071392,
      363,
      34,
      NULL,
      40,
      4,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      6,
      1.007350,
      10.072731,
      2,
      1.201261,
      NULL,
      NULL,
      1.124348,
      NULL,
      1,
      NULL,
      308.798445,
      0,
      1.436085,
      NULL,
      1,
      0.533859,
      NULL,
      0,
      1.464081,
      1.267777,
      NULL,
      0.765345,
      1,
      0.147937,
      1,
      1.577109,
      1.527620,
      NULL,
      1.934512,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.092525,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0,
      NULL,
      7,
      9.779210,
      4.263752,
      2,
      NULL,
      2,
      0,
      3.233796,
      NULL,
      0,
      1.356756,
      1,
      NULL,
      NULL,
      0.675765,
      3.585045,
      3,
      NULL,
      1.994520,
      1,
      1.541355,
      3,
      2,
      NULL,
      1,
      NULL,
      1.725193,
      1.280706,
      0,
      0.402903,
      0,
      NULL,
      0.529380,
      1.927208,
      1.411425,
      0.950938,
      1.942361,
      1.117509,
      0,
      0.949523,
      NULL,
      1.676970,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      3,
      NULL,
      3.355533,
      NULL,
      0.886994,
      NULL,
      1,
      NULL,
      2.227329,
      NULL,
      2.073383,
      NULL,
      1,
      NULL,
      3.398259,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.106570,
      NULL,
      2.112423,
      NULL,
      1.209710,
      28,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.854163,
      0.970719,
      NULL,
      6,
      NULL,
      NULL,
      1,
      3,
      54,
      70,
      0,
      1,
      1.005844,
      '22133',
      '',
      '',
      0.424255,
      '',
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


