set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9753884';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-8-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      0,
      4,
      7.740238,
      2.971586,
      0,
      2,
      1.544547,
      1,
      '133',
      NULL,
      45,
      61.805103,
      '0413110',
      0.980075,
      1.229812,
      5,
      2,
      '0312',
      2.214232,
      1.450911,
      NULL,
      NULL,
      ' 3-14-2003',
      41.448361,
      183.221191,
      NULL,
      3.752163,
      NULL,
      ' 0-11-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-14-1982',
      ' 1-11-1988',
      NULL,
      NULL,
      0.481750,
      NULL,
      1.774322,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      11.987788,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1.811006,
      1.789712,
      NULL,
      3,
      1.502620,
      0.731789,
      NULL,
      1,
      4,
      5,
      NULL,
      NULL,
      1,
      1,
      5,
      0,
      0,
      1,
      1,
      1,
      1,
      1,
      NULL,
      7,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      3.515235,
      1.017183,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      4,
      NULL,
      2,
      NULL,
      5,
      0,
      3,
      1,
      NULL,
      NULL,
      1,
      4.362643,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1.823951,
      NULL,
      1,
      0,
      NULL,
      0,
      0,
      NULL,
      1,
      NULL,
      0,
      3,
      0,
      2,
      0,
      0,
      0,
      2,
      4,
      NULL,
      4,
      3,
      1,
      2,
      3,
      3,
      7,
      NULL,
      ' 3- 4-1999',
      33.963662,
      NULL,
      24.196811,
      0,
      0,
      0,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      4,
      0,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.504614,
      2.906862,
      1.075700,
      0,
      4,
      0.463721,
      NULL,
      NULL,
      NULL,
      0.603786,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0.035951,
      1.827216,
      1.273228,
      0.147954,
      1.483715,
      2,
      NULL,
      2.462868,
      1.509215,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      1,
      NULL,
      NULL,
      3,
      3,
      0,
      1,
      NULL,
      1,
      3,
      2.919673,
      1,
      2.997926,
      0.454829,
      1,
      1.243483,
      3.412125,
      NULL,
      1,
      0,
      0.921784,
      0.623405,
      NULL,
      1.581834,
      1,
      NULL,
      0,
      0,
      0,
      NULL,
      3,
      NULL,
      1,
      1.705513,
      3,
      2.605154,
      2,
      5.848980,
      3.529394,
      2,
      NULL,
      NULL,
      0,
      3.880990,
      29,
      NULL,
      9,
      NULL,
      NULL,
      1.466845,
      3,
      '03114',
      '',
      NULL,
      NULL,
      '',
      NULL,
      '',
      1.664037,
      NULL,
      '',
      '',
      1,
      28,
      11.888336,
      13.671479,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.385811,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.715834,
      0,
      0.139279,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.014078,
      NULL,
      NULL,
      1.387880,
      NULL,
      NULL,
      1.377659,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.156954,
      0.918644,
      0,
      0,
      NULL,
      NULL,
      1.953357,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.928183,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.780072,
      1.139154,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      0,
      0,
      1,
      NULL,
      NULL,
      4,
      1.736390,
      NULL,
      3.743251,
      NULL,
      1.353018,
      NULL,
      NULL,
      NULL,
      3,
      2.317685,
      3,
      1,
      NULL,
      NULL,
      1.305664,
      NULL,
      NULL,
      1.485692,
      NULL,
      NULL,
      1.850002,
      NULL,
      NULL,
      0.162175,
      NULL,
      NULL,
      1.592954,
      NULL,
      NULL,
      NULL,
      0,
      3.082917,
      0,
      NULL,
      NULL,
      0.133780,
      NULL,
      5.885574,
      2,
      0,
      0,
      5,
      1,
      1.423255,
      NULL,
      NULL,
      NULL,
      NULL,
      2.452037,
      2.678816,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3.502432,
      NULL,
      0,
      1.084430,
      0.429855,
      0,
      2.603527,
      0,
      1,
      NULL,
      NULL,
      1.318471,
      5,
      1.547497,
      2.930803,
      NULL,
      NULL,
      4,
      2,
      NULL,
      3,
      NULL,
      1.962724,
      0.391123,
      0,
      0.994090,
      1.876264,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.374531,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.101873,
      NULL,
      NULL,
      2.492709,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.923792,
      0.811319,
      0.432729,
      1,
      1.522935,
      0,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.412861,
      NULL,
      NULL,
      NULL,
      1.631882,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.942736,
      NULL,
      NULL,
      NULL,
      0.696241,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.931108,
      2.664540,
      NULL,
      1.347209,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.755298,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.139170,
      115.131794,
      NULL,
      0.511770,
      0.571243,
      1.858642,
      1,
      NULL,
      0.067907,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1.840865,
      1.304213,
      1,
      0.961662,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3,
      3.010730,
      1,
      1,
      1.535375,
      2,
      3,
      2,
      2.127615,
      0,
      NULL,
      1.143304,
      NULL,
      0.527745,
      0,
      NULL,
      0,
      0.444705,
      NULL,
      NULL,
      1.153489,
      NULL,
      0.974902,
      1,
      NULL,
      0.208218,
      3,
      NULL,
      1.211953,
      3,
      NULL,
      NULL,
      0.179472,
      NULL,
      0,
      1.706671,
      NULL,
      0.114818,
      3,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      1.192897,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.614679,
      NULL,
      1.262009,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      37.883823,
      76.157291,
      NULL,
      NULL,
      0,
      NULL,
      '',
      '',
      0.812148,
      '',
      '',
      '',
      1.742274,
      '',
      NULL,
      NULL);
commit;
end;
/


