set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9628992';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-2-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      4.331384,
      2,
      2,
      2.819448,
      0,
      2,
      2.370656,
      1.961336,
      '041',
      '11324324',
      5.587811,
      NULL,
      '3242240',
      3.435451,
      0.218755,
      5,
      NULL,
      '4302',
      5,
      0.084635,
      NULL,
      NULL,
      NULL,
      NULL,
      93,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      ' 8-23-1996',
      ' 4-19-1995',
      ' 1-27-1983',
      NULL,
      3,
      0.596512,
      NULL,
      0.111539,
      0.142301,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      NULL,
      1.383547,
      0,
      1,
      0,
      0,
      0.426394,
      0,
      0,
      NULL,
      0,
      0.801023,
      NULL,
      0,
      4,
      1,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      2,
      1,
      0,
      1,
      2,
      0,
      2,
      0.450266,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2.030140,
      1,
      NULL,
      1,
      2.116344,
      0,
      0,
      0,
      3,
      NULL,
      0.597878,
      1.937689,
      3,
      2.241542,
      1,
      NULL,
      NULL,
      3,
      0,
      3,
      2.879584,
      1,
      NULL,
      3.471721,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      NULL,
      3,
      0,
      0,
      1,
      3,
      0,
      3,
      1,
      7.284488,
      0,
      0,
      1,
      1,
      0,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      1,
      5,
      3,
      NULL,
      0,
      3,
      4,
      0,
      0,
      2,
      1,
      1,
      NULL,
      3,
      3,
      0,
      3,
      2,
      NULL,
      0,
      3,
      3,
      0,
      ' 5-21-1982',
      999,
      NULL,
      655.939523,
      3,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      2,
      0,
      5,
      1,
      1.641648,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.748514,
      1.204218,
      7,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      0,
      1,
      2.254568,
      NULL,
      1.250637,
      1.085718,
      NULL,
      NULL,
      NULL,
      3,
      1,
      3.979790,
      3,
      2,
      0,
      2,
      3,
      2,
      1,
      0,
      1,
      3,
      3,
      3.832907,
      0,
      1,
      0.281182,
      3.652209,
      0,
      1.684904,
      0.849356,
      1,
      0.704367,
      1.583055,
      1.936671,
      1,
      1,
      0,
      NULL,
      2.474014,
      0.405311,
      11.060460,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.778338,
      6.582428,
      1,
      NULL,
      0.779349,
      39.009426,
      0,
      NULL,
      3,
      NULL,
      35,
      65.573884,
      3,
      NULL,
      2.706100,
      '33112',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      3.335017,
      NULL,
      '',
      '',
      1,
      9,
      159.931831,
      4.388101,
      NULL,
      6,
      NULL,
      0,
      3,
      2.451224,
      0,
      0,
      0,
      NULL,
      NULL,
      0.491143,
      NULL,
      NULL,
      NULL,
      1,
      2,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.783460,
      3,
      0,
      0.094529,
      NULL,
      3.559040,
      1,
      NULL,
      NULL,
      0,
      2.547769,
      2,
      NULL,
      2.481196,
      0,
      NULL,
      NULL,
      2.615921,
      1,
      4,
      0,
      0.909624,
      NULL,
      NULL,
      NULL,
      1.427416,
      NULL,
      NULL,
      NULL,
      1.665712,
      0.281488,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0,
      3.160700,
      1.104249,
      1,
      0.475384,
      0.053238,
      1,
      0.779885,
      1.062436,
      1.545130,
      3,
      0,
      3.843608,
      NULL,
      0,
      1.731171,
      0,
      1.534126,
      NULL,
      NULL,
      0.373980,
      1,
      1.958156,
      6.976327,
      0.020162,
      6.308728,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.719223,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.127278,
      1.613889,
      3,
      NULL,
      3.306963,
      0.121023,
      1,
      3.555210,
      4,
      0.104326,
      NULL,
      1.582770,
      NULL,
      NULL,
      1.412305,
      NULL,
      NULL,
      0.859204,
      NULL,
      NULL,
      1.268082,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.917204,
      1,
      NULL,
      1.746108,
      0,
      2.882588,
      NULL,
      2.930669,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      4,
      NULL,
      4.215759,
      0,
      0.061427,
      0,
      NULL,
      1.576625,
      1.361931,
      0.486210,
      NULL,
      3.229536,
      0,
      1.345995,
      1.401431,
      6.158518,
      0.363564,
      5,
      3.548154,
      NULL,
      0.645644,
      3,
      0,
      0,
      0,
      1.413718,
      0,
      0.554652,
      NULL,
      2.663966,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.666247,
      NULL,
      NULL,
      0.029307,
      NULL,
      NULL,
      1.691086,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.309369,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.288461,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      0.141262,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.605373,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.886434,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.917546,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.450143,
      NULL,
      NULL,
      NULL,
      0.978635,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      0.716755,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.023529,
      NULL,
      NULL,
      1.852769,
      NULL,
      1,
      143,
      0,
      1.428104,
      0,
      0,
      0.114550,
      0,
      0,
      0,
      1.145892,
      NULL,
      1.169857,
      1,
      1,
      NULL,
      1.374613,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      1,
      3,
      2.036610,
      NULL,
      0.103757,
      2,
      2.202319,
      0,
      2,
      0,
      1.219071,
      1.379890,
      NULL,
      1,
      2,
      NULL,
      2,
      NULL,
      NULL,
      1.558694,
      NULL,
      NULL,
      3,
      2,
      NULL,
      0,
      0.382676,
      NULL,
      1,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      2.597958,
      NULL,
      0,
      3.358696,
      NULL,
      0.554739,
      0,
      NULL,
      0.982129,
      1.629922,
      0.277755,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.761473,
      NULL,
      1.864774,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0.277069,
      1.727272,
      0,
      NULL,
      36.597829,
      NULL,
      0,
      1,
      '32322',
      NULL,
      '',
      1.838421,
      NULL,
      '',
      '',
      0.794233,
      '2304',
      '',
      '');
commit;
end;
/


