set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '5309016';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-10-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '1',
      NULL,
      NULL,
      '0112042',
      0,
      0.744868,
      2,
      0,
      '2400',
      1,
      0,
      NULL,
      NULL,
      ' 9-20-1977',
      3,
      NULL,
      0,
      0.620819,
      0,
      ' 3-11-1987',
      NULL,
      3.490190,
      331,
      93.461398,
      3,
      NULL,
      ' 1- 7-1984',
      ' 5-25-1999',
      3.424715,
      0.369867,
      NULL,
      1,
      0.262998,
      1,
      3,
      0.930188,
      0.745743,
      NULL,
      2,
      16.112918,
      6,
      24,
      4,
      3,
      NULL,
      5,
      1,
      5,
      1,
      3,
      NULL,
      1.571080,
      1.788649,
      1,
      0,
      1,
      1,
      NULL,
      0.701005,
      1,
      2,
      NULL,
      0,
      5,
      1,
      1,
      4,
      1,
      0,
      2,
      1,
      0,
      1,
      NULL,
      0,
      NULL,
      1,
      2,
      2,
      0,
      2,
      2,
      0,
      1.192963,
      NULL,
      NULL,
      5,
      0,
      3,
      0,
      0,
      1.380397,
      2.599855,
      0.809531,
      2.349859,
      0.486173,
      3.516390,
      2,
      0.687406,
      2,
      2,
      NULL,
      2,
      0,
      0.412724,
      NULL,
      2,
      1,
      1.116927,
      0,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      5,
      4,
      4,
      4,
      1,
      NULL,
      NULL,
      3,
      4,
      0,
      1,
      1,
      3,
      7,
      0,
      NULL,
      NULL,
      NULL,
      1.101764,
      NULL,
      3.248807,
      NULL,
      1,
      4,
      NULL,
      0,
      5,
      0,
      1,
      0,
      1,
      1,
      1,
      1,
      4,
      5,
      1,
      1,
      1,
      NULL,
      3,
      NULL,
      5,
      4,
      2,
      0,
      1.499670,
      3.809041,
      ' 7-14-1977',
      601.674780,
      NULL,
      1234,
      3.300655,
      1,
      1,
      NULL,
      0,
      NULL,
      3,
      NULL,
      0,
      NULL,
      2,
      NULL,
      NULL,
      0,
      3,
      2,
      0,
      6,
      2.259307,
      2,
      3.479495,
      '11-23-1978',
      NULL,
      NULL,
      8.270187,
      2.058952,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.518682,
      0,
      0.105513,
      NULL,
      0,
      0.498420,
      0,
      1.311074,
      NULL,
      1.242911,
      NULL,
      NULL,
      NULL,
      1.698305,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.709048,
      1,
      0,
      NULL,
      NULL,
      2.430991,
      1,
      3,
      143.974404,
      1.622060,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.353046,
      NULL,
      1,
      NULL,
      NULL,
      2,
      2,
      2,
      1,
      0,
      3,
      2,
      3.538564,
      3.009460,
      3.947941,
      0.022143,
      0,
      0,
      6.447003,
      1,
      NULL,
      1,
      1,
      0,
      0.891833,
      0.384360,
      NULL,
      NULL,
      1.142544,
      1.265167,
      0,
      2,
      4.524478,
      0.647321,
      4,
      NULL,
      6.232560,
      NULL,
      NULL,
      3.362396,
      1,
      3.715226,
      0.697142,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      9,
      24,
      0,
      NULL,
      3.754770,
      '03431',
      '',
      '',
      1,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      0.681506,
      5.157132,
      33.467108,
      16.710781,
      2,
      5.760925,
      NULL,
      11,
      2,
      2.198226,
      3.673296,
      3.374786,
      1,
      NULL,
      NULL,
      0.814090,
      1,
      1,
      2,
      1.178403,
      3,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.791742,
      NULL,
      2,
      0.765328,
      NULL,
      NULL,
      0.423278,
      NULL,
      NULL,
      1.502433,
      NULL,
      NULL,
      0.831277,
      NULL,
      NULL,
      1.635222,
      NULL,
      NULL,
      3.601612,
      NULL,
      7,
      0,
      1.937761,
      1.715110,
      0,
      NULL,
      1.237118,
      NULL,
      NULL,
      NULL,
      2.403614,
      1.650956,
      2.981905,
      0.904208,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      0.617807,
      3,
      1,
      3.459943,
      3.392203,
      0,
      1,
      0.257309,
      0,
      NULL,
      3,
      2,
      3,
      NULL,
      1,
      0.688033,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.847671,
      6,
      1,
      1,
      3,
      NULL,
      2.243031,
      1,
      NULL,
      NULL,
      NULL,
      1.427714,
      0.487098,
      0.546717,
      3.936132,
      NULL,
      2,
      2.412483,
      2.941980,
      1,
      0,
      NULL,
      NULL,
      0.114445,
      5,
      5,
      3.872617,
      1,
      2,
      0,
      0.672689,
      1,
      1,
      2.126144,
      1.348411,
      1.090556,
      NULL,
      NULL,
      1.134503,
      NULL,
      NULL,
      0.591006,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.926009,
      NULL,
      NULL,
      3.312389,
      2.566189,
      1,
      0.601485,
      NULL,
      NULL,
      4.633797,
      1,
      NULL,
      5,
      3,
      4,
      0.059709,
      2,
      0.525270,
      1,
      NULL,
      2,
      0.514094,
      NULL,
      2.541325,
      1.441266,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.700270,
      2,
      0,
      2,
      2,
      NULL,
      2.737746,
      3,
      NULL,
      0.097284,
      NULL,
      1.712671,
      0.400691,
      5.575388,
      3,
      NULL,
      NULL,
      0.715202,
      3,
      0,
      0,
      2.283260,
      0.203904,
      NULL,
      1,
      2.213314,
      8.329679,
      NULL,
      NULL,
      288,
      NULL,
      52.073786,
      1,
      NULL,
      1,
      1,
      NULL,
      1.816399,
      1.555746,
      NULL,
      0.309048,
      0.253817,
      NULL,
      2.692432,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.365914,
      3.648536,
      NULL,
      NULL,
      3.911112,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.453657,
      7.893823,
      NULL,
      8.858265,
      NULL,
      NULL,
      NULL,
      1.104727,
      0,
      0.380241,
      0.096555,
      NULL,
      1.085611,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.237049,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.648909,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.960816,
      NULL,
      NULL,
      NULL,
      2.008234,
      NULL,
      NULL,
      NULL,
      0.020598,
      NULL,
      NULL,
      NULL,
      0.646176,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.571634,
      NULL,
      NULL,
      NULL,
      1.776509,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.826120,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      8.344344,
      NULL,
      NULL,
      NULL,
      1.371133,
      NULL,
      NULL,
      NULL,
      1,
      191,
      249,
      0.381010,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      72,
      0,
      0.237844,
      1.397706,
      2,
      2,
      50.284600,
      NULL,
      1.854712,
      NULL,
      0,
      18,
      1.099110,
      1.335326,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.973295,
      NULL,
      NULL,
      1,
      0,
      1,
      1.401240,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      2,
      NULL,
      2,
      2,
      1,
      NULL,
      1,
      0.943667,
      0,
      NULL,
      NULL,
      1.254337,
      3.686757,
      0,
      1,
      3.428695,
      0.450400,
      0,
      1,
      0.057339,
      NULL,
      0,
      0.622044,
      0,
      0,
      0.687667,
      1,
      0.431375,
      1.302250,
      NULL,
      1,
      0.808784,
      NULL,
      3,
      NULL,
      1,
      0,
      1,
      NULL,
      1,
      3.499964,
      NULL,
      2,
      1.165160,
      2,
      NULL,
      1,
      NULL,
      0.309619,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      3,
      NULL,
      1,
      NULL,
      0.102777,
      NULL,
      0.506225,
      NULL,
      NULL,
      NULL,
      0,
      37.230586,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.046224,
      0.530036,
      1,
      0,
      0.659753,
      0,
      3,
      2,
      NULL,
      0.232699,
      NULL,
      1,
      40.167740,
      36.718242,
      NULL,
      0.558998,
      6,
      '23414',
      '33310',
      NULL,
      1,
      '',
      '',
      '',
      0.261224,
      NULL,
      '',
      '');
commit;
end;
/


