set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '5309016';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-5-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '3', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '21',
      '13',
      10,
      21.643890,
      '3134412',
      2,
      1,
      1,
      2,
      '1314',
      1,
      1.872982,
      NULL,
      NULL,
      '10- 3-1999',
      5,
      1.086990,
      NULL,
      NULL,
      NULL,
      ' 9- 9-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      ' 5- 1-1988',
      3,
      0,
      NULL,
      0.058654,
      1,
      0.992481,
      4,
      NULL,
      0.839038,
      833,
      6,
      5,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      4,
      3,
      0,
      0,
      NULL,
      1,
      NULL,
      1,
      0,
      3,
      0,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      3.958236,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      1,
      1,
      1,
      NULL,
      1,
      NULL,
      0.826269,
      1,
      1,
      0,
      0,
      4,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      1,
      2,
      1,
      NULL,
      NULL,
      1,
      3,
      0,
      1,
      3,
      3,
      5,
      4,
      0,
      3,
      2,
      2,
      2,
      0,
      5,
      4,
      1.772151,
      ' 6-12-1982',
      995.347079,
      NULL,
      1036,
      3.451145,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2,
      1,
      1,
      0,
      3.326306,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.793367,
      0,
      0.715941,
      1,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.388815,
      NULL,
      1,
      0,
      0,
      1.387366,
      1,
      NULL,
      NULL,
      NULL,
      1.017489,
      0.211317,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.523210,
      NULL,
      1.605465,
      NULL,
      1.295845,
      0.288950,
      1,
      NULL,
      3,
      0.226865,
      24,
      NULL,
      178.018436,
      1,
      0,
      3,
      0,
      2,
      1,
      NULL,
      NULL,
      2,
      1,
      1,
      1,
      3,
      1,
      0,
      NULL,
      2.298820,
      0.974171,
      NULL,
      3,
      1.632314,
      0.505315,
      0,
      1,
      NULL,
      1.302001,
      0,
      1.205468,
      2,
      0.551840,
      NULL,
      0,
      NULL,
      9.149236,
      2,
      0,
      8.403717,
      NULL,
      NULL,
      NULL,
      0,
      2.848851,
      3.393274,
      2,
      NULL,
      NULL,
      0.785671,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      0.198816,
      '42233',
      '',
      '',
      0.688900,
      '',
      '',
      '',
      1,
      NULL,
      '',
      '',
      2.301508,
      14.339043,
      284.950161,
      16.690174,
      0,
      NULL,
      24.228554,
      6.206819,
      4,
      1.745488,
      3.662191,
      3.843036,
      0.875569,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.275514,
      0,
      1.753182,
      1.575555,
      3.575238,
      NULL,
      NULL,
      0.539835,
      0.901408,
      1,
      NULL,
      NULL,
      NULL,
      0.500226,
      1,
      0.258235,
      NULL,
      NULL,
      0.261222,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.930524,
      NULL,
      NULL,
      5,
      6,
      4,
      0,
      2,
      NULL,
      0,
      1,
      1.453883,
      NULL,
      NULL,
      NULL,
      NULL,
      1.509605,
      0,
      0.425951,
      NULL,
      NULL,
      0.063948,
      NULL,
      NULL,
      3,
      1.649252,
      0.620804,
      2,
      NULL,
      1,
      NULL,
      NULL,
      2.444892,
      1,
      0,
      NULL,
      2,
      3.574174,
      0.607362,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.325941,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      3.503872,
      1,
      0.967200,
      2.044729,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.257185,
      0,
      3,
      0.371076,
      NULL,
      1.172077,
      0.735609,
      1.476453,
      1.687584,
      NULL,
      NULL,
      7,
      NULL,
      1.674361,
      1.295243,
      NULL,
      NULL,
      2,
      0.975414,
      0.742126,
      8,
      2.632586,
      1.968798,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.792610,
      NULL,
      NULL,
      0.736377,
      NULL,
      NULL,
      1,
      1,
      0,
      7,
      1,
      NULL,
      0.282476,
      1.172136,
      0,
      0.600946,
      NULL,
      NULL,
      6,
      2.005658,
      2,
      NULL,
      NULL,
      1.343459,
      4,
      2,
      NULL,
      3.168042,
      0.255216,
      0,
      1,
      0.551307,
      0.706769,
      0.526430,
      NULL,
      NULL,
      0,
      0.937312,
      NULL,
      NULL,
      3.068298,
      NULL,
      0.425049,
      1.975876,
      3,
      NULL,
      2.236447,
      NULL,
      2.389268,
      2.753039,
      3.230094,
      9.221173,
      1.959505,
      1,
      2,
      NULL,
      NULL,
      3.357076,
      1,
      0,
      1.647330,
      2,
      3,
      1.917181,
      NULL,
      1.247737,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.127043,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.028888,
      NULL,
      NULL,
      1.046609,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.842434,
      1,
      NULL,
      1.668541,
      3.769729,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.284242,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.938546,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.474012,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.736851,
      1.708383,
      3,
      2,
      1,
      292.347976,
      NULL,
      0.489807,
      NULL,
      NULL,
      1.577789,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      2.466365,
      0.558760,
      87,
      2,
      2.799796,
      NULL,
      NULL,
      NULL,
      0.548352,
      1,
      1,
      1.273445,
      1,
      0.785497,
      0,
      1.375794,
      1,
      1,
      0.257440,
      1.222458,
      NULL,
      1,
      1.219278,
      0.270373,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0.000208,
      0.118223,
      3,
      NULL,
      3,
      1,
      1,
      3.536764,
      1,
      0.214534,
      1,
      0.532035,
      0,
      1.194808,
      2.307036,
      0.105623,
      0.322719,
      3.336872,
      0.070314,
      0.707873,
      2.582479,
      0.902834,
      1.493997,
      0.389031,
      1,
      1.543719,
      1,
      NULL,
      0.971518,
      NULL,
      NULL,
      0.081313,
      0.824671,
      1.142388,
      0.249367,
      1,
      0,
      1.262325,
      3.883656,
      1,
      0.017468,
      2,
      2.331647,
      2.227347,
      2,
      0.962172,
      NULL,
      0.217653,
      2,
      0,
      3.659019,
      1,
      3,
      0.510381,
      1.147441,
      0,
      0,
      0.130761,
      2,
      0,
      0.703150,
      0.500096,
      1,
      0,
      3,
      NULL,
      1,
      0,
      0.201833,
      1.401968,
      0.535068,
      23.368381,
      1.668266,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.694550,
      NULL,
      0,
      NULL,
      5,
      3.853560,
      1,
      1.653964,
      57.691217,
      13,
      NULL,
      5.134939,
      NULL,
      '44001',
      '',
      '',
      1,
      NULL,
      '',
      '',
      0.129373,
      '',
      '',
      '');
commit;
end;
/


