set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7635068';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-10-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '0',
      NULL,
      NULL,
      NULL,
      1.685490,
      1,
      2,
      3,
      NULL,
      2.659144,
      0.413497,
      NULL,
      NULL,
      NULL,
      6.077104,
      NULL,
      NULL,
      0,
      0.500313,
      ' 8- 0-1987',
      NULL,
      3.589000,
      219,
      16.179518,
      1,
      '11-11-1982',
      ' 3-26-1989',
      ' 4- 7-1993',
      3,
      NULL,
      0.791999,
      1.026836,
      0.813945,
      0.139411,
      1,
      0,
      0,
      NULL,
      4,
      12.510047,
      17,
      NULL,
      NULL,
      3,
      2,
      5,
      1,
      0,
      0,
      1,
      NULL,
      1.070729,
      1,
      0,
      1.198610,
      NULL,
      1.167449,
      0,
      NULL,
      5,
      NULL,
      3,
      NULL,
      5,
      1,
      0,
      NULL,
      4,
      2,
      5,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.622141,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1.715608,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      4,
      0,
      3,
      0,
      0,
      0,
      0,
      NULL,
      1,
      1,
      1,
      0,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      NULL,
      5,
      3,
      5,
      0,
      1,
      NULL,
      1,
      1,
      3,
      3,
      0,
      0,
      1,
      3,
      0,
      2,
      NULL,
      2,
      2.555863,
      NULL,
      727.876098,
      '11- 4-1981',
      NULL,
      0.335162,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      1,
      0,
      1,
      0.026839,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.471397,
      0.521011,
      3,
      1.495999,
      0.729856,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.882454,
      1.898469,
      3,
      1.641010,
      0,
      0.305077,
      0,
      NULL,
      1,
      NULL,
      126,
      1075,
      853.426320,
      2,
      1,
      1.342829,
      NULL,
      1,
      1,
      NULL,
      3,
      1,
      3,
      3,
      1,
      NULL,
      1.209810,
      6.489416,
      1.337560,
      0.406665,
      NULL,
      NULL,
      96.317565,
      197,
      107,
      NULL,
      1.853780,
      1.191832,
      1,
      1,
      NULL,
      1,
      NULL,
      14.561756,
      0,
      4.652185,
      1,
      3.318630,
      NULL,
      7.462544,
      4.075448,
      5,
      NULL,
      7,
      3,
      1,
      NULL,
      3.498694,
      1,
      3.806445,
      NULL,
      29,
      25,
      42,
      5,
      1.902201,
      3.357093,
      '41044',
      '',
      '',
      NULL,
      '10140',
      '',
      '',
      0.159045,
      NULL,
      '',
      NULL,
      1,
      34.905680,
      1019.095747,
      15.086586,
      1.905821,
      34,
      2.389987,
      8,
      NULL,
      1.981768,
      2,
      2,
      1,
      NULL,
      NULL,
      3,
      NULL,
      0.054098,
      1,
      NULL,
      NULL,
      NULL,
      1.781859,
      0.810871,
      0,
      NULL,
      NULL,
      2.684727,
      2,
      NULL,
      0,
      NULL,
      NULL,
      1.035578,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.892936,
      NULL,
      NULL,
      2,
      6,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.243425,
      NULL,
      NULL,
      0.056156,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.877282,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.093055,
      0,
      0.191580,
      0.892233,
      NULL,
      NULL,
      1.393938,
      NULL,
      0.314685,
      NULL,
      1,
      NULL,
      0.050371,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.691452,
      2,
      NULL,
      1.801129,
      5,
      3.491654,
      NULL,
      2.058143,
      NULL,
      NULL,
      0.106422,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.037102,
      NULL,
      NULL,
      2.601397,
      1.942567,
      NULL,
      NULL,
      0,
      1.815166,
      3,
      0.062559,
      NULL,
      2,
      0,
      1,
      4.417411,
      NULL,
      0.250370,
      1.339700,
      3,
      NULL,
      0,
      NULL,
      NULL,
      1.230608,
      1.231968,
      1,
      NULL,
      0.092329,
      0.095443,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.711055,
      NULL,
      NULL,
      1.306382,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.114560,
      NULL,
      NULL,
      0.237288,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.213619,
      NULL,
      NULL,
      0.202777,
      NULL,
      NULL,
      0.409636,
      1.022158,
      NULL,
      0,
      0,
      3.035676,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.389127,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.110344,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      529,
      95.046662,
      0.956409,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      95.031963,
      1965,
      0,
      NULL,
      NULL,
      1.263863,
      NULL,
      NULL,
      0.963097,
      NULL,
      1.587837,
      100.082457,
      0.702565,
      1.940519,
      1,
      0,
      0.017273,
      NULL,
      1,
      1,
      1,
      0,
      0,
      1,
      0,
      NULL,
      1,
      1,
      0,
      1.673294,
      1.024012,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      4.320669,
      2,
      6.363274,
      1.741839,
      NULL,
      14.049109,
      3,
      3,
      0.990119,
      NULL,
      1,
      NULL,
      1.076839,
      NULL,
      NULL,
      NULL,
      1.203449,
      NULL,
      0.518981,
      0,
      NULL,
      0,
      0,
      NULL,
      1.734519,
      NULL,
      NULL,
      1,
      2.667718,
      NULL,
      NULL,
      0,
      NULL,
      1.663007,
      0.011153,
      NULL,
      0,
      NULL,
      NULL,
      1.639136,
      0.586233,
      NULL,
      2.781458,
      0.213733,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.305179,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.572397,
      NULL,
      0,
      NULL,
      1.923830,
      NULL,
      4,
      3,
      1,
      1.681847,
      1.725392,
      1,
      NULL,
      89,
      NULL,
      1,
      3.483147,
      NULL,
      NULL,
      '',
      3.306606,
      '22123',
      '',
      '',
      0.122167,
      '',
      '',
      '');
commit;
end;
/


