set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9766478';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-11-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      0,
      0.729125,
      3.519437,
      2.398336,
      NULL,
      1.610452,
      2.789265,
      1,
      '324',
      '30432313',
      32,
      70.645487,
      NULL,
      2.015667,
      1,
      5,
      2,
      '0204',
      3,
      NULL,
      NULL,
      NULL,
      ' 4- 8-1977',
      129.529126,
      107,
      NULL,
      3,
      1,
      ' 0-19-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      '10-17-1999',
      '10-10-1996',
      ' 5- 0-1986',
      2.079324,
      3.585734,
      NULL,
      0,
      0,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      13,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      NULL,
      0.997067,
      1,
      NULL,
      1.164456,
      1.082482,
      1.104201,
      1.510016,
      NULL,
      0.633570,
      1.478577,
      1.436322,
      0,
      3,
      0,
      0,
      5,
      1,
      NULL,
      0,
      0,
      NULL,
      5,
      1,
      0,
      0,
      NULL,
      2,
      0,
      0,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0.710420,
      NULL,
      NULL,
      2,
      0,
      0,
      1,
      0.987709,
      NULL,
      3.023159,
      0.831063,
      1,
      0,
      0,
      1.751847,
      0,
      2,
      0.113350,
      0.632275,
      0,
      3.787488,
      2,
      1,
      NULL,
      0,
      6,
      NULL,
      2,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      3,
      1,
      0,
      5,
      5,
      5,
      1,
      1,
      0,
      1,
      NULL,
      0,
      2.116106,
      NULL,
      1,
      NULL,
      0,
      0,
      NULL,
      0.019124,
      2,
      0,
      0,
      0,
      NULL,
      NULL,
      3,
      4,
      4,
      3,
      1,
      NULL,
      4,
      0,
      1,
      1,
      NULL,
      NULL,
      3,
      5,
      4,
      0,
      3,
      NULL,
      0,
      NULL,
      0,
      NULL,
      148.361796,
      ' 7- 6-1981',
      9,
      1.685929,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2,
      2.211346,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      3.279930,
      0,
      0.418087,
      2.709561,
      6.556622,
      2.443073,
      0.404417,
      3.642737,
      2,
      0,
      NULL,
      NULL,
      NULL,
      3,
      1.515751,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.509818,
      0.191462,
      1.931037,
      1,
      1.860593,
      0.041423,
      0.098739,
      NULL,
      1,
      3.877821,
      0.345882,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1.125041,
      2,
      2,
      1,
      1,
      2,
      3,
      3,
      2,
      1,
      3,
      3.178079,
      5,
      3,
      0.382736,
      NULL,
      0,
      0.521654,
      NULL,
      1,
      0.888146,
      1.549574,
      NULL,
      0,
      1,
      NULL,
      1,
      2,
      1.620021,
      0.055394,
      5.197806,
      4,
      4,
      9.629648,
      7,
      2.519158,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0.137544,
      4.958433,
      1,
      NULL,
      65,
      NULL,
      50,
      35,
      4,
      1,
      1,
      '21024',
      '',
      '',
      0.840740,
      '',
      '',
      '',
      0,
      '',
      '',
      NULL,
      0.810845,
      10,
      30.888339,
      NULL,
      2,
      30.655891,
      NULL,
      0,
      4,
      1.447991,
      0.752514,
      0,
      1.574455,
      NULL,
      NULL,
      1.942234,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      1.176736,
      0,
      NULL,
      NULL,
      1.833290,
      1,
      3,
      3.311715,
      0,
      NULL,
      3.261115,
      3,
      0,
      1.815796,
      NULL,
      NULL,
      0.925625,
      3,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.630279,
      2.487010,
      3.898037,
      0,
      NULL,
      NULL,
      1.127549,
      NULL,
      NULL,
      2,
      0.851576,
      1,
      NULL,
      0.619357,
      1,
      1.489441,
      1.836627,
      NULL,
      0.179201,
      0,
      1.075604,
      NULL,
      0,
      2.990116,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5,
      5,
      4.390706,
      1,
      0.779004,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.194979,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      6.145620,
      NULL,
      NULL,
      1.702973,
      3.692232,
      0,
      NULL,
      NULL,
      NULL,
      2.879406,
      4,
      0.107350,
      0.659386,
      NULL,
      NULL,
      1.225791,
      NULL,
      NULL,
      1.901944,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.151227,
      NULL,
      3.528873,
      0.757216,
      NULL,
      NULL,
      NULL,
      5,
      3,
      2.556338,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.966099,
      2.280432,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      3.633526,
      2.573399,
      2,
      3.885880,
      2.679859,
      NULL,
      NULL,
      2,
      3,
      2.816615,
      0,
      3.414363,
      8,
      6,
      1.982222,
      2,
      4.407592,
      NULL,
      1,
      NULL,
      0,
      0.228912,
      1,
      NULL,
      1,
      0.546972,
      0.729224,
      NULL,
      NULL,
      0.095319,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.088190,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.016226,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.315587,
      0.521550,
      1.765138,
      2,
      0.095362,
      NULL,
      NULL,
      0.889031,
      NULL,
      NULL,
      NULL,
      88.623028,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.978953,
      NULL,
      NULL,
      NULL,
      1.093845,
      NULL,
      NULL,
      NULL,
      0.225922,
      NULL,
      NULL,
      NULL,
      1.566114,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.564794,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.925096,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.595286,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.514661,
      0.476062,
      0.822080,
      NULL,
      4,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1,
      77,
      0.251420,
      0.938890,
      0,
      1.389799,
      1,
      1,
      1.982967,
      0.087948,
      1,
      0.336089,
      0,
      1,
      1.244927,
      0.325541,
      1,
      1.979834,
      0,
      1,
      0.965955,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.010276,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.263884,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.453815,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.618745,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.472568,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.792216,
      2.961113,
      NULL,
      0,
      1.337944,
      1.075694,
      0,
      NULL,
      NULL,
      1,
      0.420031,
      0,
      1.671430,
      0.271606,
      1,
      0,
      1.912125,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      2,
      0,
      1.111485,
      NULL,
      NULL,
      NULL,
      16,
      0,
      1,
      1.489002,
      0,
      3,
      NULL,
      1,
      NULL,
      NULL,
      1,
      3,
      NULL,
      1.092760,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.434676,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.047590,
      NULL,
      0,
      NULL,
      NULL,
      0.089120,
      3.883770,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.473073,
      NULL,
      4,
      6,
      7,
      1,
      0,
      2,
      10.365552,
      33.240651,
      3,
      NULL,
      2,
      '44232',
      '01400',
      '',
      1.216223,
      '',
      NULL,
      '',
      NULL,
      '',
      '',
      NULL);
commit;
end;
/


