set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7711518';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-11-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '0',
      NULL,
      NULL,
      '1023012',
      1.343492,
      1,
      3,
      1,
      '3040',
      3,
      1.579421,
      NULL,
      NULL,
      ' 8- 4-1993',
      33.913562,
      NULL,
      4,
      NULL,
      0.296541,
      ' 2-21-1975',
      78.270762,
      NULL,
      NULL,
      87,
      0,
      NULL,
      NULL,
      NULL,
      2.730205,
      NULL,
      NULL,
      NULL,
      1.941528,
      3.779470,
      NULL,
      NULL,
      0,
      NULL,
      4,
      NULL,
      NULL,
      16.390955,
      12,
      3,
      27,
      NULL,
      0,
      4.578738,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.268515,
      NULL,
      0,
      1,
      0,
      1,
      1,
      1,
      0,
      NULL,
      0,
      1,
      1,
      1.311119,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1.868743,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      3,
      0,
      1,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      3.306473,
      NULL,
      1,
      1,
      1,
      0,
      NULL,
      1.915461,
      1,
      0,
      1,
      NULL,
      0,
      NULL,
      2,
      0,
      NULL,
      1,
      1,
      0,
      3,
      3,
      0,
      5,
      NULL,
      NULL,
      0,
      NULL,
      5,
      0,
      5,
      NULL,
      3,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      1,
      1,
      0,
      0.785903,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      1,
      1,
      1.984111,
      NULL,
      NULL,
      NULL,
      0.931628,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.358525,
      1,
      0,
      1.483610,
      1.911794,
      NULL,
      1.245088,
      0.530342,
      NULL,
      0,
      3,
      111.620583,
      1609.867466,
      1965,
      3,
      1,
      0.071699,
      3,
      1,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      2,
      2.378991,
      1,
      3,
      1.471772,
      0.958208,
      2,
      0.695279,
      1.141221,
      NULL,
      1,
      1.833272,
      NULL,
      1,
      1.816190,
      NULL,
      0.882828,
      NULL,
      0.769534,
      10.266937,
      10.764425,
      5.042604,
      2,
      8,
      NULL,
      NULL,
      NULL,
      7.688714,
      1,
      3,
      NULL,
      NULL,
      3,
      NULL,
      34,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      '33210',
      '',
      NULL,
      1.536141,
      NULL,
      '',
      '',
      3,
      '31000',
      '43112',
      '',
      2,
      NULL,
      459.798075,
      30,
      3.319513,
      NULL,
      3,
      86,
      4,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.896881,
      3.824582,
      2,
      0,
      2.328908,
      3,
      1.603134,
      NULL,
      NULL,
      1.709474,
      NULL,
      NULL,
      0.558527,
      NULL,
      NULL,
      1.738082,
      NULL,
      NULL,
      0.993274,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.726938,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0.661913,
      3,
      0,
      0.133688,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.917257,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.048225,
      1.432274,
      NULL,
      1.068321,
      NULL,
      1,
      3,
      4.751842,
      5.319780,
      0.915572,
      0,
      1.815392,
      NULL,
      NULL,
      NULL,
      5,
      0,
      2.361097,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.907242,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.875042,
      NULL,
      NULL,
      0.147904,
      NULL,
      NULL,
      0.637167,
      3,
      NULL,
      2.462557,
      5.569923,
      3,
      4,
      NULL,
      2.343254,
      6.758938,
      1.603620,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.354121,
      0.452151,
      0,
      2,
      3,
      2,
      1,
      NULL,
      NULL,
      1.021696,
      0.199994,
      NULL,
      2,
      NULL,
      1.328321,
      2,
      NULL,
      0.499344,
      0.247295,
      4.774215,
      4.810129,
      4.207220,
      4,
      5,
      NULL,
      NULL,
      NULL,
      1.994510,
      1.279621,
      1,
      NULL,
      NULL,
      2.496810,
      NULL,
      NULL,
      0.313703,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.829912,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.797796,
      NULL,
      NULL,
      2,
      1.505705,
      2.343992,
      1,
      NULL,
      NULL,
      1.204601,
      1,
      2.621470,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2.801586,
      NULL,
      1.151427,
      3,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.546202,
      NULL,
      0,
      NULL,
      NULL,
      2,
      1.987034,
      NULL,
      NULL,
      1,
      0.167503,
      NULL,
      NULL,
      0.285784,
      1,
      NULL,
      NULL,
      0.071435,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.123284,
      1.897147,
      0.419419,
      NULL,
      1,
      2.296797,
      1,
      NULL,
      0,
      1.758395,
      3,
      NULL,
      1,
      1.062317,
      1.037113,
      NULL,
      0.797485,
      8.393110,
      1.984742,
      NULL,
      0.118464,
      5,
      2,
      3,
      2,
      237.967076,
      NULL,
      NULL,
      214,
      NULL,
      0,
      NULL,
      NULL,
      0.651966,
      74,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.370405,
      NULL,
      1,
      452,
      19.719596,
      0.881628,
      1.313424,
      0.315699,
      0.037662,
      0,
      NULL,
      1,
      0,
      1.965910,
      2,
      NULL,
      NULL,
      0,
      NULL,
      0.162588,
      1,
      0.866813,
      3.277779,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.801845,
      NULL,
      306,
      NULL,
      61,
      37.617452,
      71,
      0,
      2,
      0.010618,
      NULL,
      1.037285,
      NULL,
      2,
      NULL,
      1,
      NULL,
      0.236143,
      NULL,
      0,
      NULL,
      2,
      NULL,
      2.381029,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.260688,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.687844,
      1.458125,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      3.274025,
      2,
      3,
      NULL,
      9.479862,
      NULL,
      2,
      NULL,
      1,
      0.497362,
      1,
      NULL,
      0,
      0.006118,
      0,
      0.729118,
      0,
      NULL,
      0,
      0,
      1,
      0.427597,
      0,
      0.935298,
      NULL,
      2,
      0,
      1,
      1,
      0.631560,
      0,
      NULL,
      NULL,
      0,
      1.215634,
      1.969750,
      3.873178,
      NULL,
      1,
      0.815261,
      1,
      0,
      0.799408,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.514339,
      3.306436,
      NULL,
      0.766020,
      NULL,
      0,
      NULL,
      1.145306,
      NULL,
      2,
      NULL,
      0,
      NULL,
      0.365947,
      NULL,
      1.876723,
      NULL,
      1,
      NULL,
      1.430057,
      NULL,
      1,
      NULL,
      0.818113,
      NULL,
      1.793161,
      14,
      0.554987,
      NULL,
      0.835653,
      NULL,
      NULL,
      2,
      0,
      0,
      4,
      4,
      4,
      1.518033,
      NULL,
      NULL,
      104,
      134.616100,
      NULL,
      NULL,
      2.785624,
      NULL,
      NULL,
      NULL,
      1.599183,
      '',
      NULL,
      '',
      NULL,
      '33012',
      '41413',
      NULL);
commit;
end;
/


