set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9001593';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-1-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      NULL,
      NULL,
      NULL,
      '1044413',
      0.334155,
      NULL,
      2,
      3,
      '0113',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-15-1995',
      18.072205,
      NULL,
      2,
      NULL,
      0.028580,
      ' 2-29-1986',
      NULL,
      1,
      194,
      81.717242,
      0,
      ' 8-14-1997',
      '10-17-1994',
      ' 7-23-1996',
      3.117202,
      0.618102,
      0,
      2.778298,
      0.956047,
      0,
      3,
      1.899552,
      1,
      NULL,
      6,
      6,
      4,
      11,
      15,
      0,
      23.473098,
      3,
      NULL,
      7.012822,
      1,
      1,
      1,
      0,
      0.501111,
      0.066358,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4,
      1,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      2,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.301300,
      NULL,
      NULL,
      NULL,
      5,
      2,
      2,
      1,
      0.590914,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.356152,
      0.106105,
      0,
      2,
      1.397564,
      1.893823,
      1,
      NULL,
      NULL,
      0,
      NULL,
      2.952056,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      1,
      1,
      1,
      0.574396,
      0,
      1,
      0,
      1,
      0.887548,
      NULL,
      0.531926,
      NULL,
      1,
      NULL,
      1,
      1,
      3,
      5,
      NULL,
      NULL,
      0,
      1,
      3,
      3,
      1,
      NULL,
      4,
      0,
      1,
      1,
      1,
      1,
      4,
      0,
      1,
      0,
      NULL,
      3.737690,
      ' 0-10-1977',
      NULL,
      NULL,
      46.694440,
      3.487097,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      0,
      0,
      1,
      0.633928,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0.516839,
      1,
      1.606158,
      2,
      NULL,
      NULL,
      1.382632,
      2,
      1,
      NULL,
      0.791474,
      NULL,
      1.394894,
      0,
      2,
      1.627856,
      2.488971,
      0.550426,
      NULL,
      NULL,
      NULL,
      1.455356,
      3.819852,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.725598,
      NULL,
      0,
      NULL,
      0,
      0.554800,
      3,
      93,
      1,
      1,
      NULL,
      NULL,
      NULL,
      3,
      0.190924,
      0.405751,
      2,
      1,
      0,
      2,
      3,
      3,
      2,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      0.065462,
      1,
      1.573100,
      2.884816,
      0.891306,
      1,
      0,
      0.187811,
      0.089414,
      0.014915,
      0.682592,
      0,
      0,
      0,
      0,
      NULL,
      2.808163,
      11.453045,
      5,
      3.376315,
      NULL,
      NULL,
      1,
      2.293200,
      5,
      NULL,
      2,
      3,
      71.736121,
      2,
      NULL,
      NULL,
      30,
      NULL,
      31,
      1,
      1,
      2.944556,
      '42131',
      NULL,
      '',
      0.565128,
      '12012',
      '',
      '',
      1,
      '',
      '',
      '',
      1,
      45,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      NULL,
      NULL,
      NULL,
      0.689071,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.432948,
      NULL,
      NULL,
      1.780175,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      3,
      1.378624,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.277671,
      NULL,
      NULL,
      NULL,
      0.566965,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1.481721,
      NULL,
      1,
      NULL,
      1.911250,
      0.412748,
      0.390408,
      0.548336,
      3.009009,
      2,
      2.525613,
      0,
      NULL,
      2,
      0,
      3.072933,
      2,
      1,
      0.256689,
      1.910546,
      0,
      2,
      2.852760,
      NULL,
      0.529603,
      2.384222,
      1,
      0.697626,
      7.351956,
      1.331401,
      7.082635,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.707063,
      NULL,
      NULL,
      NULL,
      1.467269,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.958474,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1,
      NULL,
      NULL,
      0.007090,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.716664,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.770906,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      0,
      3.076458,
      2.803314,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      2.512618,
      0.014173,
      1.524603,
      NULL,
      NULL,
      5,
      3.090930,
      3,
      0.644936,
      NULL,
      NULL,
      2.161634,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0.264491,
      4,
      5,
      3.451689,
      1,
      NULL,
      3,
      1,
      1.470619,
      NULL,
      1.471498,
      1.653993,
      1,
      3,
      NULL,
      NULL,
      1.187991,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.545622,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.979058,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.116161,
      NULL,
      NULL,
      1.482810,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      0,
      1.445192,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.141895,
      NULL,
      NULL,
      NULL,
      3.749951,
      NULL,
      NULL,
      NULL,
      3.097143,
      NULL,
      NULL,
      NULL,
      3.514384,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.458187,
      NULL,
      NULL,
      NULL,
      0.047989,
      0.835182,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      1.475372,
      NULL,
      NULL,
      1,
      1.655502,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.679575,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.802380,
      1.719013,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.926913,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.081670,
      NULL,
      1,
      314,
      NULL,
      1.720039,
      1,
      1,
      NULL,
      0.102341,
      1,
      0,
      1.730192,
      0.297029,
      1,
      0.483088,
      0.160248,
      0.563226,
      0,
      0,
      0.625040,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.279001,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      1,
      6.554728,
      0,
      NULL,
      0,
      2,
      2.142741,
      0.358501,
      NULL,
      0.456157,
      0,
      NULL,
      1,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.521375,
      0.937180,
      1.017292,
      1,
      NULL,
      2,
      2,
      1,
      1.873509,
      NULL,
      3.676413,
      1,
      3.592748,
      NULL,
      1,
      0.623112,
      1.637108,
      1,
      NULL,
      NULL,
      0,
      0.410972,
      1,
      2,
      0.984014,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.752682,
      0.784477,
      0,
      0.796637,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      82.391471,
      3,
      0,
      2.456084,
      NULL,
      '',
      '',
      2,
      '02020',
      '',
      '',
      1.534633,
      '',
      '',
      '');
commit;
end;
/


