set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7607063';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-9-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '22',
      '30',
      23.714490,
      NULL,
      '2423243',
      4.412392,
      1,
      3,
      NULL,
      '3111',
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      15.761429,
      101,
      NULL,
      1.714138,
      1,
      '11-16-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.273199,
      0,
      1,
      0.946931,
      1.565500,
      1.762575,
      0,
      3,
      NULL,
      NULL,
      NULL,
      1.250139,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      1,
      4,
      1,
      1,
      NULL,
      0,
      1,
      1,
      NULL,
      1,
      0,
      1,
      1,
      5.546482,
      1,
      2,
      NULL,
      NULL,
      0.649040,
      NULL,
      NULL,
      1.679416,
      NULL,
      NULL,
      0,
      1,
      0.007499,
      0.891140,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0.687850,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1,
      0,
      2,
      0,
      3,
      0,
      1,
      1,
      1,
      3,
      1,
      NULL,
      0,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      4,
      0,
      1,
      5,
      4,
      NULL,
      1,
      2,
      0,
      NULL,
      1,
      0,
      2,
      NULL,
      1,
      NULL,
      4,
      3,
      NULL,
      NULL,
      3,
      3,
      NULL,
      2646,
      '11- 1-1986',
      2.079741,
      3,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      2,
      4,
      3,
      0,
      NULL,
      1.600582,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      0.668504,
      4,
      1.066234,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.238982,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.441262,
      0,
      1,
      NULL,
      0.578161,
      NULL,
      1,
      1,
      NULL,
      2.140188,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3,
      NULL,
      NULL,
      1,
      1,
      0,
      3,
      1,
      NULL,
      1,
      3.466425,
      3,
      2,
      1,
      3,
      0,
      3,
      NULL,
      0.544864,
      0,
      0,
      1.224620,
      0,
      1.368739,
      1,
      NULL,
      1.873845,
      4.195570,
      0.200972,
      8.748350,
      3.533701,
      1,
      8,
      11.854920,
      3,
      NULL,
      0.705165,
      0,
      0,
      2,
      3.681925,
      19,
      1,
      0,
      19,
      NULL,
      NULL,
      NULL,
      2,
      0.482152,
      1.058217,
      '',
      '',
      '',
      1,
      NULL,
      '',
      NULL,
      1.019694,
      '',
      '',
      NULL,
      3.707734,
      15.559194,
      269.656565,
      37.316504,
      1.313495,
      NULL,
      NULL,
      NULL,
      NULL,
      3.020807,
      3.089544,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.354239,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1.385406,
      3.357815,
      1,
      0.985074,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      0.855516,
      2,
      NULL,
      NULL,
      4,
      3,
      4.208667,
      0,
      1.373535,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.217742,
      1,
      NULL,
      NULL,
      0.851971,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.060076,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.593699,
      NULL,
      NULL,
      NULL,
      1,
      1.166619,
      3.917262,
      1.793590,
      3.682215,
      NULL,
      2,
      0.267238,
      0.720107,
      NULL,
      NULL,
      6,
      1,
      NULL,
      1.901173,
      NULL,
      NULL,
      0.857074,
      NULL,
      NULL,
      1.001046,
      NULL,
      NULL,
      0.570783,
      NULL,
      NULL,
      0.821074,
      NULL,
      NULL,
      0.462782,
      NULL,
      NULL,
      0.178053,
      1.576187,
      1.244355,
      3.943020,
      1,
      0.837632,
      5,
      0,
      4,
      NULL,
      2.419662,
      0,
      1.475770,
      NULL,
      NULL,
      0.463703,
      NULL,
      1,
      0,
      3.637124,
      0,
      3,
      1.816621,
      1,
      2,
      NULL,
      5,
      2,
      NULL,
      3.906763,
      2.312136,
      0.664730,
      NULL,
      0.699484,
      0.523597,
      1,
      0,
      2,
      1.581501,
      4.315768,
      3.269069,
      3,
      3,
      NULL,
      1,
      NULL,
      3,
      1,
      1.738677,
      NULL,
      NULL,
      0,
      0.115563,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.498434,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.651537,
      NULL,
      NULL,
      0.784879,
      0.393867,
      0.665861,
      0.795401,
      1,
      3,
      0.219569,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.765215,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.851251,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.220289,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.121231,
      2,
      NULL,
      0.354087,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.209314,
      NULL,
      1,
      57,
      1,
      0,
      NULL,
      0.500330,
      1.503087,
      NULL,
      1.418135,
      0.504640,
      1,
      1.912633,
      0,
      1,
      NULL,
      0.115987,
      NULL,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      0,
      0.389871,
      0.080097,
      0,
      3,
      2,
      5.841506,
      1,
      1.980236,
      1.967299,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      1,
      NULL,
      1,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.179071,
      NULL,
      1,
      3,
      NULL,
      2.041990,
      2,
      NULL,
      1.123338,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.080309,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      55.926407,
      NULL,
      NULL,
      4.006246,
      2.091862,
      '20012',
      '',
      NULL,
      NULL,
      '31433',
      '',
      '',
      1,
      NULL,
      '',
      '');
commit;
end;
/


