set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9883245';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-8-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      4,
      2,
      1,
      2,
      1.473350,
      1.123839,
      NULL,
      1,
      '134',
      '03231343',
      9.310036,
      12.251315,
      '3342044',
      NULL,
      0,
      1,
      0,
      '0100',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-25-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      ' 7- 6-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      ' 8- 5-1985',
      ' 1-19-1990',
      NULL,
      NULL,
      1.578226,
      0,
      2,
      1,
      3,
      2,
      NULL,
      0.715950,
      NULL,
      5,
      1.993895,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      0.405360,
      1,
      0,
      0.842356,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0.015511,
      1.940772,
      0,
      1,
      0,
      0,
      4,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      0,
      3,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      1.259680,
      NULL,
      NULL,
      1.218425,
      NULL,
      NULL,
      3,
      2,
      5.727258,
      1.548490,
      1,
      1,
      0,
      1,
      1,
      3.361258,
      1,
      0,
      NULL,
      1.262784,
      2.847043,
      3.562208,
      0.704050,
      3.636827,
      0.012095,
      0,
      0,
      NULL,
      4,
      NULL,
      1,
      2,
      0,
      NULL,
      NULL,
      0.659471,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1,
      NULL,
      1,
      1,
      0,
      1,
      1,
      0,
      0,
      0,
      1,
      0,
      NULL,
      0,
      0,
      0,
      NULL,
      1,
      0,
      1,
      0,
      1,
      1,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0,
      2,
      0,
      0,
      4,
      5,
      4,
      0,
      0,
      5,
      1,
      5,
      NULL,
      3,
      5,
      3,
      ' 1-19-2002',
      NULL,
      '11- 2-2002',
      104,
      1.579091,
      0,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      14,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.752719,
      1.629089,
      NULL,
      NULL,
      NULL,
      0.080610,
      1,
      0,
      4,
      1,
      3.710272,
      6,
      1,
      NULL,
      NULL,
      0.089141,
      9,
      0.209922,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.129193,
      NULL,
      1.456908,
      1,
      NULL,
      NULL,
      NULL,
      10.110870,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3.764360,
      NULL,
      1,
      2,
      3,
      3,
      2,
      1,
      0,
      2,
      2,
      NULL,
      2.520239,
      3,
      2,
      1,
      0,
      NULL,
      0.901426,
      0,
      1,
      0,
      0.973424,
      NULL,
      NULL,
      0.184736,
      0,
      1,
      NULL,
      0,
      10,
      NULL,
      2,
      0,
      1.417748,
      2.393404,
      5,
      2.048827,
      7,
      2.370741,
      0,
      3.512136,
      9.765644,
      3,
      1.563510,
      9,
      NULL,
      22,
      47,
      0,
      1,
      2,
      '12301',
      NULL,
      '',
      0,
      '',
      '',
      '',
      1.074391,
      NULL,
      '',
      '',
      2.248176,
      10,
      21,
      3.018696,
      NULL,
      NULL,
      0.091470,
      7,
      5,
      1.105814,
      3,
      1,
      1.681361,
      NULL,
      NULL,
      1.028423,
      NULL,
      NULL,
      0.970088,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.007295,
      0,
      NULL,
      NULL,
      1.577009,
      NULL,
      NULL,
      NULL,
      0.825824,
      2.582804,
      1,
      NULL,
      NULL,
      1.120475,
      NULL,
      NULL,
      5,
      2.764212,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      3.683558,
      NULL,
      NULL,
      3,
      1.426236,
      1.882236,
      1,
      NULL,
      0,
      1.851107,
      3.519955,
      3.955178,
      2.620783,
      2,
      0.607001,
      0.318959,
      1,
      0.722592,
      NULL,
      NULL,
      1,
      0.779401,
      1,
      0.164290,
      3.534247,
      0.523127,
      3.368171,
      2.198161,
      0.204637,
      NULL,
      NULL,
      NULL,
      1.495091,
      NULL,
      NULL,
      0.996935,
      NULL,
      NULL,
      2.414600,
      8,
      7.257476,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.533251,
      0.847184,
      NULL,
      1.463057,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      1.751708,
      NULL,
      NULL,
      3,
      2.179298,
      3,
      0.683872,
      NULL,
      NULL,
      0.266665,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.345333,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.854644,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5,
      0.488015,
      2.404623,
      0.239611,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      0.566586,
      1.182412,
      0,
      NULL,
      NULL,
      NULL,
      1.862558,
      5.940914,
      3,
      3,
      3.367118,
      NULL,
      1.553993,
      2.938365,
      0.579595,
      NULL,
      NULL,
      NULL,
      0.145772,
      3.448815,
      1,
      2.911672,
      7.450548,
      7.979326,
      1,
      1,
      3,
      0,
      3,
      1.026631,
      NULL,
      0.177718,
      0.518058,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.953367,
      NULL,
      NULL,
      0.002054,
      NULL,
      NULL,
      1.214166,
      NULL,
      NULL,
      0.464890,
      NULL,
      NULL,
      1.077349,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.183831,
      NULL,
      NULL,
      0.879830,
      NULL,
      NULL,
      1.708283,
      NULL,
      2,
      0,
      6,
      6.895552,
      NULL,
      NULL,
      2.278796,
      14.772476,
      14,
      NULL,
      1.746111,
      1.096745,
      0.396591,
      NULL,
      2.497691,
      NULL,
      0.315005,
      NULL,
      NULL,
      1.121809,
      1,
      NULL,
      1.988963,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      1.540395,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.806520,
      1.622986,
      NULL,
      1,
      0.054801,
      NULL,
      NULL,
      1.695736,
      NULL,
      NULL,
      NULL,
      0,
      0.322172,
      3.399195,
      NULL,
      1,
      NULL,
      0,
      NULL,
      2,
      3,
      0.343148,
      NULL,
      3,
      1.513967,
      0,
      NULL,
      8.579143,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.347716,
      60,
      28.440182,
      1.238026,
      49.921871,
      NULL,
      1,
      NULL,
      NULL,
      2,
      0,
      0.926376,
      1.176712,
      NULL,
      NULL,
      0.388666,
      NULL,
      NULL,
      0.852500,
      NULL,
      NULL,
      0.784814,
      0.771993,
      1.859256,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.865895,
      NULL,
      0,
      1.720032,
      NULL,
      0,
      0,
      1,
      0.616949,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0.154418,
      1.228736,
      0.457614,
      1,
      NULL,
      NULL,
      NULL,
      0.326226,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.468151,
      1.473965,
      NULL,
      1.655444,
      1,
      NULL,
      0.259367,
      1.247400,
      NULL,
      0.010206,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1.221711,
      1,
      NULL,
      0,
      1,
      NULL,
      1.267315,
      1,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.228879,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1.965611,
      NULL,
      NULL,
      40,
      28,
      1,
      5,
      0,
      '11302',
      '',
      '',
      0.485434,
      '',
      '',
      '',
      0,
      '33032',
      '',
      '');
commit;
end;
/


