set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8914693';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-6-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '1',
      NULL,
      NULL,
      '2431143',
      3.669108,
      1.459135,
      NULL,
      NULL,
      '3030',
      1,
      0.256623,
      NULL,
      NULL,
      ' 9-19-1993',
      NULL,
      NULL,
      5,
      0.810223,
      1,
      ' 6-11-1988',
      15,
      2,
      NULL,
      500,
      3,
      NULL,
      NULL,
      '10-18-1998',
      1,
      1,
      1.304631,
      1,
      NULL,
      2.635774,
      2,
      1,
      1,
      414,
      NULL,
      3.142241,
      4.997642,
      NULL,
      9,
      0,
      5.262971,
      0,
      2,
      8,
      1,
      NULL,
      0,
      1.671272,
      NULL,
      NULL,
      0.568465,
      0,
      0.395093,
      NULL,
      145,
      3,
      3,
      3,
      2.550055,
      1,
      0,
      1,
      0,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.619163,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      2,
      NULL,
      4,
      1,
      0,
      0,
      NULL,
      0,
      1,
      NULL,
      1,
      0,
      NULL,
      0,
      0,
      0,
      1.680792,
      NULL,
      1.406361,
      5,
      1,
      0,
      2,
      2,
      NULL,
      2,
      0,
      2,
      NULL,
      0,
      NULL,
      4,
      1,
      NULL,
      1,
      NULL,
      NULL,
      2,
      1,
      NULL,
      5,
      NULL,
      5,
      5,
      2.669926,
      NULL,
      ' 9-21-1993',
      638,
      '11-22-1992',
      1821,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1,
      0,
      0,
      NULL,
      1,
      2.144009,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      2.616101,
      1.887179,
      2,
      3.172186,
      0.424671,
      NULL,
      NULL,
      NULL,
      1.633856,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.286207,
      1.298711,
      NULL,
      0.578375,
      1,
      NULL,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.229104,
      NULL,
      15,
      40,
      NULL,
      3,
      1.972728,
      1.562380,
      '42341',
      '01101',
      '',
      0,
      '',
      '',
      '',
      NULL,
      '1040',
      '2410',
      NULL,
      3,
      33.934677,
      842.333669,
      1,
      0.836431,
      NULL,
      NULL,
      NULL,
      NULL,
      2.113526,
      1.813427,
      1.193703,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      0,
      1.365704,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.142633,
      NULL,
      NULL,
      1.058988,
      NULL,
      NULL,
      0.117818,
      0.180743,
      NULL,
      0.400393,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.010612,
      NULL,
      NULL,
      NULL,
      4.954618,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0,
      1.626879,
      0,
      0.843244,
      NULL,
      NULL,
      2,
      NULL,
      1.053315,
      NULL,
      0.854726,
      NULL,
      NULL,
      0,
      1,
      1,
      2,
      0,
      1,
      1,
      NULL,
      NULL,
      0.221121,
      NULL,
      NULL,
      1.380344,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      7,
      NULL,
      4,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.992775,
      3,
      1.418235,
      1,
      NULL,
      3.049127,
      0.125179,
      NULL,
      2,
      1.946608,
      NULL,
      NULL,
      NULL,
      3,
      6.334107,
      2,
      3.461247,
      0.147071,
      NULL,
      2.476482,
      0.660479,
      5,
      5.509880,
      4.360710,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      3.449459,
      2.715814,
      3,
      0.743448,
      3.342303,
      2,
      6,
      3,
      5,
      0.815612,
      5.067195,
      0.410760,
      5.281576,
      2.259375,
      NULL,
      0,
      0,
      0,
      1.465037,
      3.356366,
      2.711847,
      1.407434,
      4,
      2.659127,
      3,
      3,
      NULL,
      2,
      3,
      2.166386,
      NULL,
      0.365179,
      1.857457,
      3.486218,
      NULL,
      2,
      1.798402,
      1.338010,
      NULL,
      4.290137,
      2,
      1,
      2.293333,
      3.696184,
      4,
      1,
      0.936914,
      0,
      0.724829,
      0.481012,
      0.504307,
      2.341625,
      NULL,
      NULL,
      1.491070,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.918866,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.854188,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.250537,
      NULL,
      NULL,
      0.835881,
      1.339139,
      0,
      0,
      1.900995,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.610830,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.563100,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.067785,
      NULL,
      NULL,
      NULL,
      0.467224,
      NULL,
      NULL,
      NULL,
      7.271894,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      3,
      1.823580,
      280.369847,
      18,
      NULL,
      NULL,
      NULL,
      0.569066,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.886984,
      NULL,
      NULL,
      0,
      22,
      NULL,
      NULL,
      4.350948,
      2.462892,
      1903,
      11,
      NULL,
      NULL,
      1,
      0.000121,
      0,
      0.477368,
      1,
      1,
      NULL,
      1.264405,
      0.942362,
      0,
      0,
      0.923917,
      0.414195,
      0,
      1.301478,
      0.897786,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.542251,
      NULL,
      5,
      4,
      0,
      19.935717,
      1.569944,
      3.422186,
      NULL,
      1,
      0.872264,
      NULL,
      1.173945,
      1.482344,
      NULL,
      NULL,
      2,
      NULL,
      1.125274,
      1,
      NULL,
      1.124174,
      2,
      NULL,
      0,
      NULL,
      NULL,
      3,
      0.139820,
      NULL,
      1,
      3.281754,
      NULL,
      1.821182,
      0,
      NULL,
      2.159488,
      0,
      NULL,
      NULL,
      3.432333,
      NULL,
      2.945656,
      0.889428,
      1.590367,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.785840,
      NULL,
      NULL,
      NULL,
      0.554073,
      NULL,
      2,
      6,
      0,
      0,
      0,
      1,
      32.928546,
      14.935985,
      5,
      0.329035,
      2.792498,
      '40224',
      '31442',
      '',
      1,
      '',
      '',
      NULL,
      6.264916,
      '3301',
      '1330',
      NULL);
commit;
end;
/


