set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '3375557';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-5-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      6.288182,
      0.852434,
      NULL,
      NULL,
      NULL,
      1.770101,
      0.829096,
      1.104930,
      NULL,
      '30023324',
      36,
      15.761705,
      '0043133',
      0,
      0.604557,
      2,
      3,
      '0242',
      NULL,
      1,
      NULL,
      NULL,
      '11- 8-1985',
      NULL,
      NULL,
      NULL,
      2.330480,
      3.322271,
      ' 2- 7-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      '10-27-1977',
      NULL,
      ' 3-26-1999',
      1.349194,
      NULL,
      1.946173,
      1.661308,
      NULL,
      NULL,
      0,
      3.016982,
      NULL,
      NULL,
      NULL,
      4,
      6.395919,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3,
      2,
      0,
      0,
      0,
      3,
      NULL,
      0,
      NULL,
      3,
      2,
      0,
      1,
      0.970248,
      3,
      0,
      NULL,
      2,
      0.942738,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      1,
      0.585637,
      0.692891,
      1.102324,
      1,
      1,
      2,
      1,
      1.280990,
      0,
      0,
      0.442951,
      1,
      0.352519,
      0,
      3,
      0,
      NULL,
      1.067127,
      2,
      NULL,
      1,
      0.046483,
      NULL,
      NULL,
      0.950988,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      NULL,
      3,
      2,
      1,
      1,
      1,
      0,
      0,
      1,
      2,
      1,
      1,
      0,
      NULL,
      1,
      NULL,
      0.440125,
      NULL,
      0,
      1,
      NULL,
      1,
      0,
      2,
      NULL,
      NULL,
      0,
      3,
      NULL,
      3,
      0,
      NULL,
      NULL,
      5,
      1,
      1,
      0,
      0,
      3,
      5,
      4,
      0,
      NULL,
      3,
      ' 9-10-1999',
      14,
      NULL,
      6,
      2,
      NULL,
      2,
      2,
      2,
      2,
      NULL,
      1,
      1,
      NULL,
      0,
      1,
      3,
      4,
      1,
      0,
      2,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      0.458252,
      NULL,
      NULL,
      NULL,
      0.082257,
      NULL,
      NULL,
      9.999800,
      NULL,
      5,
      NULL,
      0.765606,
      NULL,
      NULL,
      0,
      9,
      0.137783,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      2,
      1,
      0,
      3.913554,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.663508,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      2,
      3,
      2,
      3,
      1.380298,
      NULL,
      0,
      NULL,
      0,
      0.493670,
      0.208967,
      NULL,
      0.011440,
      0.823089,
      0.986488,
      1.405814,
      NULL,
      NULL,
      5.566481,
      1,
      NULL,
      5,
      0.399834,
      8,
      6.009859,
      NULL,
      4,
      3.902441,
      0,
      0,
      1,
      0.852269,
      66,
      1,
      1,
      49,
      NULL,
      45,
      9.035110,
      NULL,
      3,
      NULL,
      '22012',
      '03400',
      '40302',
      0,
      '',
      '',
      '',
      0.015946,
      '',
      '',
      '',
      1.742313,
      7.663800,
      5.210792,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.956644,
      3,
      0,
      1.964482,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.624960,
      NULL,
      0,
      NULL,
      1.179304,
      0.329988,
      NULL,
      NULL,
      NULL,
      1.972544,
      NULL,
      1.362485,
      NULL,
      4,
      0.627885,
      1,
      0.228798,
      0,
      1,
      0,
      0,
      0.447332,
      0.501653,
      NULL,
      NULL,
      NULL,
      0.082005,
      0,
      0.486860,
      0,
      0.672626,
      1.014579,
      1,
      NULL,
      0.148655,
      NULL,
      0.587077,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      89,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.834290,
      NULL,
      1.986498,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.427664,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.879046,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.110243,
      NULL,
      NULL,
      0.845021,
      2.857205,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.681268,
      NULL,
      0.194974,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.775877,
      NULL,
      NULL,
      NULL,
      0.774194,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      3,
      0.554428,
      1,
      1.391366,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      NULL,
      1.279703,
      0.483889,
      NULL,
      0,
      0,
      NULL,
      0.071924,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0.369956,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.357236,
      NULL,
      3.164140,
      1,
      0.218769,
      NULL,
      474,
      1.620036,
      NULL,
      1,
      1,
      1.349091,
      1,
      NULL,
      NULL,
      21.223532,
      NULL,
      1,
      1,
      0.721766,
      NULL,
      0,
      0,
      1,
      3.780532,
      3.979361,
      0.332060,
      1,
      2,
      2,
      1.806043,
      1.849387,
      0.557687,
      0.096654,
      NULL,
      NULL,
      1.597943,
      1,
      NULL,
      0.137511,
      1,
      NULL,
      0,
      NULL,
      NULL,
      2,
      0,
      NULL,
      1,
      0.046559,
      NULL,
      1,
      NULL,
      NULL,
      1.330282,
      1,
      NULL,
      1.792828,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1.416164,
      1,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.414155,
      NULL,
      0.091211,
      NULL,
      1,
      5,
      3,
      0,
      NULL,
      NULL,
      NULL,
      37.520311,
      NULL,
      4.146914,
      2,
      '14120',
      '10312',
      NULL,
      0,
      '',
      '',
      '',
      0.059083,
      '',
      '',
      NULL);
commit;
end;
/


