set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9763902';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-11-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      0,
      2,
      1.879124,
      NULL,
      2,
      1.790415,
      2,
      0,
      '124',
      NULL,
      34,
      17.567267,
      NULL,
      2,
      0.788135,
      2,
      0,
      '1113',
      2,
      0,
      NULL,
      NULL,
      ' 7-16-2002',
      4,
      44.801133,
      NULL,
      2,
      NULL,
      ' 3-19-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      ' 7-27-1983',
      ' 4-14-2001',
      ' 8- 3-1996',
      3,
      NULL,
      3.547497,
      NULL,
      1,
      NULL,
      NULL,
      0.768218,
      NULL,
      NULL,
      NULL,
      2.592427,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1,
      3.232706,
      4,
      NULL,
      1,
      1,
      0,
      3,
      1,
      1,
      0,
      0,
      0,
      NULL,
      7.063899,
      1,
      1,
      1,
      0,
      0.066919,
      NULL,
      NULL,
      2.777175,
      NULL,
      1,
      4,
      NULL,
      NULL,
      0,
      1,
      1.180290,
      3,
      1,
      2.875274,
      0,
      3,
      0.103333,
      0.373853,
      3.663475,
      1,
      3.648278,
      1,
      0,
      2.664764,
      2,
      0,
      1,
      5,
      0,
      1,
      3.592150,
      1,
      NULL,
      NULL,
      2,
      2,
      0,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      1,
      1.515798,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      2,
      2,
      0,
      NULL,
      2,
      NULL,
      3,
      1,
      0,
      3,
      NULL,
      4,
      5,
      4,
      1,
      0,
      0,
      4,
      2,
      0,
      3,
      5,
      1,
      NULL,
      5,
      2,
      2,
      1.558109,
      ' 1-17-1984',
      4,
      ' 4-20-1998',
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      1,
      0,
      0,
      0.404469,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      1.747748,
      2,
      0,
      NULL,
      0,
      3,
      NULL,
      5,
      0.931012,
      1.116635,
      0.442085,
      0.674256,
      2.749952,
      NULL,
      2,
      0.621986,
      6.737077,
      5.576330,
      4,
      6,
      0.204640,
      NULL,
      NULL,
      0,
      13,
      1.968245,
      1,
      3,
      0,
      7.132718,
      ' 1- 4-1991',
      12.485456,
      NULL,
      NULL,
      3,
      NULL,
      0,
      1,
      1.072155,
      1,
      1.479757,
      1.072011,
      0.819967,
      1,
      NULL,
      16.001782,
      3,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      0,
      NULL,
      3,
      0,
      NULL,
      1,
      2,
      2,
      1,
      1.772256,
      3,
      NULL,
      0,
      1,
      1.285979,
      1.119179,
      0.262215,
      0.670324,
      0.280550,
      0,
      1,
      0.551379,
      0.284083,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.644516,
      NULL,
      6.524223,
      10.754625,
      4.334326,
      0,
      1,
      0.415850,
      6,
      NULL,
      1,
      0,
      NULL,
      3,
      3.625283,
      11,
      NULL,
      19,
      3,
      NULL,
      1,
      NULL,
      '10324',
      NULL,
      '',
      0.422418,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      2,
      33.040899,
      53.873220,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.373887,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.427400,
      NULL,
      NULL,
      0.144108,
      NULL,
      NULL,
      1.457994,
      NULL,
      NULL,
      0.972594,
      NULL,
      NULL,
      1.346276,
      NULL,
      NULL,
      0.259636,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.535458,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.206130,
      NULL,
      NULL,
      1.792071,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.906476,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.975898,
      NULL,
      NULL,
      1.898900,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.507085,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.837611,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.421945,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.083659,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.826998,
      NULL,
      3,
      0,
      1,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.535832,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.034440,
      NULL,
      NULL,
      NULL,
      0.502794,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.560269,
      NULL,
      NULL,
      NULL,
      0.022399,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.961104,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.560242,
      NULL,
      NULL,
      NULL,
      4.593950,
      NULL,
      NULL,
      NULL,
      3.301350,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      0.720096,
      0.102120,
      3.182452,
      3,
      2.081248,
      NULL,
      NULL,
      NULL,
      1.810925,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.305892,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.068944,
      0.103545,
      1,
      NULL,
      0.392494,
      0.557121,
      NULL,
      1.009605,
      0.228001,
      0,
      NULL,
      0,
      1.625188,
      NULL,
      NULL,
      0.205684,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.231382,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0,
      0.070629,
      0.816330,
      1.410203,
      0.163069,
      0,
      8,
      3,
      3.722755,
      0.263261,
      1,
      0,
      0.938531,
      1,
      1.932277,
      1,
      0,
      0.914846,
      NULL,
      1,
      1,
      1,
      1.242067,
      1.037248,
      NULL,
      0.119276,
      0,
      1.134971,
      0,
      1.499073,
      3,
      0.572912,
      1,
      0.951940,
      0,
      1,
      1,
      1,
      1.266447,
      NULL,
      0.086765,
      NULL,
      0.300311,
      1.905970,
      NULL,
      0.118493,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.295253,
      1.428700,
      1,
      0.380103,
      0.336846,
      0.475642,
      NULL,
      1.005669,
      0.244949,
      1,
      1,
      0.701890,
      0,
      1,
      1.946877,
      3.492418,
      1.503816,
      1.777318,
      1.279880,
      3,
      1,
      1.208207,
      1.027776,
      0,
      1,
      0,
      27,
      0.711602,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.624413,
      1,
      1,
      6,
      1,
      NULL,
      NULL,
      68.397663,
      NULL,
      4,
      3.438311,
      1,
      '44024',
      '',
      '',
      1,
      '',
      '',
      '',
      1,
      NULL,
      '',
      '');
commit;
end;
/


