set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9505188';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-6-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      1,
      3,
      2.503039,
      NULL,
      2.766711,
      3,
      3.920289,
      NULL,
      '113',
      '31234212',
      NULL,
      NULL,
      '4032111',
      2.034096,
      NULL,
      1,
      3,
      '2323',
      NULL,
      1,
      NULL,
      NULL,
      ' 0-22-1976',
      176.060771,
      19,
      NULL,
      NULL,
      1,
      ' 6-17-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.362077,
      1.538604,
      0.536803,
      NULL,
      0,
      1.052679,
      0,
      0.657276,
      1.759652,
      NULL,
      6,
      10.881446,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      4,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      2,
      0,
      0,
      0,
      0,
      0,
      1,
      0,
      1,
      1,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.461958,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      1,
      3,
      0,
      0,
      NULL,
      0,
      1,
      0,
      1,
      3.121081,
      0,
      NULL,
      0,
      1,
      1.966118,
      NULL,
      0,
      NULL,
      5,
      1,
      1,
      1,
      2,
      5,
      1,
      0,
      1,
      NULL,
      1,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      2,
      NULL,
      1,
      0,
      0.466450,
      1.797856,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      0,
      1,
      1,
      0.106827,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.405721,
      0,
      NULL,
      0,
      1,
      1.120091,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.379685,
      0,
      0.985238,
      0.167191,
      0,
      0,
      0.654365,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0,
      NULL,
      0,
      1,
      NULL,
      2,
      1,
      0,
      2,
      1,
      NULL,
      2,
      2,
      0.649144,
      0,
      1.178910,
      1,
      2,
      1.679561,
      1.662924,
      0,
      0,
      1.116940,
      1.300013,
      0.192931,
      1.382045,
      0,
      1,
      3.905343,
      NULL,
      2,
      NULL,
      0,
      5,
      NULL,
      0,
      1,
      NULL,
      2,
      0,
      2,
      NULL,
      34,
      3,
      0,
      42,
      NULL,
      NULL,
      NULL,
      0,
      4.751818,
      1.626679,
      '00340',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1.687742,
      '',
      '',
      '',
      3,
      14.416877,
      222,
      14,
      1.036542,
      NULL,
      3.175073,
      1.374560,
      3,
      2.547118,
      1.965400,
      3.236778,
      1.205256,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.120748,
      1.583611,
      NULL,
      NULL,
      1.260105,
      NULL,
      NULL,
      0.073900,
      2.525802,
      2,
      3.053622,
      1,
      0.001211,
      1.714027,
      NULL,
      0.037262,
      3,
      3.085133,
      3,
      3,
      2.864851,
      0,
      3,
      NULL,
      1,
      NULL,
      4.681672,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.728526,
      3,
      0.833130,
      1.366594,
      0.271676,
      1,
      2,
      1,
      0,
      NULL,
      0.967323,
      0.019249,
      NULL,
      0,
      NULL,
      2.478937,
      0,
      0.403201,
      NULL,
      0,
      NULL,
      NULL,
      0.901790,
      1.659785,
      0,
      NULL,
      1.209500,
      0,
      3,
      0,
      0,
      1,
      NULL,
      1.445248,
      NULL,
      2.678492,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.708640,
      1.525004,
      0,
      0,
      3.884764,
      0,
      1,
      NULL,
      NULL,
      NULL,
      2.499098,
      1.004160,
      0.234061,
      1,
      2.583101,
      NULL,
      2,
      0.515548,
      3.521564,
      NULL,
      3,
      0,
      NULL,
      NULL,
      1.869724,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.768112,
      NULL,
      NULL,
      0.690425,
      NULL,
      NULL,
      0.539069,
      NULL,
      NULL,
      NULL,
      2.958994,
      0,
      1,
      0.038833,
      0.611955,
      0,
      1.091138,
      1,
      9.308039,
      0,
      1,
      0.444024,
      NULL,
      NULL,
      NULL,
      NULL,
      0.445458,
      2.285939,
      NULL,
      2.405787,
      3,
      2.617030,
      NULL,
      NULL,
      5.468132,
      NULL,
      3,
      1.322221,
      1.934189,
      3.493288,
      3.972485,
      3.692387,
      1,
      3,
      2,
      1.573652,
      2,
      3,
      7,
      3.662483,
      NULL,
      1,
      NULL,
      NULL,
      1.637673,
      0,
      3,
      1,
      NULL,
      1,
      1.965467,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.198362,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.530299,
      NULL,
      NULL,
      1.247237,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      1.832757,
      1,
      1.342967,
      0.981143,
      1.574293,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.370950,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.962211,
      NULL,
      NULL,
      NULL,
      0.832571,
      0,
      NULL,
      NULL,
      1,
      0.819437,
      NULL,
      NULL,
      NULL,
      2.138094,
      NULL,
      NULL,
      1.309833,
      0.821313,
      NULL,
      NULL,
      0.590277,
      0.824909,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      0.906164,
      NULL,
      NULL,
      7.098987,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.841034,
      NULL,
      7.529643,
      NULL,
      NULL,
      13,
      0,
      NULL,
      NULL,
      1.998332,
      NULL,
      NULL,
      0.703871,
      NULL,
      NULL,
      1.652549,
      NULL,
      NULL,
      1,
      NULL,
      0,
      36,
      7.845039,
      NULL,
      0,
      1,
      0.354383,
      NULL,
      1.874629,
      0,
      1.497518,
      0,
      0.127993,
      NULL,
      NULL,
      1,
      NULL,
      1.460080,
      NULL,
      1.939763,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.164386,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.193401,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.615646,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.236927,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.622622,
      NULL,
      0.678388,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.696148,
      NULL,
      0,
      NULL,
      1.828318,
      NULL,
      NULL,
      NULL,
      1.400701,
      0,
      2.342175,
      NULL,
      0,
      NULL,
      0.832262,
      NULL,
      NULL,
      NULL,
      0.542658,
      NULL,
      0.333186,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      4,
      3,
      NULL,
      3.065706,
      0,
      NULL,
      NULL,
      NULL,
      2,
      0.190582,
      2.614081,
      1.858604,
      0.765538,
      2,
      3,
      0.995946,
      3.577545,
      1,
      NULL,
      1.164813,
      NULL,
      0.054711,
      0.143778,
      NULL,
      0,
      1,
      2,
      3.376920,
      0.997267,
      1.774243,
      0.436929,
      1,
      0.042063,
      1.218933,
      0,
      1.231815,
      0.038395,
      0.848428,
      0,
      0,
      0.184491,
      1,
      3.151930,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.147802,
      1.710224,
      0.886879,
      0,
      NULL,
      1,
      2,
      0,
      7,
      NULL,
      NULL,
      NULL,
      127.923083,
      120,
      5,
      NULL,
      0,
      '11230',
      '',
      NULL,
      0.244650,
      '',
      '',
      '',
      1,
      NULL,
      '',
      '');
commit;
end;
/


