set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8729166';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-7-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '2',
      NULL,
      NULL,
      '1343323',
      NULL,
      0.958425,
      2,
      1,
      '2204',
      NULL,
      1,
      NULL,
      NULL,
      ' 9-28-1978',
      NULL,
      NULL,
      5,
      0,
      0.078320,
      '11-22-1979',
      NULL,
      1,
      154,
      72.424689,
      NULL,
      ' 8- 9-1998',
      ' 9-11-1981',
      ' 4-21-2002',
      1,
      3.286483,
      NULL,
      NULL,
      1,
      0.774961,
      3,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      6.520346,
      NULL,
      4,
      5,
      3,
      7.342239,
      0,
      0,
      1,
      1.145039,
      0.386196,
      NULL,
      0,
      0,
      0,
      0.264272,
      0.214909,
      0,
      2,
      3,
      NULL,
      0,
      1,
      0,
      5,
      0,
      0,
      0,
      1,
      1,
      1,
      1,
      1,
      5,
      0,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      1.638468,
      NULL,
      NULL,
      0,
      NULL,
      0.334015,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.014709,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      0,
      0,
      4,
      0,
      0,
      0,
      0,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      1.379461,
      5,
      1,
      1,
      NULL,
      5,
      2,
      1,
      2,
      1,
      5,
      2,
      3,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      2,
      1,
      3,
      5,
      0,
      1,
      1,
      NULL,
      0.750151,
      '11-12-1991',
      6.352924,
      '10-20-2000',
      15.905718,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.330781,
      0,
      1.190153,
      0,
      0,
      0.850917,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.780967,
      1.951857,
      1.905062,
      NULL,
      0.144635,
      1,
      1,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      3,
      1.552449,
      1.405966,
      0,
      3,
      3,
      3,
      3,
      3,
      NULL,
      3,
      0,
      2,
      2,
      11,
      NULL,
      NULL,
      118,
      NULL,
      130,
      181,
      59,
      1,
      NULL,
      1.170882,
      1.934099,
      0,
      0.874599,
      1,
      4,
      16,
      0.656180,
      5,
      9,
      0.482079,
      NULL,
      9,
      0,
      2,
      NULL,
      5.797215,
      2.381463,
      1,
      2.151172,
      39,
      0,
      NULL,
      NULL,
      30,
      50,
      NULL,
      NULL,
      1,
      1.999088,
      '40001',
      '',
      '',
      0,
      '',
      '',
      '',
      0.474369,
      NULL,
      NULL,
      NULL,
      0.814795,
      28,
      26,
      1,
      NULL,
      NULL,
      1,
      1.750666,
      4,
      1,
      3,
      2,
      1.453506,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.083586,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.848766,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.215353,
      NULL,
      NULL,
      9,
      11,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.992276,
      NULL,
      NULL,
      0.964205,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.945327,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.004664,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.699244,
      2.323258,
      1.867720,
      2.706842,
      3,
      1,
      1.360230,
      NULL,
      NULL,
      8.641507,
      8,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.631800,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.518333,
      1,
      1.518070,
      NULL,
      NULL,
      NULL,
      NULL,
      6.653669,
      0,
      4,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.452573,
      3,
      0,
      0.218229,
      NULL,
      NULL,
      1.295662,
      NULL,
      NULL,
      1,
      2,
      NULL,
      2.493768,
      3,
      3,
      NULL,
      0.264595,
      5.690249,
      0.954460,
      NULL,
      NULL,
      3.476923,
      0,
      2,
      1.077568,
      0.653692,
      NULL,
      NULL,
      1.606376,
      3.749228,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.203402,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.159496,
      NULL,
      NULL,
      0.092179,
      0.684702,
      0,
      1.443568,
      NULL,
      1.216236,
      3.988852,
      NULL,
      NULL,
      1.220920,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.117702,
      1.569399,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0.964815,
      NULL,
      NULL,
      1,
      0.027246,
      NULL,
      NULL,
      0.527336,
      0,
      NULL,
      NULL,
      1,
      0.849633,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.000094,
      NULL,
      NULL,
      NULL,
      1,
      1.886336,
      NULL,
      NULL,
      1.925256,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      4,
      0,
      NULL,
      NULL,
      1.598858,
      NULL,
      NULL,
      0.945653,
      NULL,
      NULL,
      1.532392,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.231042,
      NULL,
      1.398179,
      947.340282,
      NULL,
      0,
      NULL,
      1,
      1.083123,
      0,
      NULL,
      NULL,
      0,
      0.107084,
      0,
      NULL,
      0.890507,
      1,
      NULL,
      0.060599,
      0.512907,
      NULL,
      0.542839,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      2,
      11.847816,
      3.227071,
      0.187474,
      1.717220,
      NULL,
      4.655921,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.963514,
      0.872306,
      1.850765,
      NULL,
      NULL,
      0,
      NULL,
      1.931242,
      0,
      0.680065,
      NULL,
      NULL,
      1.706073,
      0,
      3.013131,
      2,
      2.146850,
      NULL,
      NULL,
      0.210154,
      NULL,
      0.111977,
      NULL,
      0.527059,
      0,
      2.027750,
      1,
      1.243957,
      1,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.107272,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.870072,
      1.086579,
      1.820419,
      1,
      1.252726,
      1,
      4,
      5,
      NULL,
      0.577359,
      0.856102,
      35,
      NULL,
      3,
      1.005861,
      0,
      NULL,
      '',
      '',
      1.724158,
      '',
      '',
      '',
      1.228057,
      '',
      '',
      '');
commit;
end;
/


