set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9038596';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-12-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '1',
      NULL,
      NULL,
      NULL,
      0,
      0.782830,
      2,
      2,
      NULL,
      3.165437,
      1,
      NULL,
      NULL,
      ' 7-10-1996',
      55,
      NULL,
      1,
      0,
      1.811822,
      ' 8-28-1980',
      10.491205,
      NULL,
      130,
      NULL,
      0,
      ' 1-26-1998',
      '11-15-1982',
      ' 0-22-1975',
      1.373593,
      1,
      2.443545,
      1.471848,
      0,
      1.095985,
      3,
      1.355760,
      NULL,
      173,
      2,
      10.785423,
      11,
      2.820541,
      9.558627,
      4,
      17.575970,
      1,
      3,
      NULL,
      1,
      2,
      NULL,
      0,
      0,
      0,
      1.111785,
      0.123830,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.637809,
      3,
      1,
      1,
      2,
      1,
      1,
      0,
      0,
      NULL,
      0,
      0,
      NULL,
      6.535694,
      0,
      NULL,
      0,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1,
      1.415214,
      NULL,
      0,
      0.482925,
      0.081445,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      0.436555,
      0.828239,
      0,
      2,
      NULL,
      2,
      5,
      0,
      2,
      2.430531,
      0.371199,
      NULL,
      NULL,
      0.907030,
      NULL,
      NULL,
      0,
      NULL,
      3,
      1,
      2,
      4,
      5,
      0,
      3,
      NULL,
      3,
      1,
      0,
      0,
      NULL,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      3,
      2,
      1,
      1,
      0,
      NULL,
      2,
      NULL,
      1,
      0,
      5,
      0,
      2,
      0,
      4,
      3,
      5,
      NULL,
      5,
      5,
      3,
      1,
      5,
      4,
      NULL,
      NULL,
      NULL,
      ' 8- 1-1987',
      NULL,
      ' 7-13-1988',
      841,
      3.347200,
      2,
      1,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      2,
      1,
      1,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.136290,
      4.701891,
      5,
      5.771333,
      NULL,
      6.038911,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.468125,
      0,
      0,
      0,
      0.343013,
      0,
      1,
      3,
      47,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.872451,
      2,
      2,
      2,
      2,
      NULL,
      0,
      0,
      2,
      2,
      NULL,
      2,
      3,
      1,
      2,
      0,
      NULL,
      0.010132,
      0.867124,
      2,
      NULL,
      0,
      0.519889,
      0,
      0,
      1.305773,
      1,
      0,
      3.171217,
      2.058712,
      1.795443,
      6,
      2,
      NULL,
      0.896679,
      NULL,
      0,
      2.198865,
      1.101484,
      2.942331,
      NULL,
      0.490367,
      NULL,
      41,
      NULL,
      0.366466,
      NULL,
      NULL,
      6,
      NULL,
      2,
      0.386419,
      6.183799,
      '20302',
      '10330',
      '33433',
      3,
      '03414',
      '',
      NULL,
      0.881782,
      '',
      '',
      '',
      NULL,
      27,
      66,
      0,
      2,
      12,
      5,
      1,
      3,
      2.319082,
      3,
      2,
      1,
      NULL,
      NULL,
      0.160874,
      NULL,
      NULL,
      2.412237,
      1.248506,
      2.916909,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.205721,
      3,
      2,
      3.550266,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.958133,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.323501,
      5.406715,
      3.883387,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.860386,
      NULL,
      NULL,
      NULL,
      2.936098,
      2.255081,
      1.024373,
      0.748983,
      NULL,
      NULL,
      1.856334,
      NULL,
      NULL,
      NULL,
      1.391465,
      1.101585,
      1,
      1,
      1,
      0,
      NULL,
      1.647889,
      NULL,
      1.263590,
      1,
      1.408135,
      NULL,
      1,
      NULL,
      3.891776,
      1.918087,
      NULL,
      1.223769,
      NULL,
      NULL,
      0.078243,
      NULL,
      NULL,
      6.737954,
      2,
      NULL,
      1,
      1.393261,
      NULL,
      NULL,
      NULL,
      1.227856,
      NULL,
      NULL,
      NULL,
      0.546447,
      1,
      0.514737,
      NULL,
      0.733550,
      0,
      0.337211,
      1.596734,
      NULL,
      1.456087,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.890862,
      1,
      1.984486,
      0.123030,
      NULL,
      NULL,
      5.209250,
      1.406128,
      7,
      1.364208,
      NULL,
      NULL,
      0.859154,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      3,
      0.650634,
      0.536171,
      0.749832,
      3,
      3.647546,
      1,
      3,
      4.093713,
      1,
      5.514294,
      1,
      4,
      5,
      0.614741,
      0,
      NULL,
      NULL,
      0,
      1.165092,
      0,
      0.714080,
      2.018348,
      10,
      3,
      9.694048,
      0,
      1,
      NULL,
      0.899066,
      3.719766,
      1,
      3.468694,
      0,
      2,
      NULL,
      2.392151,
      1.861103,
      NULL,
      2,
      2.811208,
      1,
      1,
      1.155624,
      NULL,
      2,
      NULL,
      0,
      0.678785,
      0.998199,
      1.032337,
      1,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.556412,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.456810,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.384146,
      NULL,
      0,
      0.680574,
      1.570297,
      NULL,
      NULL,
      3.778811,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.563520,
      NULL,
      NULL,
      NULL,
      1.454287,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.171327,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.774473,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.786963,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.915919,
      1.075711,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.551001,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0.867379,
      15,
      NULL,
      1.125708,
      2,
      0.597960,
      NULL,
      1,
      0,
      0,
      1,
      NULL,
      2,
      NULL,
      1,
      NULL,
      0,
      1.933061,
      0,
      1.187757,
      0.236302,
      NULL,
      1.725135,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      1,
      NULL,
      9,
      1,
      0.898297,
      NULL,
      NULL,
      0.997697,
      NULL,
      1.491643,
      NULL,
      NULL,
      NULL,
      0.233212,
      NULL,
      0.174503,
      NULL,
      1.210311,
      NULL,
      1.300441,
      NULL,
      0.638718,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.129285,
      NULL,
      0.696930,
      NULL,
      0,
      NULL,
      NULL,
      1.294858,
      0.480526,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.059305,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.210166,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.817605,
      3.529531,
      NULL,
      1.494088,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.520225,
      NULL,
      0.099499,
      1.344288,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.624317,
      2.370824,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      14.955554,
      NULL,
      0.441410,
      1,
      0.618246,
      NULL,
      2.354755,
      NULL,
      NULL,
      NULL,
      199.183917,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.692204,
      1.963823,
      38,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.212979,
      5,
      5,
      2.995705,
      2,
      4,
      1,
      3.356059,
      0,
      0.354476,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.635416,
      NULL,
      0,
      3.109236,
      NULL,
      2,
      1.191933,
      NULL,
      3.501375,
      0,
      NULL,
      0.679703,
      2.102258,
      NULL,
      0,
      0,
      NULL,
      1,
      1,
      NULL,
      1.505916,
      0.684105,
      NULL,
      1.277184,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.916851,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1,
      NULL,
      1.657043,
      1.399302,
      NULL,
      30.570519,
      2,
      0.720710,
      6,
      '24422',
      '43121',
      '41323',
      2,
      '44322',
      NULL,
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


