set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8822708';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-8-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      3,
      '2133',
      2,
      NULL,
      NULL,
      NULL,
      ' 2-25-1994',
      NULL,
      NULL,
      NULL,
      2,
      1,
      ' 9-11-2002',
      28,
      2.129575,
      306.792579,
      NULL,
      NULL,
      ' 5-18-1990',
      ' 8-27-2003',
      NULL,
      3,
      0,
      2.581575,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      35,
      4.276503,
      NULL,
      15.060476,
      5,
      3,
      5.062885,
      0.446704,
      1,
      1,
      0,
      0,
      1.564257,
      1.708263,
      0.135179,
      NULL,
      NULL,
      0.514386,
      0,
      5,
      2,
      0,
      0,
      1,
      1,
      4,
      1,
      4,
      3,
      2,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      1.978793,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.050223,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      1,
      5,
      3,
      1,
      0,
      0,
      1,
      1,
      NULL,
      5.333982,
      1,
      0,
      0,
      1,
      0.957002,
      NULL,
      1.780063,
      3,
      NULL,
      1,
      4,
      0,
      3,
      4,
      1,
      4,
      0,
      1,
      1,
      5,
      0,
      5,
      2,
      0,
      3,
      5,
      NULL,
      3,
      4,
      4,
      1,
      0,
      NULL,
      2,
      ' 2-17-1975',
      44.513229,
      ' 5- 7-1976',
      11.898467,
      1.787686,
      1,
      1,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      NULL,
      5,
      0,
      1,
      0.841078,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      59.596156,
      0,
      1.309929,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.612029,
      NULL,
      NULL,
      3,
      0.642261,
      5.289027,
      1,
      NULL,
      NULL,
      NULL,
      2.097036,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.390239,
      1.641980,
      0,
      NULL,
      1,
      0,
      0.436036,
      1,
      52.764610,
      NULL,
      1.960891,
      NULL,
      NULL,
      NULL,
      0,
      0.464611,
      2.056458,
      0,
      3,
      2,
      2,
      2,
      3,
      3,
      NULL,
      3,
      NULL,
      2.277859,
      2.599952,
      2.271454,
      0.464498,
      0.891550,
      1,
      NULL,
      1.187237,
      1,
      NULL,
      NULL,
      NULL,
      1.494555,
      NULL,
      0.551421,
      0,
      3.906844,
      3.866173,
      0,
      6.928094,
      8,
      6.271542,
      9,
      2,
      5.238478,
      3.391794,
      2.189953,
      4.848522,
      2.333607,
      0,
      3.179294,
      15.224631,
      1,
      1,
      NULL,
      55,
      27,
      48.337385,
      4,
      1,
      1.102857,
      '00444',
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      1,
      19,
      NULL,
      9.936040,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.578253,
      2.514546,
      NULL,
      0,
      NULL,
      NULL,
      1.535358,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.351568,
      0.712400,
      0,
      3,
      0.746094,
      1.914688,
      1.649535,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.697384,
      NULL,
      NULL,
      6,
      1.950050,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.325888,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.234083,
      0,
      0.152297,
      1,
      1,
      1.087166,
      2,
      0,
      0.458704,
      NULL,
      NULL,
      NULL,
      1.134230,
      NULL,
      NULL,
      0.712160,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.935638,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.491858,
      7,
      NULL,
      NULL,
      0.795598,
      NULL,
      NULL,
      2,
      1,
      0.234420,
      2,
      0.225821,
      0,
      2.646921,
      NULL,
      1.656966,
      0,
      NULL,
      0,
      2.354607,
      1.791664,
      0,
      2,
      NULL,
      0,
      1.708532,
      3.355232,
      0.420205,
      2,
      2,
      0,
      0,
      9,
      0.548442,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.435962,
      1.113869,
      1,
      1,
      0,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.151056,
      0.487734,
      0,
      0.902093,
      2.723102,
      1.046406,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      14,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      5.428284,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.482321,
      NULL,
      NULL,
      NULL,
      2.403286,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.986841,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.143007,
      NULL,
      NULL,
      NULL,
      1.067486,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1,
      0.168099,
      1.185523,
      0.946392,
      NULL,
      NULL,
      NULL,
      0.852368,
      1.599749,
      1.308501,
      1.474293,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.422170,
      NULL,
      1.770633,
      NULL,
      1,
      0.531550,
      NULL,
      1.760765,
      NULL,
      0,
      0.624758,
      1,
      NULL,
      1.971440,
      1.286181,
      NULL,
      NULL,
      1.426248,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.006265,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      2,
      2,
      NULL,
      3,
      1.889111,
      NULL,
      8,
      2.153473,
      1.510832,
      0,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.506116,
      NULL,
      0.231132,
      1.120606,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      3.167376,
      NULL,
      1,
      NULL,
      NULL,
      0.770698,
      NULL,
      3,
      NULL,
      NULL,
      0.874872,
      NULL,
      0.108135,
      NULL,
      3.911733,
      NULL,
      0,
      NULL,
      1.016204,
      NULL,
      0,
      NULL,
      0.248102,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.059463,
      NULL,
      51.295717,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3,
      NULL,
      3.862533,
      NULL,
      1.717482,
      NULL,
      NULL,
      NULL,
      1.674877,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.077639,
      NULL,
      NULL,
      NULL,
      0,
      5,
      1,
      0.066447,
      NULL,
      NULL,
      79.550849,
      30.822670,
      2,
      0,
      2,
      '10234',
      '',
      '',
      1.626348,
      '',
      '',
      '',
      3.150987,
      '0022',
      '',
      '');
commit;
end;
/


