set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8822708';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-8-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      3,
      '0303',
      1.952515,
      1,
      NULL,
      NULL,
      ' 8-27-1981',
      6.527269,
      NULL,
      5,
      NULL,
      0.673719,
      ' 7- 3-2001',
      38,
      2.823764,
      NULL,
      NULL,
      1,
      '10-20-1994',
      '11- 4-2002',
      ' 0- 3-1994',
      NULL,
      NULL,
      0,
      3,
      0.458545,
      1,
      2,
      2.165474,
      NULL,
      NULL,
      NULL,
      1.035186,
      2.715773,
      31.672808,
      29,
      0,
      5,
      0,
      1,
      3.207452,
      0,
      3,
      1,
      0,
      0.102087,
      0.781765,
      1.356064,
      1,
      1,
      1,
      0.375833,
      3,
      1,
      NULL,
      2,
      NULL,
      0,
      1,
      5,
      1,
      1,
      1,
      3,
      1,
      NULL,
      2,
      1,
      5,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1.293335,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0.838169,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      5,
      4,
      1,
      0,
      1,
      1,
      0,
      1,
      3.090984,
      1,
      0,
      0,
      1,
      0.097883,
      NULL,
      1,
      4,
      0,
      NULL,
      3,
      3,
      0,
      1,
      NULL,
      4,
      1,
      2,
      1,
      3,
      1,
      3,
      NULL,
      4,
      2,
      NULL,
      1,
      2,
      NULL,
      0,
      1,
      0,
      3,
      NULL,
      ' 3- 7-2003',
      69.331511,
      ' 2-27-1980',
      NULL,
      0.416441,
      2,
      0,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      4,
      3,
      0,
      1,
      2.632340,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      76.384294,
      2.052768,
      1.362936,
      NULL,
      1.806888,
      0.111478,
      2.660916,
      1,
      1,
      5,
      1,
      3,
      0.915646,
      NULL,
      NULL,
      3.110236,
      1,
      2.237375,
      2,
      NULL,
      9,
      2.358356,
      1,
      NULL,
      NULL,
      1.251638,
      1.623244,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      1,
      1.104999,
      NULL,
      NULL,
      50,
      1.314210,
      1,
      NULL,
      NULL,
      NULL,
      3,
      0.205953,
      0.195251,
      0,
      0,
      3,
      3,
      2,
      0,
      3,
      1,
      2,
      0,
      NULL,
      NULL,
      1.129686,
      NULL,
      NULL,
      1,
      3,
      NULL,
      0,
      1,
      0,
      0.462644,
      1,
      NULL,
      1.706288,
      0,
      0.576622,
      3,
      1,
      2,
      NULL,
      6.291192,
      0,
      NULL,
      4.519097,
      2.787292,
      1.755278,
      5.408313,
      NULL,
      3,
      2.667733,
      NULL,
      3,
      2,
      NULL,
      41,
      2,
      52,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      '',
      1,
      '',
      '',
      NULL,
      NULL,
      '1403',
      '',
      '',
      0.129746,
      32,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.908746,
      3.526865,
      1,
      NULL,
      NULL,
      NULL,
      3.061012,
      3,
      1.703397,
      NULL,
      2,
      0,
      0.579246,
      NULL,
      NULL,
      1.026191,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.141217,
      NULL,
      NULL,
      0.106297,
      NULL,
      NULL,
      3.471355,
      0.558623,
      1.586803,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.470076,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.070922,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.230498,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.694026,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.879808,
      0.787123,
      0,
      1.600114,
      0,
      1.020828,
      1,
      0.676039,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.047975,
      NULL,
      NULL,
      NULL,
      1.637216,
      1,
      NULL,
      NULL,
      NULL,
      3,
      3,
      0.760515,
      7.228908,
      5.696801,
      1.517945,
      0.747928,
      NULL,
      NULL,
      3,
      NULL,
      1,
      0.924252,
      1.787060,
      1.734255,
      0.036460,
      1.617452,
      0.343662,
      2.210036,
      6,
      1,
      NULL,
      2.856271,
      0.383358,
      1.018652,
      1,
      1,
      NULL,
      1.735973,
      1.200932,
      1.709010,
      1.934365,
      1.310053,
      2,
      4,
      0,
      5,
      1,
      0.139495,
      1.968420,
      NULL,
      NULL,
      1,
      0.481422,
      0,
      0.034710,
      1,
      2.624615,
      NULL,
      NULL,
      2.091679,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.535460,
      NULL,
      NULL,
      1.211447,
      NULL,
      NULL,
      0.407068,
      NULL,
      NULL,
      0.093985,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.615456,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      3.204770,
      NULL,
      1.378101,
      0.160763,
      1.334970,
      3,
      0.336901,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.585945,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.295657,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      15.485511,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.235177,
      NULL,
      NULL,
      NULL,
      0.658978,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.223589,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1,
      2,
      0,
      0.990565,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.620517,
      1.155693,
      NULL,
      NULL,
      1.685802,
      NULL,
      NULL,
      NULL,
      NULL,
      1.687333,
      19435.305460,
      1.742006,
      1,
      1,
      0,
      0.873584,
      NULL,
      NULL,
      0.515085,
      1,
      1.377092,
      0,
      NULL,
      0.311620,
      0.827177,
      1,
      0.331604,
      0.514290,
      0.100330,
      0.747506,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1,
      6,
      NULL,
      3.297480,
      0,
      0,
      12,
      0,
      2.791896,
      1,
      1.997667,
      1.698660,
      NULL,
      0.724667,
      2.940371,
      NULL,
      NULL,
      0.835211,
      NULL,
      0.390715,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1,
      3,
      NULL,
      0.167075,
      1,
      NULL,
      0.010427,
      NULL,
      NULL,
      0.075798,
      0.725292,
      NULL,
      0,
      1,
      NULL,
      1,
      3,
      NULL,
      1.289589,
      NULL,
      3.549074,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.159669,
      NULL,
      2.454679,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.469773,
      NULL,
      1.751898,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.063804,
      NULL,
      NULL,
      NULL,
      17.015206,
      1.917972,
      1,
      3.154115,
      NULL,
      NULL,
      1.698367,
      NULL,
      3,
      NULL,
      1.816524,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3,
      NULL,
      3.898419,
      NULL,
      NULL,
      NULL,
      0.549538,
      NULL,
      0,
      NULL,
      0.322053,
      NULL,
      19,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      3,
      7,
      0,
      NULL,
      NULL,
      91,
      31,
      1,
      0.523484,
      0,
      '40004',
      NULL,
      '',
      0,
      '',
      NULL,
      NULL,
      3.209407,
      '4320',
      NULL,
      '');
commit;
end;
/


